/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AutoHideButton;
import com.vlsolutions.swing.docking.AutoHideButtonPanel;
import com.vlsolutions.swing.docking.AutoHideExpandPanel;
import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainer;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingBorderLayout;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingPanel;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.DragControler;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.RelativeDockingUtilities;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.SplitResizer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableSelectionEvent;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class DockingDesktop
extends JLayeredPane {
    private static final String CURRENT_VERSION_NUMBER = "2.0.5";
    private static final String BUILD_DATE = "2005/12/12";
    private JPanel contentPane = new JPanel(new DockingBorderLayout());
    protected DockingPanel dockingPanel = new DockingPanel();
    protected AutoHideExpandPanel expandPanel = this.createAutoHideExpandPanel();
    protected AutoHideButtonPanel topBorderPane = new AutoHideButtonPanel(this.expandPanel, 0);
    protected AutoHideButtonPanel leftBorderPane = new AutoHideButtonPanel(this.expandPanel, 1);
    protected AutoHideButtonPanel bottomBorderPane = new AutoHideButtonPanel(this.expandPanel, 2);
    protected AutoHideButtonPanel rightBorderPane = new AutoHideButtonPanel(this.expandPanel, 3);
    protected AutoHideButtonPanel[] borderPanes = new AutoHideButtonPanel[]{this.topBorderPane, this.leftBorderPane, this.bottomBorderPane, this.rightBorderPane};
    private HashMap autoHideButtons = new HashMap();
    protected HashMap dockableStates = new HashMap();
    private DragControler dragControler = new DragControler(this);
    protected ArrayList registeredDockables = new ArrayList();
    private ArrayList dockableStateWillChangeListeners = new ArrayList();
    private ArrayList dockableStateChangeListeners = new ArrayList();
    private ArrayList dockableSelectionListeners = new ArrayList();
    private JComponent dummyMaximedReplacer = new JLabel();
    private Component maximizedComponent;
    private boolean currentMaximizedComponentIsHeavyWeight = false;
    private JComponent mouseMotionGrabber = new JComponent(){};
    private Timer mouseOutOfExpandedPanelTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DockingDesktop.this.expandPanel.isActive() && DockingDesktop.this.expandPanel.shouldCollapse()) {
                DockingDesktop.this.expandPanel.collapse();
            }
        }
    });
    protected HashMap tabbedGroups = new HashMap();
    private FocusHandler focusHandler = new FocusHandler();
    protected HashMap previousFloatingDockableStates = new HashMap();
    private Point lastWindowLocation = null;
    private ComponentAdapter windowMovementListener = new ComponentAdapter(){

        public void componentMoved(ComponentEvent e) {
            DockingDesktop.this.moveFloatingWindows();
        }
    };
    private AbstractAction closeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int state;
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isCloseEnabled() && ((state = d.getDockKey().getDockableState()) == 1 || state == 4 || state == 2)) {
                DockingDesktop.this.close(d);
            }
        }
    };
    private AbstractAction maximizeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isMaximizeEnabled()) {
                int state = d.getDockKey().getDockableState();
                if (state == 1) {
                    DockingDesktop.this.maximize(d);
                } else if (state == 3) {
                    DockingDesktop.this.restore(d);
                }
            }
        }
    };
    private AbstractAction dockAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isAutoHideEnabled()) {
                int state = d.getDockKey().getDockableState();
                if (state == 1) {
                    DockingDesktop.this.setAutoHide(d, true);
                } else if (state == 2) {
                    DockingDesktop.this.setAutoHide(d, false);
                }
            }
        }
    };
    private AbstractAction floatAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isFloatEnabled()) {
                int state = d.getDockKey().getDockableState();
                if (state == 1) {
                    DockingDesktop.this.setFloating(d, true);
                } else if (state == 4) {
                    DockingDesktop.this.setFloating(d, false);
                }
            }
        }
    };
    private AbstractAction cancelAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            DockingDesktop.this.dragControler.cancelDrag();
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public DockingDesktop() {
        this.topBorderPane.setVisible(false);
        this.leftBorderPane.setVisible(false);
        this.bottomBorderPane.setVisible(false);
        this.rightBorderPane.setVisible(false);
        this.contentPane.add((Component)this.topBorderPane, "North");
        this.contentPane.add((Component)this.leftBorderPane, "West");
        this.contentPane.add((Component)this.bottomBorderPane, "South");
        this.contentPane.add((Component)this.rightBorderPane, "East");
        this.contentPane.add((Component)this.dockingPanel, "Center");
        this.add((Component)this.contentPane, DEFAULT_LAYER);
        this.mouseMotionGrabber.setVisible(false);
        this.mouseMotionGrabber.addMouseListener(new MouseAdapter(){
            boolean canUseMouseInfo = DockingUtilities.canUseMouseInfo();

            public void mouseEntered(MouseEvent e) {
                if (!this.canUseMouseInfo) {
                    DockingDesktop.this.mouseOutOfExpandedPanelTimer.restart();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (!this.canUseMouseInfo) {
                    DockingDesktop.this.mouseOutOfExpandedPanelTimer.stop();
                }
            }

            public void mousePressed(MouseEvent e) {
                DockingDesktop.this.expandPanel.collapse();
                Window w = SwingUtilities.getWindowAncestor(DockingDesktop.this);
                if (w != null) {
                    w.dispatchEvent(e);
                }
            }
        });
        this.expandPanel.installDocking(this);
        this.expandPanel.setVisible(false);
        this.add((Component)this.mouseMotionGrabber, new Integer(MODAL_LAYER - 1));
        this.add((Component)this.expandPanel, MODAL_LAYER);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                int w = DockingDesktop.this.getWidth();
                int h = DockingDesktop.this.getHeight();
                Insets i = DockingDesktop.this.getDockingPanelInsets();
                if (event.getComponent() == DockingDesktop.this) {
                    DockingDesktop.this.expandPanel.collapse();
                    DockingDesktop.this.contentPane.setBounds(0, 0, w, h);
                    DockingDesktop.this.revalidate();
                } else if (event.getComponent() == DockingDesktop.this.dockingPanel) {
                    if (DockingDesktop.this.maximizedComponent != null) {
                        if (DockingPreferences.isLightWeightUsageEnabled()) {
                            DockingDesktop.this.maximizedComponent.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                        } else if (DockingPreferences.isSingleHeavyWeightComponent()) {
                            if (DockingUtilities.isHeavyWeightComponent(DockingDesktop.this.maximizedComponent)) {
                                DockingDesktop.this.maximizedComponent.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                            } else {
                                DockingDesktop.this.maximizedComponent.getParent().setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                            }
                        } else {
                            DockingDesktop.this.maximizedComponent.getParent().setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                        }
                    }
                    DockingDesktop.this.mouseMotionGrabber.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                    DockingDesktop.this.dockingPanel.revalidate();
                }
            }
        };
        this.addComponentListener(resizeListener);
        this.dockingPanel.addComponentListener(resizeListener);
        this.expandPanel.addPropertyChangeListener("AutoHideExpanded", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    DockingDesktop.this.mouseMotionGrabber.setVisible(true);
                } else {
                    DockingDesktop.this.mouseMotionGrabber.setVisible(false);
                }
            }
        });
        this.mouseOutOfExpandedPanelTimer.setRepeats(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusHandler);
        this.installKeyboardBindings();
        boolean floatingContainerFollowParentWindow = UIManager.getBoolean("FloatingContainer.followParentWindow");
        if (floatingContainerFollowParentWindow) {
            this.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                    Window w = SwingUtilities.getWindowAncestor(DockingDesktop.this);
                    w.addComponentListener(DockingDesktop.this.windowMovementListener);
                }

                public void ancestorRemoved(AncestorEvent event) {
                    Window w = SwingUtilities.getWindowAncestor(event.getAncestorParent());
                    w.removeComponentListener(DockingDesktop.this.windowMovementListener);
                }

                public void ancestorMoved(AncestorEvent event) {
                }
            });
        }
    }

    private void installKeyboardBindings() {
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator");
        if (ks != null) {
            this.getInputMap(1).put(ks, "close");
            this.getActionMap().put("close", this.closeAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "maximize");
            this.getActionMap().put("maximize", this.maximizeAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "dock");
            this.getActionMap().put("dock", this.dockAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "float");
            this.getActionMap().put("float", this.floatAction);
        }
        ks = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(2).put(ks, "cancel");
        this.getActionMap().put("cancel", this.cancelAction);
    }

    public Dockable getSelectedDockable() {
        return this.focusHandler.currentDockable;
    }

    public void setOpaqueContents(boolean opaque) {
        this.contentPane.setOpaque(opaque);
        this.dockingPanel.setOpaque(opaque);
    }

    public boolean isOpaqueContents() {
        return this.contentPane.isOpaque();
    }

    DockingPanel getDockingPanel() {
        return this.dockingPanel;
    }

    public void registerDockable(Dockable dockable) {
        if (!this.registeredDockables.contains(dockable)) {
            this.registeredDockables.add(dockable);
        }
    }

    public void unregisterDockable(Dockable dockable) {
        this.close(dockable);
        this.registeredDockables.remove(dockable);
        this.dockableStates.remove(dockable);
    }

    public static String getDockingFrameworkVersion() {
        return CURRENT_VERSION_NUMBER;
    }

    public static String getDockingFrameworkBuildDate() {
        return BUILD_DATE;
    }

    public void createTab(Dockable base, Dockable dockable, int order) {
        this.createTab(base, dockable, order, false);
    }

    public void createTab(Dockable base, Dockable dockable, int order, boolean select) {
        this.createTab(base, dockable, order, select, true);
    }

    private void createTab(Dockable base, Dockable dockable, int order, boolean select, boolean triggerEvents) {
        boolean stateChange;
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableState currentState = this.getDockableState(dockable);
        DockableState newState = null;
        if (base.getDockKey().getDockableState() == 4) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, dockable);
            newState = new DockableState(dockable, base.getDockKey().getDockableState(), position);
        } else {
            newState = new DockableState(dockable, base.getDockKey().getDockableState());
        }
        DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
        boolean bl = stateChange = currentState == null || currentState.getState() != newState.getState();
        if (triggerEvents && stateChange && !this.fireDockableStateWillChange(event)) {
            return;
        }
        TabbedDockableContainer dockableTab = DockingUtilities.findTabbedDockableContainer(dockable);
        TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer(base);
        if (dockableTab != null && dockableTab != baseTab) {
            this.remove(dockable);
        }
        if (currentState != null && currentState.isFloating() && newState.isFloating()) {
            Window w2;
            Window w = SwingUtilities.getWindowAncestor(dockable.getComponent());
            if (w != (w2 = SwingUtilities.getWindowAncestor(base.getComponent()))) {
                this.remove(dockable);
            }
        } else if (currentState != null && !currentState.isFloating() && newState.isFloating()) {
            this.remove(dockable);
        }
        if (!newState.isFloating()) {
            this.removeFromTabbedGroup(dockable);
        }
        if (baseTab != null) {
            baseTab.addDockable(dockable, order);
        } else {
            SingleDockableContainer baseOldContainer = DockingUtilities.findSingleDockableContainer(base);
            baseTab = DockableContainerFactory.getFactory().createTabbedDockableContainer();
            baseTab.installDocking(this);
            baseTab.addDockable(base, 0);
            baseTab.addDockable(dockable, 1);
            ((JTabbedPane)((Object)baseTab)).addChangeListener(this.focusHandler);
            DockingUtilities.replaceChild(((Component)((Object)baseOldContainer)).getParent(), (Component)((Object)baseOldContainer), (Component)((Object)baseTab));
        }
        if (select) {
            baseTab.setSelectedDockable(dockable);
        }
        this.registerDockable(dockable);
        this.dockableStates.put(dockable, newState);
        if (newState.isFloating() && !currentState.isFloating()) {
            this.storePreviousFloatingState(dockable, currentState);
        }
        if (stateChange && triggerEvents) {
            dockable.getDockKey().setDockableState(base.getDockKey().getDockableState());
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        }
        if (!newState.isFloating()) {
            this.addToTabbedGroup(base, dockable);
        }
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void split(Dockable base, Dockable newDockable, DockingConstants.Split position) {
        Component right;
        Component left;
        DockableStateWillChangeEvent event;
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (newDockable == null) {
            throw new NullPointerException("newDockable must not be null");
        }
        DockableState currentState = this.getDockableState(newDockable);
        boolean stateChange = currentState == null || !currentState.isDocked();
        DockableState newState = new DockableState(newDockable, 1);
        if (stateChange && !this.fireDockableStateWillChange(event = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer(base);
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(newDockable, 2);
        dockableContainer.installDocking(this);
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (baseTab != null) {
            DockingUtilities.replaceChild(((Component)((Object)baseTab)).getParent(), (Component)((Object)baseTab), split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                left = (Component)((Object)dockableContainer);
                right = (Component)((Object)baseTab);
            } else {
                left = (Component)((Object)baseTab);
                right = (Component)((Object)dockableContainer);
            }
        } else {
            SingleDockableContainer baseContainer = DockingUtilities.findSingleDockableContainer(base);
            if (!$assertionsDisabled && baseContainer == null) {
                throw new AssertionError();
            }
            DockingUtilities.replaceChild(((Component)((Object)baseContainer)).getParent(), (Component)((Object)baseContainer), split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                left = (Component)((Object)dockableContainer);
                right = (Component)((Object)baseContainer);
            } else {
                left = (Component)((Object)baseContainer);
                right = (Component)((Object)dockableContainer);
            }
        }
        split.setLeftComponent(left);
        split.setRightComponent(right);
        this.registerDockable(newDockable);
        this.dockableStates.put(newDockable, newState);
        if (stateChange) {
            newDockable.getDockKey().setDockableState(1);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        }
        this.removeFromTabbedGroup(newDockable);
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void splitComponent(Component base, Dockable dockable, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        DockableState currentState = this.getDockableState(dockable);
        boolean stateChange = currentState == null || !currentState.isDocked();
        DockableState newState = new DockableState(dockable, 1);
        if (stateChange) {
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (!this.fireDockableStateWillChange(event)) {
                return;
            }
            if (currentState.isFloating()) {
                this.removePreviousFloatingState(dockable);
            }
        }
        Container oldContainer = (Container)((Object)DockingUtilities.findSingleDockableContainer(dockable));
        int oldWidth = 0;
        int oldHeight = 0;
        if (oldContainer != null) {
            oldWidth = oldContainer.getWidth();
            oldHeight = oldContainer.getHeight();
        } else {
            oldWidth = base.getWidth() / 2;
            oldHeight = base.getHeight() / 2;
        }
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, 2);
        dockableContainer.installDocking(this);
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (base != this.dockingPanel) {
            DockingUtilities.replaceChild(base.getParent(), base, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(base);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(base);
            }
        } else if (this.dockingPanel.getComponentCount() != 0) {
            Component dockingPanelChild = this.dockingPanel.getComponent(0);
            DockingUtilities.replaceChild(this.dockingPanel, dockingPanelChild, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(dockingPanelChild);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(dockingPanelChild);
            }
        } else {
            this.dockingPanel.add((Component)((Object)dockableContainer));
        }
        if (position == DockingConstants.SPLIT_TOP) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldHeight));
        } else if (position == DockingConstants.SPLIT_BOTTOM) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldHeight));
        } else if (position == DockingConstants.SPLIT_LEFT) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldWidth));
        } else if (position == DockingConstants.SPLIT_RIGHT) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldWidth));
        }
        this.registerDockable(dockable);
        this.dockableStates.put(dockable, newState);
        if (stateChange) {
            dockable.getDockKey().setDockableState(1);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        }
        this.removeFromTabbedGroup(dockable);
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void splitComponent(Component base, Container dockablesContainer, DockingConstants.Split position) {
        if (dockablesContainer instanceof SingleDockableContainer) {
            this.splitComponent(base, ((SingleDockableContainer)((Object)dockablesContainer)).getDockable(), position);
        } else if (dockablesContainer instanceof TabbedDockableContainer) {
            this.splitTab(base, (TabbedDockableContainer)((Object)dockablesContainer), position);
        } else {
            System.err.println("unknow split request !" + dockablesContainer);
        }
    }

    private void splitTab(Component base, TabbedDockableContainer tdc, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        Dockable firstDockable = tdc.getDockableAt(0);
        DockableState currentState = this.getDockableState(firstDockable);
        boolean stateChange = false;
        if (currentState.isFloating()) {
            this.removePreviousFloatingStates(tdc);
            stateChange = true;
        }
        Container oldContainer = (Container)((Object)tdc);
        int oldWidth = 0;
        int oldHeight = 0;
        if (oldContainer != null) {
            oldWidth = oldContainer.getWidth();
            oldHeight = oldContainer.getHeight();
        } else {
            oldWidth = base.getWidth() / 2;
            oldHeight = base.getHeight() / 2;
        }
        TabbedDockableContainer dockableContainer = tdc;
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (base != this.dockingPanel) {
            DockingUtilities.replaceChild(base.getParent(), base, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(base);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(base);
            }
        } else if (this.dockingPanel.getComponentCount() != 0) {
            Component dockingPanelChild = this.dockingPanel.getComponent(0);
            DockingUtilities.replaceChild(this.dockingPanel, dockingPanelChild, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(dockingPanelChild);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(dockingPanelChild);
            }
        } else {
            this.dockingPanel.add((Component)((Object)dockableContainer));
        }
        if (position == DockingConstants.SPLIT_TOP) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldHeight));
        } else if (position == DockingConstants.SPLIT_BOTTOM) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldHeight));
        } else if (position == DockingConstants.SPLIT_LEFT) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldWidth));
        } else if (position == DockingConstants.SPLIT_RIGHT) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldWidth));
        }
        if (stateChange) {
            for (int i = 0; i < tdc.getTabCount(); ++i) {
                Dockable d = tdc.getDockableAt(i);
                DockableState newState = new DockableState(d, 1);
                this.dockableStates.put(d, newState);
            }
        }
    }

    public void move(Dockable base, Dockable dockable, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (dockable == base) {
            return;
        }
        this.remove(dockable);
        this.removeFromTabbedGroup(dockable);
        this.split(base, dockable, position);
    }

    private void show(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableState state = (DockableState)this.dockableStates.get(dockable);
        RelativeDockablePosition position = state.getPosition();
        if (position == null) {
            throw new NullPointerException("trying to show a view that was not hidden");
        }
        LinkedList group = (LinkedList)this.tabbedGroups.get(dockable);
        boolean tabbed = false;
        if (group != null) {
            Iterator it = group.iterator();
            while (it.hasNext() && !tabbed) {
                Dockable d = (Dockable)it.next();
                if (d == dockable || !this.getDockableState(d).isDocked()) continue;
                this.createTab(d, dockable, Integer.MAX_VALUE, true, false);
                tabbed = true;
            }
        }
        if (!tabbed) {
            SingleDockableContainer sdc = RelativeDockingUtilities.insertDockable(this.dockingPanel, dockable, position);
            sdc.installDocking(this);
        }
    }

    public void remove(Dockable dockable) {
        int dockState = dockable.getDockKey().getDockableState();
        SingleDockableContainer dockableContainer = null;
        Container parentOfSdc = null;
        if (dockState == 1 || dockState == 4) {
            dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
            parentOfSdc = ((JComponent)((Object)dockableContainer)).getParent();
            this.removeContainer(dockableContainer);
        }
        if (dockState == 4) {
            FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor(dockable.getComponent()));
            if (!(parentOfSdc instanceof TabbedDockableContainer)) {
                DockingUtilities.dispose(fdc);
            }
        } else if (dockState == 2) {
            AutoHideButton btn = (AutoHideButton)this.autoHideButtons.get(dockable.getDockKey());
            btn.setVisible(false);
            this.expandPanel.remove(dockable);
            this.revalidate();
        }
    }

    public void dropRemove(DockableDragSource dragSource) {
        Container dockableContainer = dragSource.getDockableContainer();
        if (dockableContainer instanceof TabbedDockableContainer) {
            this.remove((TabbedDockableContainer)((Object)dockableContainer));
        } else {
            this.remove(dragSource.getDockable());
        }
    }

    private void remove(TabbedDockableContainer tdc) {
        Dockable firstDockable = tdc.getDockableAt(0);
        int dockState = firstDockable.getDockKey().getDockableState();
        if (dockState == 4) {
            FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor((Container)((Object)tdc)));
            DockingUtilities.dispose(fdc);
        }
        boolean invalidateDesktop = true;
        Container parent = ((Component)((Object)tdc)).getParent();
        if (parent != null) {
            if (parent instanceof SplitContainer) {
                SplitContainer viewParent = (SplitContainer)parent;
                if (viewParent.getLeftComponent() == tdc) {
                    viewParent.remove((Component)((Object)tdc));
                    Component other = viewParent.getRightComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                } else {
                    viewParent.remove((Component)((Object)tdc));
                    Component other = viewParent.getLeftComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                }
            } else if (parent == this.dockingPanel) {
                this.dockingPanel.remove(0);
            } else if (SwingUtilities.getWindowAncestor(parent) instanceof FloatingDockableContainer) {
                invalidateDesktop = false;
            } else {
                throw new IllegalStateException("View is not contained in desktop hierarchy " + parent);
            }
            if (invalidateDesktop) {
                this.dockingPanel.invalidate();
                this.dockingPanel.validate();
                this.dockingPanel.repaint();
            }
        }
    }

    public void maximize(Dockable dockable) {
        DockableStateWillChangeEvent event;
        if (dockable.getDockKey().getDockableState() != 1) {
            throw new IllegalArgumentException("Dockable isn't currently in the DOCKED state : " + dockable);
        }
        DockableState currentState = this.getDockableState(dockable);
        boolean stateChange = currentState == null || !currentState.isMaximized();
        DockableState newState = new DockableState(dockable, 3);
        if (stateChange && !this.fireDockableStateWillChange(event = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        SingleDockableContainer sdc = DockingUtilities.findSingleDockableContainer(dockable);
        Component dockableContainer = (Component)((Object)sdc);
        DockingUtilities.replaceChild(dockableContainer.getParent(), dockableContainer, this.dummyMaximedReplacer);
        SingleDockableContainer maxDockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, 0);
        maxDockableContainer.installDocking(this);
        this.maximizedComponent = (Component)((Object)maxDockableContainer);
        Insets i = this.getDockingPanelInsets();
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            this.maximizedComponent.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
            this.add(this.maximizedComponent, JLayeredPane.PALETTE_LAYER);
        } else {
            this.currentMaximizedComponentIsHeavyWeight = false;
            if (DockingPreferences.isSingleHeavyWeightComponent()) {
                Component comp = dockable.getComponent();
                if (DockingUtilities.isHeavyWeightComponent(comp)) {
                    this.maximizedComponent.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                    this.add(this.maximizedComponent, JLayeredPane.PALETTE_LAYER);
                    this.currentMaximizedComponentIsHeavyWeight = true;
                } else {
                    Panel awtPanel = new Panel(new BorderLayout());
                    awtPanel.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                    awtPanel.add(this.maximizedComponent, "Center");
                    awtPanel.validate();
                    this.add((Component)awtPanel, JLayeredPane.PALETTE_LAYER);
                }
            } else {
                Panel awtPanel = new Panel(new BorderLayout());
                awtPanel.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                awtPanel.add(this.maximizedComponent, "Center");
                awtPanel.validate();
                this.add((Component)awtPanel, JLayeredPane.PALETTE_LAYER);
            }
        }
        this.dockableStates.put(dockable, newState);
        dockable.getDockKey().setDockableState(3);
        this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        dockable.getComponent().requestFocus();
        this.repaint();
    }

    public void restore(final Dockable dockable) {
        DockableStateWillChangeEvent event;
        if (dockable.getDockKey().getDockableState() != 3) {
            throw new IllegalArgumentException("Dockable isn't currently in the MAXIMIZED state : " + dockable);
        }
        DockableState currentState = this.getDockableState(dockable);
        boolean stateChange = currentState != null || currentState.isMaximized();
        DockableState newState = new DockableState(dockable, 1);
        if (stateChange && !this.fireDockableStateWillChange(event = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        if (!DockingPreferences.isLightWeightUsageEnabled()) {
            if (DockingPreferences.isSingleHeavyWeightComponent() && this.currentMaximizedComponentIsHeavyWeight) {
                this.remove(this.maximizedComponent);
            } else {
                this.remove(this.maximizedComponent.getParent());
            }
        } else {
            this.remove(this.maximizedComponent);
        }
        ((SingleDockableContainer)((Object)this.maximizedComponent)).uninstallDocking(this);
        SingleDockableContainer sdc = null;
        sdc = this.dummyMaximedReplacer.getParent() instanceof TabbedDockableContainer ? DockableContainerFactory.getFactory().createDockableContainer(dockable, 1) : DockableContainerFactory.getFactory().createDockableContainer(dockable, 2);
        DockingUtilities.replaceChild(this.dummyMaximedReplacer.getParent(), this.dummyMaximedReplacer, (Component)((Object)sdc));
        dockable.getDockKey().setDockableState(1);
        this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        this.dockableStates.put(dockable, newState);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dockable.getComponent().requestFocus();
            }
        });
        sdc.installDocking(this);
        this.maximizedComponent = null;
        this.repaint();
    }

    public void setFloating(Dockable dockable, boolean floating) {
        this.setFloating(dockable, floating, null);
    }

    public void setFloating(Dockable dockable, boolean floating, Point screenPosition) {
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        DockableState currentState = this.getDockableState(dockable);
        SingleDockableContainer dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
        if (floating) {
            int state = dockable.getDockKey().getDockableState();
            RelativeDockablePosition position = null;
            if (state == 1) {
                position = new RelativeDockablePosition(this.dockingPanel, dockable);
            } else if (state == 2) {
                position = currentState.getPosition();
            } else if (state == 4) {
                if (DockingUtilities.findTabbedDockableContainer(dockable) == null) {
                    throw new IllegalArgumentException("floating not tabbed");
                }
            } else {
                if (state == 0) {
                    return;
                }
                throw new IllegalArgumentException("not docked " + state);
            }
            DockableState newState = new DockableState(dockable, 4, position);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (state == 4) {
                Dimension previousSize = null;
                this.remove(dockable);
                if (dockableContainer != null) {
                    previousSize = ((Component)((Object)dockableContainer)).getSize();
                }
                FloatingDockableContainer fdc = this.createFloatingDockableContainer(dockable);
                if (previousSize != null) {
                    DockingUtilities.setSize(fdc, previousSize);
                    DockingUtilities.validate(fdc);
                } else {
                    DockingUtilities.pack(fdc);
                }
                if (screenPosition == null) {
                    DockingUtilities.setLocationRelativeTo(fdc, this);
                } else {
                    DockingUtilities.setLocation(fdc, screenPosition);
                }
                DockingUtilities.setVisible(fdc, true);
            } else if (currentState != null && this.fireDockableStateWillChange(event)) {
                Dimension previousSize = null;
                if (dockableContainer != null) {
                    previousSize = ((Component)((Object)dockableContainer)).getSize();
                }
                this.remove(dockable);
                this.storePreviousFloatingState(dockable, currentState);
                FloatingDockableContainer fdc = this.createFloatingDockableContainer(dockable);
                if (previousSize != null) {
                    DockingUtilities.setSize(fdc, previousSize);
                    DockingUtilities.validate(fdc);
                } else {
                    DockingUtilities.pack(fdc);
                }
                if (screenPosition == null) {
                    DockingUtilities.setLocationRelativeTo(fdc, this);
                } else {
                    DockingUtilities.setLocation(fdc, screenPosition);
                }
                DockingUtilities.setVisible(fdc, true);
                this.dockableStates.put(dockable, newState);
                dockable.getDockKey().setDockableState(4);
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        } else {
            DockableState previousState = this.removePreviousFloatingState(dockable);
            DockableState newState = new DockableState(dockable, previousState.getState(), previousState.getPosition());
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (currentState != null && currentState.isFloating() && this.fireDockableStateWillChange(event)) {
                Container parentOfSdc = null;
                parentOfSdc = ((JComponent)((Object)dockableContainer)).getParent();
                this.removeContainer(dockableContainer);
                FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor(dockable.getComponent()));
                if (!(parentOfSdc instanceof TabbedDockableContainer)) {
                    DockingUtilities.dispose(fdc);
                }
                if (previousState.isDocked()) {
                    this.show(dockable);
                } else if (previousState.isHidden()) {
                    this.floatingToHide(dockable, previousState.getPosition());
                } else {
                    throw new RuntimeException();
                }
                this.dockableStates.put(dockable, newState);
                dockable.getDockKey().setDockableState(previousState.getState());
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
                dockable.getComponent().requestFocus();
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        }
    }

    void setFloating(TabbedDockableContainer tdc, Point screenPosition) {
        Dockable firstDockable = tdc.getDockableAt(0);
        DockableState currentState = this.getDockableState(firstDockable);
        if (!currentState.isDocked()) {
            throw new IllegalArgumentException("not docked");
        }
        if (this.checkDockableStateWillChange(tdc, 4)) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, firstDockable);
            Dimension previousSize = ((Component)((Object)tdc)).getSize();
            this.remove(tdc);
            this.storePreviousFloatingStates(tdc);
            FloatingDockableContainer fdc = this.createFloatingDockableContainer(tdc);
            DockingUtilities.setSize(fdc, previousSize);
            DockingUtilities.validate(fdc);
            if (screenPosition == null) {
                DockingUtilities.setLocationRelativeTo(fdc, this);
            } else {
                DockingUtilities.setLocation(fdc, screenPosition);
            }
            DockingUtilities.setVisible(fdc, true);
            this.fireStateChanged(tdc, 4, position);
            DockingUtilities.updateResizeWeights(this.dockingPanel);
            this.revalidate();
        }
    }

    private void storePreviousFloatingStates(TabbedDockableContainer tdc) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            DockableState current = this.getDockableState(d);
            this.storePreviousFloatingState(d, current);
        }
    }

    private boolean checkDockableStateWillChange(TabbedDockableContainer tdc, int futureState) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            DockableState newState;
            Dockable d = tdc.getDockableAt(i);
            DockableState currentState = this.getDockableState(d);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState = new DockableState(d, futureState, null));
            if (this.fireDockableStateWillChange(event)) continue;
            return false;
        }
        return true;
    }

    private void fireStateChanged(TabbedDockableContainer tdc, int futureState, RelativeDockablePosition position) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            DockableState currentState = this.getDockableState(d);
            DockableState newState = new DockableState(d, futureState, position);
            this.dockableStates.put(d, newState);
            d.getDockKey().setDockableState(4);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        }
    }

    private DockableState removePreviousFloatingStates(TabbedDockableContainer tdc) {
        DockableState first = this.removePreviousFloatingState(tdc.getDockableAt(0));
        for (int i = 1; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            this.removePreviousFloatingState(d);
        }
        return first;
    }

    public DockableState getPreviousDockableState(Dockable dockable) {
        return (DockableState)this.previousFloatingDockableStates.get(dockable);
    }

    private DockableState removePreviousFloatingState(Dockable dockable) {
        return (DockableState)this.previousFloatingDockableStates.remove(dockable);
    }

    private void storePreviousFloatingState(Dockable dockable, DockableState state) {
        this.previousFloatingDockableStates.put(dockable, state);
    }

    private void floatingToHide(Dockable dockable, RelativeDockablePosition position) {
        DockKey k = dockable.getDockKey();
        AutoHideButton btn = (AutoHideButton)this.autoHideButtons.get(k);
        if (btn == null) {
            btn = new AutoHideButton();
            this.autoHideButtons.put(k, btn);
            int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
            btn.init(dockable, zone);
            this.borderPanes[zone].setVisible(true);
            this.borderPanes[zone].add(btn);
            this.borderPanes[zone].revalidate();
        } else {
            int zone = btn.getZone();
            this.borderPanes[zone].setVisible(true);
            btn.setVisible(true);
            this.borderPanes[zone].revalidate();
        }
    }

    private void moveFloatingWindows() {
        Window w = SwingUtilities.getWindowAncestor(this);
        Point newLocation = w.getLocation();
        if (this.lastWindowLocation != null) {
            int dx = newLocation.x - this.lastWindowLocation.x;
            int dy = newLocation.y - this.lastWindowLocation.y;
            Window[] childWindow = w.getOwnedWindows();
            for (int i = 0; i < childWindow.length; ++i) {
                if (!(childWindow[i] instanceof FloatingDockableContainer) || !childWindow[i].isVisible()) continue;
                Point p = childWindow[i].getLocation();
                childWindow[i].setLocation(p.x + dx, p.y + dy);
            }
        }
        this.lastWindowLocation = newLocation;
    }

    protected FloatingDockableContainer createFloatingDockableContainer(Dockable dockable) {
        Window ownerWindow = SwingUtilities.getWindowAncestor(this);
        FloatingDockableContainer fdc = DockableContainerFactory.getFactory().createFloatingDockableContainer(ownerWindow);
        fdc.installDocking(this);
        fdc.setInitialDockable(dockable);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            JRootPane root = DockingUtilities.getRootPane(fdc);
            root.getInputMap(2).put(ks, "float");
            root.getActionMap().put("float", this.floatAction);
        }
        return fdc;
    }

    protected FloatingDockableContainer createFloatingDockableContainer(TabbedDockableContainer tdc) {
        Window ownerWindow = SwingUtilities.getWindowAncestor(this);
        FloatingDockableContainer fdc = DockableContainerFactory.getFactory().createFloatingDockableContainer(ownerWindow);
        fdc.installDocking(this);
        fdc.setInitialTabbedDockableContainer(tdc);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            JRootPane root = DockingUtilities.getRootPane(fdc);
            root.getInputMap(2).put(ks, "float");
            root.getActionMap().put("float", this.floatAction);
        }
        return fdc;
    }

    protected void removeContainer(SingleDockableContainer dc) {
        dc.uninstallDocking(this);
        boolean invalidateDesktop = true;
        Container parent = ((Component)((Object)dc)).getParent();
        if (parent != null) {
            if (parent instanceof SplitContainer) {
                SplitContainer viewParent = (SplitContainer)parent;
                if (viewParent.getLeftComponent() == dc) {
                    viewParent.remove((Component)((Object)dc));
                    Component other = viewParent.getRightComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                } else {
                    viewParent.remove((Component)((Object)dc));
                    Component other = viewParent.getLeftComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                }
            } else if (parent instanceof TabbedDockableContainer) {
                TabbedDockableContainer tparent = (TabbedDockableContainer)((Object)parent);
                tparent.removeDockable(dc.getDockable());
                if (tparent.getTabCount() == 1) {
                    tparent.uninstallDocking(this);
                    ((JTabbedPane)((Object)tparent)).removeChangeListener(this.focusHandler);
                    Dockable last = tparent.getDockableAt(0);
                    boolean floating = last.getDockKey().getDockableState() == 4;
                    SingleDockableContainer lastContainer = null;
                    lastContainer = floating ? DockableContainerFactory.getFactory().createDockableContainer(last, 3) : DockableContainerFactory.getFactory().createDockableContainer(last, 2);
                    lastContainer.installDocking(this);
                    DockingUtilities.replaceChild(((Component)((Object)tparent)).getParent(), (Component)((Object)tparent), (Component)((Object)lastContainer));
                }
            } else if (parent == this.dockingPanel) {
                this.dockingPanel.remove(0);
            } else if (SwingUtilities.getWindowAncestor(parent) instanceof FloatingDockableContainer) {
                invalidateDesktop = false;
            } else {
                throw new IllegalStateException("View is not contained in desktop hierarchy " + parent);
            }
            if (invalidateDesktop) {
                this.dockingPanel.invalidate();
                this.dockingPanel.validate();
                this.dockingPanel.repaint();
            }
        }
    }

    public DockableState getDockableState(Dockable dockable) {
        return (DockableState)this.dockableStates.get(dockable);
    }

    public void close(Dockable dockable) {
        DockableState currentState = this.getDockableState(dockable);
        RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, dockable);
        DockableState newState = new DockableState(dockable, 0, position);
        DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
        if (this.dockingPanel.isAncestorOf(dockable.getComponent())) {
            if (this.fireDockableStateWillChange(event)) {
                this.remove(dockable);
                this.removeFromTabbedGroup(dockable);
                this.dockableStates.put(dockable, newState);
                dockable.getDockKey().setDockableState(0);
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
                DockingUtilities.updateResizeWeights(this.dockingPanel);
            }
        } else if (currentState.isHidden()) {
            if (this.fireDockableStateWillChange(event)) {
                this.remove(dockable);
                this.removeFromTabbedGroup(dockable);
                this.dockableStates.put(dockable, new DockableState(dockable, 0, currentState.getPosition()));
                dockable.getDockKey().setDockableState(0);
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
            }
        } else if (currentState.isFloating() && this.fireDockableStateWillChange(event)) {
            this.remove(dockable);
            this.removeFromTabbedGroup(dockable);
            this.dockableStates.put(dockable, newState);
            dockable.getDockKey().setDockableState(0);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
        }
    }

    public void closeAllOtherDockablesInTab(Dockable exception) {
        TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(exception);
        if (tabContainer != null) {
            int i;
            ArrayList<Dockable> dockables = new ArrayList<Dockable>(tabContainer.getTabCount() - 1);
            for (i = 0; i < tabContainer.getTabCount(); ++i) {
                if (tabContainer.getDockableAt(i) == exception) continue;
                dockables.add(tabContainer.getDockableAt(i));
            }
            for (i = 0; i < dockables.size(); ++i) {
                Dockable d = (Dockable)dockables.get(i);
                if (!d.getDockKey().isCloseEnabled()) continue;
                this.close(d);
            }
        }
    }

    public void closeAllDockablesInTab(Dockable base) {
        TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(base);
        if (tabContainer != null) {
            int i;
            ArrayList<Dockable> dockables = new ArrayList<Dockable>(tabContainer.getTabCount());
            for (i = 0; i < tabContainer.getTabCount(); ++i) {
                dockables.add(tabContainer.getDockableAt(i));
            }
            for (i = 0; i < dockables.size(); ++i) {
                Dockable d = (Dockable)dockables.get(i);
                if (!d.getDockKey().isCloseEnabled()) continue;
                this.close(d);
            }
        }
    }

    public void setAutoHide(Dockable dockable, boolean hide) {
        DockKey k = dockable.getDockKey();
        DockableState currentState = this.getDockableState(dockable);
        if (hide) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, dockable);
            DockableState newState = new DockableState(dockable, 2, position);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (currentState != null && !currentState.isHidden() && this.fireDockableStateWillChange(event)) {
                AutoHideButton btn = (AutoHideButton)this.autoHideButtons.get(k);
                if (btn == null) {
                    btn = new AutoHideButton();
                    this.autoHideButtons.put(k, btn);
                    int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
                    btn.init(dockable, zone);
                    this.borderPanes[zone].setVisible(true);
                    this.borderPanes[zone].add(btn);
                    this.borderPanes[zone].revalidate();
                } else {
                    int zone = btn.getZone();
                    this.borderPanes[zone].setVisible(true);
                    btn.setVisible(true);
                    this.borderPanes[zone].revalidate();
                }
                this.hide(dockable);
                this.dockableStates.put(dockable, newState);
                k.setDockableState(2);
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        } else {
            DockableState newState = new DockableState(dockable, 1);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (!currentState.isDocked() && this.fireDockableStateWillChange(event)) {
                AutoHideButton btn = (AutoHideButton)this.autoHideButtons.get(k);
                if (!$assertionsDisabled && btn == null) {
                    throw new AssertionError();
                }
                int zone = btn.getZone();
                btn.setVisible(false);
                this.expandPanel.collapse();
                if (this.borderPanes[zone].getVisibleButtonCount() == 0) {
                    this.borderPanes[zone].setVisible(false);
                    this.revalidate();
                }
                this.expandPanel.remove(dockable);
                this.show(dockable);
                this.dockableStates.put(dockable, newState);
                k.setDockableState(1);
                this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        }
    }

    private void hide(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        SingleDockableContainer dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
        if (dockableContainer == null || !this.dockingPanel.isAncestorOf((Component)((Object)dockableContainer))) {
            throw new IllegalArgumentException("not docked");
        }
        this.remove(dockable);
    }

    public Insets getDockingPanelInsets() {
        Insets i = new Insets(0, 0, 0, 0);
        if (this.topBorderPane != null && this.topBorderPane.isVisible()) {
            i.top += this.topBorderPane.getHeight();
        }
        if (this.leftBorderPane != null && this.leftBorderPane.isVisible()) {
            i.left += this.leftBorderPane.getWidth();
        }
        if (this.bottomBorderPane != null && this.bottomBorderPane.isVisible()) {
            i.bottom += this.bottomBorderPane.getHeight();
        }
        if (this.rightBorderPane != null && this.rightBorderPane.isVisible()) {
            i.right += this.rightBorderPane.getWidth();
        }
        return i;
    }

    public DockableState[] getDockables() {
        DockableState[] states = new DockableState[this.registeredDockables.size()];
        for (int i = 0; i < states.length; ++i) {
            DockableState closed;
            Dockable d = (Dockable)this.registeredDockables.get(i);
            states[i] = (DockableState)this.dockableStates.get(d);
            if (states[i] != null) continue;
            states[i] = closed = new DockableState(d, 0);
        }
        return states;
    }

    public void installDockableDragSources(DockableDragSource[] sources) {
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                this.installDockableDragSource(sources[i]);
            }
        }
    }

    public void uninstallDockableDragSources(DockableDragSource[] sources) {
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                this.uninstallDockableDragSource(sources[i]);
            }
        }
    }

    public void installDockableDragSource(DockableDragSource source) {
        ((Component)((Object)source)).addMouseListener(this.dragControler);
        ((Component)((Object)source)).addMouseMotionListener(this.dragControler);
    }

    public void uninstallDockableDragSource(DockableDragSource source) {
        ((Component)((Object)source)).removeMouseListener(this.dragControler);
        ((Component)((Object)source)).removeMouseMotionListener(this.dragControler);
    }

    public void resetToPreferredSize() {
        this.dockingPanel.resetToPreferredSize();
    }

    public void writeXML(OutputStream stream) throws IOException {
        PrintWriter out = new PrintWriter(stream);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<DockingDesktop version=\"2.0\">");
        out.println("<DockingPanel>");
        if (this.dockingPanel.getComponentCount() > 0) {
            this.xmlWriteComponent(this.dockingPanel.getComponent(0), out);
        }
        out.println("</DockingPanel>");
        for (int i = 0; i < this.borderPanes.length; ++i) {
            this.xmlWriteBorder(this.borderPanes[i], out);
        }
        this.xmlWriteFloating(out);
        this.xmlWriteTabGroups(out);
        out.println("</DockingDesktop>");
        out.flush();
    }

    private void xmlWriteBorder(AutoHideButtonPanel borderPanel, PrintWriter out) {
        if (borderPanel.isVisible()) {
            out.println("<Border zone=\"" + borderPanel.getBorderZone() + "\">");
            Component[] comps = borderPanel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof AutoHideButton)) continue;
                this.xmlWriteBorderDockable((AutoHideButton)comps[i], out);
            }
            out.println("</Border>");
        }
    }

    private void xmlWriteFloating(PrintWriter out) {
        ArrayList<Dockable> processedDockables = new ArrayList<Dockable>();
        Window desktopWindow = SwingUtilities.getWindowAncestor(this);
        Point windowLocation = desktopWindow != null ? desktopWindow.getLocation() : new Point();
        for (int i = 0; i < this.registeredDockables.size(); ++i) {
            Dockable d;
            DockableState state = (DockableState)this.dockableStates.get(this.registeredDockables.get(i));
            if (state == null || !state.isFloating() || processedDockables.contains(d = (Dockable)this.registeredDockables.get(i))) continue;
            Window w = SwingUtilities.getWindowAncestor(d.getComponent());
            Rectangle r = w.getBounds();
            out.println("<Floating x=\"" + (r.x - windowLocation.x) + "\" y=\"" + (r.y - windowLocation.y) + "\" width=\"" + r.width + "\" height=\"" + r.height + "\">");
            TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(d);
            if (tabContainer != null) {
                for (int t = 0; t < tabContainer.getTabCount(); ++t) {
                    Dockable tabDockable = tabContainer.getDockableAt(t);
                    processedDockables.add(tabDockable);
                    this.xmlWriteFloatingDockable(tabDockable, out);
                }
            } else {
                processedDockables.add(d);
                this.xmlWriteFloatingDockable(d, out);
            }
            out.println("</Floating>");
        }
    }

    private void xmlWriteComponent(Component comp, PrintWriter out) throws IOException {
        if (comp instanceof SplitContainer) {
            this.xmlWriteSplit((SplitContainer)comp, out);
        } else if (comp instanceof TabbedDockableContainer) {
            this.xmlWriteTab((TabbedDockableContainer)((Object)comp), out);
        } else if (comp instanceof SingleDockableContainer) {
            this.xmlWriteDockable(((SingleDockableContainer)((Object)comp)).getDockable(), out);
        }
    }

    private void xmlWriteTab(TabbedDockableContainer tpane, PrintWriter out) {
        out.println("<TabbedDockable>");
        for (int i = 0; i < tpane.getTabCount(); ++i) {
            this.xmlWriteDockable(tpane.getDockableAt(i), out);
        }
        out.println("</TabbedDockable>");
    }

    private void xmlWriteDockable(Dockable dockable, PrintWriter out) {
        out.println("<Dockable>");
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("</Dockable>");
    }

    private void xmlWriteBorderDockable(AutoHideButton btn, PrintWriter out) {
        if (btn.isVisible()) {
            Dockable dockable = btn.getDockable();
            this.xmlWriteDockableWithRelativePosition(dockable, out);
        }
    }

    private void xmlWriteDockableWithRelativePosition(Dockable dockable, PrintWriter out) {
        DockableState state = (DockableState)this.dockableStates.get(dockable);
        RelativeDockablePosition position = state.getPosition();
        out.println("<Dockable>");
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        out.println("</Dockable>");
    }

    private void xmlWriteFloatingDockable(Dockable dockable, PrintWriter out) {
        DockableState state = (DockableState)this.dockableStates.get(dockable);
        RelativeDockablePosition position = state.getPosition();
        out.println("<Dockable>");
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        DockableState prev = (DockableState)this.previousFloatingDockableStates.get(dockable);
        out.println("<PreviousState state=\"" + prev.getState() + "\"/>");
        out.println("</Dockable>");
    }

    private void xmlWriteSplit(SplitContainer split, PrintWriter out) throws IOException {
        double location = split.getOrientation() == 1 ? (double)split.getLeftComponent().getWidth() / (double)split.getWidth() : (double)split.getLeftComponent().getHeight() / (double)split.getHeight();
        out.println("<Split orientation=\"" + split.getOrientation() + "\" location=\"" + location + "\">");
        this.xmlWriteComponent(split.getLeftComponent(), out);
        this.xmlWriteComponent(split.getRightComponent(), out);
        out.println("</Split>");
    }

    private void xmlWriteTabGroups(PrintWriter out) {
        Iterator listIt;
        ArrayList<LinkedList> uniqueGroups = new ArrayList<LinkedList>();
        ArrayList<Dockable> processedDockables = new ArrayList<Dockable>();
        Iterator it = this.tabbedGroups.keySet().iterator();
        while (it.hasNext()) {
            Dockable d = (Dockable)it.next();
            if (processedDockables.contains(d)) continue;
            processedDockables.add(d);
            LinkedList tabList = (LinkedList)this.tabbedGroups.get(d);
            listIt = tabList.iterator();
            while (listIt.hasNext()) {
                Dockable d2 = (Dockable)listIt.next();
                if (processedDockables.contains(d2)) continue;
                processedDockables.add(d2);
            }
            uniqueGroups.add(tabList);
        }
        out.println("<TabGroups>");
        for (int i = 0; i < uniqueGroups.size(); ++i) {
            out.println("<TabGroup>");
            LinkedList group = (LinkedList)uniqueGroups.get(i);
            listIt = group.iterator();
            while (listIt.hasNext()) {
                Dockable d = (Dockable)listIt.next();
                this.xmlWriteDockable(d, out);
            }
            out.println("</TabGroup>");
        }
        out.println("</TabGroups>");
    }

    public void readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this.dockingPanel.removeAll();
        for (int i = 0; i < this.borderPanes.length; ++i) {
            this.borderPanes[i].removeAll();
            this.borderPanes[i].setVisible(false);
        }
        boolean wasHeavyMaximized = false;
        if (this.maximizedComponent != null) {
            if (DockingPreferences.isLightWeightUsageEnabled()) {
                this.remove(this.maximizedComponent);
            } else {
                this.remove(this.maximizedComponent.getParent());
                wasHeavyMaximized = true;
            }
        }
        this.dockableStates.clear();
        this.autoHideButtons.clear();
        this.expandPanel.collapse();
        this.expandPanel.clear();
        this.previousFloatingDockableStates.clear();
        this.tabbedGroups.clear();
        for (int i = 0; i < this.registeredDockables.size(); ++i) {
            Dockable d = (Dockable)this.registeredDockables.get(i);
            if (d.getDockKey().getDockableState() != 4) continue;
            this.remove(d);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            this.xmlBuildRootNode(child);
        }
        this.revalidate();
    }

    private void xmlBuildRootNode(Node node) throws SAXException {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            String name = elt.getNodeName();
            if (name.equals("DockingPanel")) {
                NodeList children = elt.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.xmlBuildDockingPanelNode(elt.getChildNodes().item(i));
                }
            } else if (name.equals("Border")) {
                int zone = Integer.parseInt(elt.getAttribute("zone"));
                AutoHideButtonPanel borderPanel = this.borderPanes[zone];
                borderPanel.setVisible(true);
                NodeList children = elt.getElementsByTagName("Dockable");
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.xmlBuildAutoHideNode(borderPanel, (Element)children.item(i));
                }
                borderPanel.revalidate();
            } else if (name.equals("Floating")) {
                int x = Integer.parseInt(elt.getAttribute("x"));
                int y = Integer.parseInt(elt.getAttribute("y"));
                int width = Integer.parseInt(elt.getAttribute("width"));
                int height = Integer.parseInt(elt.getAttribute("height"));
                NodeList children = elt.getElementsByTagName("Dockable");
                this.xmlBuildFloatingNode(children, new Rectangle(x, y, width, height));
            } else if (name.equals("TabGroups")) {
                NodeList children = elt.getElementsByTagName("TabGroup");
                this.xmlBuildTabGroup(children);
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }
    }

    private void xmlBuildAutoHideNode(AutoHideButtonPanel borderPanel, Element dockableElt) {
        Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
        float x = Float.parseFloat(hideElt.getAttribute("x"));
        float y = Float.parseFloat(hideElt.getAttribute("y"));
        float w = Float.parseFloat(hideElt.getAttribute("w"));
        float h = Float.parseFloat(hideElt.getAttribute("h"));
        RelativeDockablePosition position = new RelativeDockablePosition(x, y, w, h);
        AutoHideButton btn = new AutoHideButton();
        Dockable dockable = this.xmlGetDockable(dockableElt);
        this.autoHideButtons.put(dockable.getDockKey(), btn);
        this.dockableStates.put(dockable, new DockableState(dockable, 2, position));
        dockable.getDockKey().setDockableState(2);
        btn.init(dockable, borderPanel.getBorderZone());
        borderPanel.add(btn);
    }

    private void xmlBuildFloatingNode(NodeList dockables, Rectangle bounds) {
        Window desktopWindow = SwingUtilities.getWindowAncestor(this);
        if (desktopWindow != null) {
            Point windowLocation = desktopWindow.getLocation();
            bounds.x += windowLocation.x;
            bounds.y += windowLocation.y;
        }
        FloatingDockableContainer fdc = null;
        TabbedDockableContainer tdc = null;
        if (dockables.getLength() > 1) {
            tdc = DockableContainerFactory.getFactory().createTabbedDockableContainer();
            tdc.installDocking(this);
            ((JTabbedPane)((Object)tdc)).addChangeListener(this.focusHandler);
        }
        Dockable baseDockable = null;
        for (int i = 0; i < dockables.getLength(); ++i) {
            Element dockableElt = (Element)dockables.item(i);
            Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
            float x = Float.parseFloat(hideElt.getAttribute("x"));
            float y = Float.parseFloat(hideElt.getAttribute("y"));
            float w = Float.parseFloat(hideElt.getAttribute("w"));
            float h = Float.parseFloat(hideElt.getAttribute("h"));
            RelativeDockablePosition position = new RelativeDockablePosition(x, y, w, h);
            Dockable dockable = this.xmlGetDockable(dockableElt);
            if (i == 0) {
                baseDockable = dockable;
            }
            Element previousState = (Element)dockableElt.getElementsByTagName("PreviousState").item(0);
            int istate = Integer.parseInt(previousState.getAttribute("state"));
            DockableState state = new DockableState(dockable, istate, position);
            this.storePreviousFloatingState(dockable, state);
            if (fdc == null) {
                fdc = this.createFloatingDockableContainer(dockable);
            } else {
                if (tdc.getTabCount() == 0) {
                    DockableContainer base = DockingUtilities.findDockableContainer(baseDockable);
                    DockingUtilities.replaceChild(((Component)((Object)base)).getParent(), (Component)((Object)base), (Component)((Object)tdc));
                    tdc.addDockable(baseDockable, 0);
                }
                tdc.addDockable(dockable, tdc.getTabCount());
            }
            this.dockableStates.put(dockable, new DockableState(dockable, 4, position));
            dockable.getDockKey().setDockableState(4);
        }
        DockingUtilities.setBounds(fdc, bounds);
        DockingUtilities.validate(fdc);
        DockingUtilities.setVisible(fdc, true);
    }

    private void xmlBuildDockingPanelNode(Node node) throws SAXException {
        if (node.getNodeType() == 1) {
            Component comp = this.xmlCreateComponent((Element)node);
            this.dockingPanel.add(comp, "Center");
        }
    }

    private Component xmlCreateComponent(Element elt) throws SAXException {
        if (elt.getNodeName().equals("Split")) {
            SplitContainer split = this.xmlBuildSplitContainer(elt);
            return split;
        }
        if (elt.getNodeName().equals("Dockable")) {
            Dockable d = this.xmlGetDockable(elt);
            SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(d, 2);
            this.dockableStates.put(d, new DockableState(d, 1));
            d.getDockKey().setDockableState(1);
            sdc.installDocking(this);
            return (Component)((Object)sdc);
        }
        if (elt.getNodeName().equals("TabbedDockable")) {
            TabbedDockableContainer tdc = this.xmlBuildTabbedDockableContainer(elt);
            return (Component)((Object)tdc);
        }
        throw new SAXNotRecognizedException(elt.getNodeName());
    }

    private SplitContainer xmlBuildSplitContainer(Node node) throws SAXException {
        Element elt = (Element)node;
        int orientation = Integer.parseInt(elt.getAttribute("orientation"));
        String loc = elt.getAttribute("location");
        double location = 0.5;
        if (loc != null && !loc.equals("")) {
            location = Double.parseDouble(loc);
        }
        SplitContainer split = new SplitContainer(orientation);
        split.setDividerLocation(location);
        boolean left = true;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            Component comp = this.xmlCreateComponent((Element)child);
            if (left) {
                split.setLeftComponent(comp);
                left = false;
                continue;
            }
            split.setRightComponent(comp);
        }
        return split;
    }

    private TabbedDockableContainer xmlBuildTabbedDockableContainer(Element elt) {
        TabbedDockableContainer tdc = DockableContainerFactory.getFactory().createTabbedDockableContainer();
        tdc.installDocking(this);
        ((JTabbedPane)((Object)tdc)).addChangeListener(this.focusHandler);
        for (int i = 0; i < elt.getChildNodes().getLength(); ++i) {
            Node child = elt.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            Dockable d = this.xmlGetDockable((Element)child);
            this.dockableStates.put(d, new DockableState(d, 1));
            d.getDockKey().setDockableState(1);
            tdc.addDockable(d, tdc.getTabCount());
        }
        return tdc;
    }

    private Dockable xmlGetDockable(Element dockableElt) {
        Element key = (Element)dockableElt.getElementsByTagName("Key").item(0);
        String name = key.getAttribute("dockName");
        Dockable dockable = null;
        for (int i = 0; i < this.registeredDockables.size(); ++i) {
            Dockable d = (Dockable)this.registeredDockables.get(i);
            if (!d.getDockKey().getKey().equals(name)) continue;
            dockable = d;
            break;
        }
        if (dockable == null) {
            throw new NullPointerException("Dockable " + name + " not registered");
        }
        return dockable;
    }

    private void xmlBuildTabGroup(NodeList group) {
        for (int i = 0; i < group.getLength(); ++i) {
            Element groupElt = (Element)group.item(i);
            NodeList dockables = groupElt.getElementsByTagName("Dockable");
            Dockable base = null;
            for (int j = 0; j < dockables.getLength(); ++j) {
                Element dockableElt = (Element)dockables.item(j);
                Dockable d = this.xmlGetDockable(dockableElt);
                if (j == 0) {
                    base = d;
                    continue;
                }
                this.addToTabbedGroup(base, d);
            }
        }
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, new RelativeDockablePosition(0.0, 0.8, 0.5, 0.2));
    }

    public void addDockable(Dockable dockable, RelativeDockablePosition position) {
        DockableState newState;
        if (this.isAncestorOf(dockable.getComponent())) {
            throw new IllegalArgumentException("Dockable is already contained in the desktop");
        }
        DockableState currentState = this.getDockableState(dockable);
        DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState = new DockableState(dockable, 1, position));
        if (this.fireDockableStateWillChange(event)) {
            SingleDockableContainer sdc = RelativeDockingUtilities.insertDockable(this.dockingPanel, dockable, position);
            this.registerDockable(dockable);
            sdc.installDocking(this);
            this.dockableStates.put(dockable, newState);
            dockable.getDockKey().setDockableState(1);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
            DockingUtilities.updateResizeWeights(this.dockingPanel);
        }
    }

    public Dimension getPreferredSize() {
        Insets i = this.getDockingPanelInsets();
        Dimension dim = this.dockingPanel.getPreferredSize();
        dim.width += i.left + i.right;
        dim.height += i.top + i.bottom;
        return dim;
    }

    public void addDockableStateChangeListener(DockableStateChangeListener listener) {
        if (!this.dockableStateChangeListeners.contains(listener)) {
            this.dockableStateChangeListeners.add(listener);
        }
    }

    public void removeDockableStateChangeListener(DockableStateChangeListener listener) {
        this.dockableStateChangeListeners.remove(listener);
    }

    public void addDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        if (!this.dockableStateWillChangeListeners.contains(listener)) {
            this.dockableStateWillChangeListeners.add(listener);
        }
    }

    public void removeDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        this.dockableStateWillChangeListeners.remove(listener);
    }

    void fireDockableStateChange(DockableStateChangeEvent e) {
        for (int i = 0; i < this.dockableStateChangeListeners.size(); ++i) {
            DockableStateChangeListener listener = (DockableStateChangeListener)this.dockableStateChangeListeners.get(i);
            listener.dockableStateChanged(e);
        }
    }

    boolean fireDockableStateWillChange(DockableStateWillChangeEvent e) {
        SingleDockableContainer max;
        if (this.maximizedComponent != null && (max = (SingleDockableContainer)((Object)this.maximizedComponent)).getDockable() != e.getCurrentState().getDockable() && e.getFutureState().isDocked()) {
            return false;
        }
        for (int i = 0; i < this.dockableStateWillChangeListeners.size(); ++i) {
            DockableStateWillChangeListener listener = (DockableStateWillChangeListener)this.dockableStateWillChangeListeners.get(i);
            listener.dockableStateWillChange(e);
            if (e.isAccepted()) continue;
            return false;
        }
        return true;
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        if (!this.dockableSelectionListeners.contains(listener)) {
            this.dockableSelectionListeners.add(listener);
        }
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.dockableSelectionListeners.remove(listener);
    }

    void fireDockableSelectionChange(DockableSelectionEvent e) {
        for (int i = 0; i < this.dockableSelectionListeners.size(); ++i) {
            DockableSelectionListener listener = (DockableSelectionListener)this.dockableSelectionListeners.get(i);
            listener.selectionChanged(e);
        }
    }

    public void addHiddenDockable(Dockable dockable, RelativeDockablePosition dockedPosition) {
        DockableState currentState = this.getDockableState(dockable);
        if (currentState != null && !currentState.isHidden()) {
            this.setAutoHide(dockable, true);
            return;
        }
        this.registerDockable(dockable);
        DockableState newState = new DockableState(dockable, 2, dockedPosition);
        DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
        DockKey k = dockable.getDockKey();
        if (currentState == null || !currentState.isHidden() && this.fireDockableStateWillChange(event)) {
            AutoHideButton btn = (AutoHideButton)this.autoHideButtons.get(k);
            if (btn == null) {
                btn = new AutoHideButton();
                this.autoHideButtons.put(k, btn);
                int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
                btn.init(dockable, zone);
                this.borderPanes[zone].setVisible(true);
                this.borderPanes[zone].add(btn);
                this.borderPanes[zone].revalidate();
            } else {
                int zone = btn.getZone();
                this.borderPanes[zone].setVisible(true);
                btn.setVisible(true);
                this.borderPanes[zone].revalidate();
            }
            this.dockableStates.put(dockable, newState);
            dockable.getDockKey().setDockableState(2);
            this.fireDockableStateChange(new DockableStateChangeEvent(currentState, newState));
            this.revalidate();
        }
    }

    public void setDockableWidth(Dockable dockable, double width) {
        SplitContainer split = DockingUtilities.getSplitPane(dockable, 1);
        if (split == null) {
            return;
        }
        if (((Container)split.getLeftComponent()).isAncestorOf(dockable.getComponent())) {
            split.setDividerLocation(width);
        } else {
            split.setDividerLocation(1.0 - width);
        }
    }

    public void setDockableHeight(Dockable dockable, double height) {
        SplitContainer split = DockingUtilities.getSplitPane(dockable, 0);
        if (split == null) {
            return;
        }
        if (((Container)split.getTopComponent()).isAncestorOf(dockable.getComponent())) {
            split.setDividerLocation(height);
        } else {
            split.setDividerLocation(1.0 - height);
        }
    }

    public void setAutoResizableDockable(Dockable dockable) {
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void addToTabbedGroup(Dockable base, Dockable newTab) {
        LinkedList<Dockable> group = (LinkedList<Dockable>)this.tabbedGroups.get(base);
        if (group == null) {
            group = new LinkedList<Dockable>();
            group.add(base);
            this.tabbedGroups.put(base, group);
        }
        group.add(newTab);
        this.tabbedGroups.put(newTab, group);
    }

    public void removeFromTabbedGroup(Dockable dockable) {
        LinkedList group = (LinkedList)this.tabbedGroups.get(dockable);
        if (group != null) {
            this.tabbedGroups.remove(dockable);
            group.remove(dockable);
            if (group.size() == 1) {
                Dockable d = (Dockable)group.removeFirst();
                this.tabbedGroups.remove(d);
            }
        }
    }

    protected AutoHideExpandPanel createAutoHideExpandPanel() {
        return new AutoHideExpandPanel();
    }

    static {
        $assertionsDisabled = !DockingDesktop.class.desiredAssertionStatus();
        DockingUISettings.getInstance().installUI();
    }

    private class FocusHandler
    implements PropertyChangeListener,
    ChangeListener {
        Dockable lastFocusedDockable;
        Dockable currentDockable;

        private FocusHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Component c;
            for (c = (Component)e.getNewValue(); c != null && !(c instanceof SingleDockableContainer); c = c.getParent()) {
            }
            if (c instanceof SingleDockableContainer) {
                SingleDockableContainer sdc = (SingleDockableContainer)((Object)c);
                this.currentDockable = sdc.getDockable();
                if (sdc.getDockable() != this.lastFocusedDockable) {
                    DockingDesktop.this.fireDockableSelectionChange(new DockableSelectionEvent(sdc.getDockable()));
                }
                this.lastFocusedDockable = sdc.getDockable();
            } else {
                this.currentDockable = null;
            }
        }

        public void stateChanged(ChangeEvent evt) {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)pane);
            Dockable selDockable = tdc.getSelectedDockable();
            if (selDockable != null) {
                this.currentDockable = selDockable;
                if (selDockable != this.lastFocusedDockable) {
                    this.lastFocusedDockable = selDockable;
                    DockingDesktop.this.fireDockableSelectionChange(new DockableSelectionEvent(selDockable));
                }
            }
        }

        Dockable getCurrentDockable() {
            return this.currentDockable;
        }
    }
}

