/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.event;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockEvent;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

public class DockDropEvent
extends DockEvent {
    private DockingDesktop desk;
    private boolean accepted;

    public DockDropEvent(DockingDesktop desk, DockableDragSource source, MouseEvent event) {
        super(desk, source, event);
        this.desk = desk;
    }

    public void acceptDrop() {
        this.acceptDrop(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acceptDrop(boolean remove) {
        DockingDesktop sourceDesktop;
        this.accepted = true;
        if (!remove) return;
        DockableState state = this.desk.getContext().getDockableState(this.source.getDockable());
        if (state == null) {
            if (!(this.source instanceof TabbedDockableContainer)) throw new RuntimeException("unmanaged dockable drag source : " + this.source);
            Dockable d1 = ((TabbedDockableContainer)((Object)this.source)).getDockableAt(0);
            state = this.desk.getContext().getDockableState(d1);
            sourceDesktop = state.getDesktop();
        } else {
            sourceDesktop = state.getDesktop();
        }
        if (sourceDesktop == null) return;
        sourceDesktop.dropRemove(this.source);
    }

    public void rejectDrop() {
        UIManager.getLookAndFeel().provideErrorFeedback(this.desk);
    }

    public boolean isDropAccepted() {
        return this.accepted;
    }
}

