/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.CompoundDockable;
import com.vlsolutions.swing.docking.CompoundDockingPanel;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainer;
import com.vlsolutions.swing.docking.DockingPanel;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.MaximizedComponentReplacer;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;

public class DockingUtilities {
    private DockingUtilities() {
    }

    public static DockableContainer findDockableContainer(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Component comp = dockable.getComponent();
        if (comp == null) {
            return null;
        }
        while (comp != null) {
            if (comp instanceof DockableContainer) {
                return (DockableContainer)((Object)comp);
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static SingleDockableContainer findSingleDockableContainer(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Component comp = dockable.getComponent();
        if (comp == null) {
            return null;
        }
        while (comp != null) {
            if (comp instanceof SingleDockableContainer) {
                return (SingleDockableContainer)((Object)comp);
            }
            comp = comp.getParent();
        }
        return null;
    }

    public static TabbedDockableContainer findTabbedDockableContainer(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Component comp = dockable.getComponent();
        if (comp == null) {
            return null;
        }
        while (comp != null) {
            if (comp instanceof SingleDockableContainer) {
                if ((comp = comp.getParent()) instanceof TabbedDockableContainer) {
                    return (TabbedDockableContainer)((Object)comp);
                }
                return null;
            }
            comp = comp.getParent();
        }
        return null;
    }

    private static void swapComponents(SplitContainer split1, SplitContainer split2, Component comp1, Component comp2) {
        boolean isLeft1 = split1.getLeftComponent() == comp1;
        int divider1 = split1.getDividerLocation();
        if (split1 == split2) {
            split1.remove(comp1);
            split1.remove(comp2);
            if (isLeft1) {
                split1.setLeftComponent(comp2);
                split1.setRightComponent(comp1);
            } else {
                split1.setLeftComponent(comp1);
                split1.setRightComponent(comp2);
            }
            split1.setDividerLocation(divider1);
            split1.revalidate();
        } else {
            boolean isLeft2 = split2.getLeftComponent() == comp2;
            int divider2 = split2.getDividerLocation();
            split1.remove(comp1);
            split2.remove(comp2);
            if (isLeft1) {
                split1.setLeftComponent(comp2);
            } else {
                split1.setRightComponent(comp2);
            }
            split1.setDividerLocation(divider1);
            if (isLeft2) {
                split2.setLeftComponent(comp1);
            } else {
                split2.setRightComponent(comp1);
            }
            split2.setDividerLocation(divider2);
        }
    }

    public static void swapComponents(Component comp1, Component comp2) {
        Container parent1 = comp1.getParent();
        Container parent2 = comp2.getParent();
        if (parent1 instanceof SplitContainer && parent2 instanceof SplitContainer) {
            DockingUtilities.swapComponents((SplitContainer)parent1, (SplitContainer)parent2, comp1, comp2);
        }
    }

    public static void updateResizeWeights(DockingPanel dockingPanel) {
        if (dockingPanel.getComponentCount() > 0) {
            DockingUtilities.resetSplitWeight(dockingPanel.getComponent(0));
        }
    }

    private static float resetSplitWeight(Component comp) {
        if (comp instanceof SplitContainer) {
            float rightWeight;
            SplitContainer split = (SplitContainer)comp;
            float leftWeight = DockingUtilities.resetSplitWeight(split.getLeftComponent());
            float sum = leftWeight + (rightWeight = DockingUtilities.resetSplitWeight(split.getRightComponent()));
            if (sum == 0.0f) {
                split.setResizeWeight(0.5);
                return 0.0f;
            }
            if (leftWeight == 0.0f) {
                split.setResizeWeight(0.0);
                return rightWeight;
            }
            if (rightWeight == 0.0f) {
                split.setResizeWeight(1.0);
                return leftWeight;
            }
            float proportion = leftWeight / sum;
            split.setResizeWeight(proportion);
            return Math.max(leftWeight, rightWeight);
        }
        if (comp instanceof SingleDockableContainer) {
            return ((SingleDockableContainer)((Object)comp)).getDockable().getDockKey().getResizeWeight();
        }
        if (comp instanceof TabbedDockableContainer) {
            TabbedDockableContainer tab = (TabbedDockableContainer)((Object)comp);
            float max = 0.0f;
            for (int i = 0; i < tab.getTabCount(); ++i) {
                float v;
                Dockable d = tab.getDockableAt(i);
                if (d == null || !((v = d.getDockKey().getResizeWeight()) > max)) continue;
                max = v;
            }
            return max;
        }
        if (!(comp instanceof MaximizedComponentReplacer)) {
            System.err.println("Wrong hierarchy in docking panel (resetSplitWeight error) " + comp);
        }
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void replaceChild(Container parent, Component child, Component newChild) {
        if (parent instanceof SplitContainer) {
            SplitContainer split = (SplitContainer)parent;
            int location = split.getDividerLocation();
            if (split.getLeftComponent() == child) {
                split.remove(child);
                split.setLeftComponent(newChild);
            } else {
                if (split.getRightComponent() != child) throw new IllegalArgumentException("wrong hierarchy");
                split.remove(child);
                split.setRightComponent(newChild);
            }
            split.setDividerLocation(location);
            split.revalidate();
            split.doLayout();
            return;
        } else if (parent instanceof TabbedDockableContainer) {
            if (!(parent instanceof JTabbedPane)) throw new RuntimeException("Unknown TabbedDockableContainer");
            TabbedDockableContainer tparent = (TabbedDockableContainer)((Object)parent);
            JTabbedPane jtp = (JTabbedPane)((Object)tparent);
            int index = jtp.indexOfComponent(child);
            jtp.remove(index);
            if (newChild instanceof SingleDockableContainer) {
                tparent.addDockable(((SingleDockableContainer)((Object)newChild)).getDockable(), index);
                jtp.setSelectedIndex(index);
                return;
            } else {
                jtp.add(newChild, index);
                jtp.setSelectedIndex(index);
            }
            return;
        } else {
            parent.remove(child);
            parent.add(newChild, "Center");
            parent.invalidate();
            parent.validate();
        }
    }

    public static SplitContainer getSplitPane(Dockable dockable, int orientation) {
        Component comp = dockable.getComponent();
        boolean found = false;
        while (comp != null && !found) {
            if (comp instanceof SplitContainer && ((SplitContainer)comp).getOrientation() == orientation) {
                found = true;
                continue;
            }
            comp = comp.getParent();
        }
        return (SplitContainer)comp;
    }

    public static SingleDockableContainer findSingleDockableContainerAncestor(Component component) {
        Container parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof SingleDockableContainer); parent = parent.getParent()) {
        }
        return (SingleDockableContainer)((Object)parent);
    }

    public static boolean isHeavyWeightComponent(Component comp) {
        if (comp instanceof Container) {
            ComponentPeer peer = comp.getPeer();
            if (peer != null && !(peer instanceof LightweightPeer)) {
                return true;
            }
            Container c = (Container)comp;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component child = c.getComponent(i);
                if (!DockingUtilities.isHeavyWeightComponent(child)) continue;
                return true;
            }
            return false;
        }
        ComponentPeer peer = comp.getPeer();
        return peer != null && !(peer instanceof LightweightPeer);
    }

    public static boolean canUseMouseInfo() {
        if (System.getProperty("java.version").compareTo("1.5") >= 0) {
            return DockingUtilities.getMouseLocation() != null;
        }
        return false;
    }

    public static Point getMouseLocation() {
        try {
            Class<?> mouseInfoClass = Class.forName("java.awt.MouseInfo");
            Class[] noArgs = new Class[]{};
            Method m = mouseInfoClass.getMethod("getPointerInfo", noArgs);
            Object pointerInfo = m.invoke(null, null);
            Class<?> pointerInfoClass = Class.forName("java.awt.PointerInfo");
            Method getLocationMethod = pointerInfoClass.getMethod("getLocation", noArgs);
            Point mouseLocation = (Point)getLocationMethod.invoke(pointerInfo, null);
            return mouseLocation;
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static void pack(FloatingDockableContainer fdc) {
        if (fdc instanceof JFrame) {
            ((JFrame)((Object)fdc)).pack();
        } else if (fdc instanceof JDialog) {
            ((JDialog)((Object)fdc)).pack();
        }
    }

    public static void setSize(FloatingDockableContainer fdc, Dimension size) {
        if (fdc instanceof JFrame) {
            ((JFrame)((Object)fdc)).setSize(size);
        } else if (fdc instanceof JDialog) {
            ((JDialog)((Object)fdc)).setSize(size);
        }
    }

    public static void validate(FloatingDockableContainer fdc) {
        ((Window)((Object)fdc)).validate();
    }

    public static void setLocation(FloatingDockableContainer fdc, Point location) {
        ((Window)((Object)fdc)).setLocation(location);
    }

    public static void setLocationRelativeTo(FloatingDockableContainer fdc, Component rel) {
        ((Window)((Object)fdc)).setLocationRelativeTo(rel);
    }

    public static void setVisible(FloatingDockableContainer fdc, boolean visible) {
        ((Window)((Object)fdc)).setVisible(visible);
    }

    public static void dispose(FloatingDockableContainer fdc) {
        ((Window)((Object)fdc)).dispose();
    }

    public static JRootPane getRootPane(FloatingDockableContainer fdc) {
        if (fdc instanceof JFrame) {
            return ((JFrame)((Object)fdc)).getRootPane();
        }
        if (fdc instanceof JDialog) {
            return ((JDialog)((Object)fdc)).getRootPane();
        }
        return null;
    }

    static void setBounds(FloatingDockableContainer fdc, Rectangle bounds) {
        ((Window)((Object)fdc)).setBounds(bounds);
    }

    public static ArrayList findCompoundDockableChildren(CompoundDockable compoundDockable) {
        ArrayList list = new ArrayList();
        CompoundDockingPanel cdp = (CompoundDockingPanel)compoundDockable.getComponent();
        DockingUtilities.fillCompoundChildren(cdp, list);
        return list;
    }

    private static void fillCompoundChildren(CompoundDockingPanel cdp, ArrayList list) {
        if (cdp.getComponentCount() > 0) {
            Component c = cdp.getComponent(0);
            DockingUtilities.fillCompoundChildren(c, list);
        }
    }

    private static void fillCompoundChildren(Component c, ArrayList list) {
        if (c instanceof CompoundDockingPanel) {
            DockingUtilities.fillCompoundChildren((CompoundDockingPanel)c, list);
        } else if (c instanceof SingleDockableContainer) {
            list.add(((SingleDockableContainer)((Object)c)).getDockable());
        } else if (c instanceof SplitContainer) {
            DockingUtilities.fillCompoundChildren(((SplitContainer)c).getLeftComponent(), list);
            DockingUtilities.fillCompoundChildren(((SplitContainer)c).getRightComponent(), list);
        } else if (c instanceof TabbedDockableContainer) {
            TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)c);
            for (int i = 0; i < tdc.getTabCount(); ++i) {
                Dockable d = tdc.getDockableAt(i);
                if (d instanceof CompoundDockable) {
                    list.add(d);
                    CompoundDockingPanel cdp = (CompoundDockingPanel)d.getComponent();
                    DockingUtilities.fillCompoundChildren(cdp, list);
                    continue;
                }
                list.add(d);
            }
        }
    }

    public static boolean isChildOfCompoundDockable(Dockable dockable) {
        for (Container container = dockable.getComponent().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof CompoundDockingPanel) || ((CompoundDockingPanel)container).getDockable() == dockable) continue;
            return true;
        }
        return false;
    }

    public static Container findCompoundAncestorContainer(Dockable dockable) {
        for (Container container = dockable.getComponent().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof CompoundDockingPanel) || ((CompoundDockingPanel)container).getDockable() == dockable) continue;
            return container;
        }
        return null;
    }

    public static int getTopMostAncestorContainerState(Dockable dockable) {
        Container topMostContainer = null;
        for (Container container = dockable.getComponent().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof CompoundDockingPanel) || ((CompoundDockingPanel)container).getDockable() == dockable) continue;
            topMostContainer = container;
        }
        if (topMostContainer != null) {
            CompoundDockingPanel cdp = (CompoundDockingPanel)topMostContainer;
            return cdp.getDockable().getDockKey().getDockableState();
        }
        return -1;
    }

    public static int getDockableStateFromHierarchy(Component comp) {
        if (comp == null) {
            return -1;
        }
        while (comp != null) {
            if (comp instanceof DockingPanel) {
                return 1;
            }
            if (comp instanceof FloatingDockableContainer) {
                return 4;
            }
            comp = comp.getParent();
        }
        return -1;
    }
}

