/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ToolBarContainer
extends JPanel {
    private Map componentsByContraints = new HashMap();
    private Map contraintsByComponents = new HashMap();
    private Map toolBarsByName = new HashMap();

    public ToolBarContainer() {
        this.setLayout(new BorderLayout());
    }

    public void registerToolBar(VLToolBar toolbar) {
        if (toolbar.getName() == null) {
            throw new IllegalArgumentException("This toolbar hasn't got a name : cannot be registered");
        }
        this.toolBarsByName.put(toolbar.getName(), toolbar);
    }

    public void unregisterToolBar(VLToolBar toolbar) {
        if (toolbar.getName() == null) {
            return;
        }
        this.toolBarsByName.remove(toolbar.getName());
    }

    public VLToolBar getToolBarByName(String name) {
        return (VLToolBar)this.toolBarsByName.get(name);
    }

    public List getRegisteredToolBars() {
        return new ArrayList(this.toolBarsByName.values());
    }

    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.componentsByContraints.put(constraints, comp);
        this.contraintsByComponents.put(comp, constraints);
        if (comp instanceof ToolBarPanel) {
            ToolBarPanel panel = (ToolBarPanel)comp;
            if (constraints.equals("East") || constraints.equals("West")) {
                panel.setOrientation(1);
            }
            if (constraints.equals("North")) {
                panel.setBorder(UIManager.getBorder("ToolBarPanel.topBorder"));
            } else if (constraints.equals("West")) {
                panel.setBorder(UIManager.getBorder("ToolBarPanel.leftBorder"));
            } else if (constraints.equals("East")) {
                panel.setBorder(UIManager.getBorder("ToolBarPanel.rightBorder"));
            } else if (constraints.equals("South")) {
                panel.setBorder(UIManager.getBorder("ToolBarPanel.bottomBorder"));
            }
        }
    }

    public void remove(Component comp) {
        super.remove(comp);
        Object constraints = this.contraintsByComponents.remove(comp);
        this.componentsByContraints.remove(constraints);
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        super.remove(index);
        Object constraints = this.contraintsByComponents.remove(comp);
        this.componentsByContraints.remove(constraints);
    }

    public void removeAll() {
        super.removeAll();
        this.componentsByContraints.clear();
        this.contraintsByComponents.clear();
    }

    public Component getComponentAt(Object constraints) {
        return (Component)this.componentsByContraints.get(constraints);
    }

    public ToolBarPanel getToolBarPanelAt(Object constraints) {
        return (ToolBarPanel)this.getComponentAt(constraints);
    }

    public Object getConstraints(Component comp) {
        return this.contraintsByComponents.get(comp);
    }

    public static ToolBarContainer createDefaultContainer(boolean topToolbar, boolean leftToolBar, boolean bottomToolBar, boolean rightToolBar) {
        return ToolBarContainer.createDefaultContainer(topToolbar, leftToolBar, bottomToolBar, rightToolBar, 3);
    }

    public static ToolBarContainer createDefaultContainer(boolean topToolbar, boolean leftToolBar, boolean bottomToolBar, boolean rightToolBar, int alignment) {
        ToolBarPanel panel;
        ToolBarContainer container = new ToolBarContainer();
        if (topToolbar) {
            panel = new ToolBarPanel(alignment);
            panel.setVisible(false);
            container.add((Component)panel, "North");
        }
        if (leftToolBar) {
            panel = new ToolBarPanel(alignment);
            panel.setVisible(false);
            container.add((Component)panel, "West");
        }
        if (bottomToolBar) {
            panel = new ToolBarPanel(alignment);
            panel.setVisible(false);
            container.add((Component)panel, "South");
        }
        if (rightToolBar) {
            panel = new ToolBarPanel(alignment);
            panel.setVisible(false);
            container.add((Component)panel, "East");
        }
        return container;
    }
}

