/*******************************************************************************

	$Id: AboutJMenuItem.java,v 1.7 2004/08/11 03:16:56 steve Exp $
	
	File:		AboutJMenuItem.java
	Author:		Steve Roy
	Copyright:	Copyright (c) 2003-2004 Steve Roy <sroy@roydesign.net>
				
	Part of MRJ Adapter, a unified API for easy integration of Mac OS specific
	functionality within your cross-platform Java application.
	
	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation; either version 2.1 of the License, or
	(at your option) any later version.
	
	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
	License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation, Inc.,
	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Change History:
	01/31/03	Created this file - Steve

*******************************************************************************/

package net.roydesign.app;

import net.roydesign.mac.MRJAdapter;

import javax.swing.JMenuItem;

import java.awt.event.ActionListener;

/**
 * This is the Swing implementation of the About menu item.
 * <p>
 * On all versions of Mac OS, this menu item is always automatically included
 * in the menu bar of the application. On other platforms, it never is. You
 * can find out at runtime if the menu item is automatically included with the
 * <code>isAutomaticallyPresent()</code> method and then add it yourself if
 * it isn't. This will make your code cross-platform while letting the
 * application do the right thing for the current platform.
 * <p>
 * In the case where the About menu item is automatically included, this menu
 * item is really just a placeholder for the actual native menu item, passing
 * off operations to and from the native menu item where possible. Of course,
 * when this is the case, not all methods of this class will be functional.
 * However, there is no harm in calling dysfunctional methods, other than
 * your user interface not matching your requests.
 * <p>
 * The methods that work on all platforms are the following.
 * <ul>
 * <li>addActionListener</li>
 * <li>removeActionListener</li>
 * <li>setAction (only making the action the listener will actually work on
 * all platforms)</li>
 * </ul>
 * 
 * @version MRJ Adapter 1.0.8
 */
public class AboutJMenuItem extends JMenuItem
{
	/**
	 * Construct an About menu item. This method is package private so only
	 * the <code>Application</code> class can create an About menu item.
	 * @param application the application instance using this item
	 */
	AboutJMenuItem(Application application)
	{
		super("About");
		String appName = application.getName();
		if (appName != null)
			setText("About " + appName);
	}
	
	
	/**
	 * Add an action listener to the menu item.
	 * @param l the action listener to be added
	 */
	public void addActionListener(ActionListener l)
	{
		MRJAdapter.addAboutListener(l, this);
		super.addActionListener(l);
	}
	
	/**
	 * Remove an action listener from the menu item.
	 * @param l the action listener to be removed
	 */
	public void removeActionListener(ActionListener l)
	{
		MRJAdapter.removeAboutListener(l);
		super.removeActionListener(l);
	}
	
	/**
	 * Get whether this menu item is automatically present in the menu bar
	 * of the current underlying platform.
	 * @return whether this menu item is automatically present
	 */
	public static boolean isAutomaticallyPresent()
	{
		return MRJAdapter.isAboutAutomaticallyPresent();
	}
}
