/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TabbedDockView
extends DockView {
    public TabbedDockView(Dockable dockable) {
        super(dockable, false);
    }

    protected void scanDrop(DockEvent event, boolean drop) {
        int state = this.dockable.getDockKey().getDockableState();
        if (state == 1) {
            super.scanDrop(event, drop);
        } else if (state == 4) {
            if (DockingUtilities.isChildOfCompoundDockable(this.dockable)) {
                super.scanDrop(event, drop);
            } else if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && UIManager.getBoolean("TabbedContainer.requestFocusOnTabSelection")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Component comp;
                    if (TabbedDockView.this.getDockable() != null && (comp = TabbedDockView.this.getDockable().getComponent()) != null) {
                        comp.requestFocus();
                    }
                }
            });
        }
    }
}

