/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ui;

import com.vlsolutions.swing.docking.AutoHideButton;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class AutoHideButtonUI
extends BasicLabelUI
implements PropertyChangeListener {
    protected static AutoHideButtonUI instance = new AutoHideButtonUI();

    public static ComponentUI createUI(JComponent x) {
        return instance;
    }

    public void installUI(JComponent comp) {
        super.installUI(comp);
        AutoHideButton btn = (AutoHideButton)comp;
        this.installBorder(btn);
        btn.addPropertyChangeListener("autohide.zone", this);
        Font f = UIManager.getFont("AutoHideButton.font");
        if (f != null) {
            btn.setFont(f);
        } else {
            btn.setFont(new Font("Dialog", 0, 10));
        }
    }

    public void uninstallUI(JComponent comp) {
        super.uninstallUI(comp);
        comp.setBorder(null);
        comp.removePropertyChangeListener("autohide.zone", this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("autohide.zone")) {
            this.installBorder((AutoHideButton)e.getSource());
        } else {
            super.propertyChange(e);
        }
    }

    protected void installBorder(AutoHideButton btn) {
        switch (btn.getZone()) {
            case 0: {
                btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderTop"));
                break;
            }
            case 1: {
                btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderLeft"));
                break;
            }
            case 2: {
                btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderBottom"));
                break;
            }
            case 3: {
                btn.setBorder(UIManager.getBorder("AutoHideButton.expandBorderRight"));
            }
        }
    }

    public void paint(Graphics g, JComponent comp) {
        AutoHideButton btn = (AutoHideButton)comp;
        int zone = btn.getZone();
        if (zone == 0 || zone == 2) {
            super.paint(g, comp);
        } else {
            if (btn.isOpaque()) {
                g.setColor(btn.getBackground());
                g.fillRect(0, 0, btn.getWidth(), btn.getHeight());
            }
            double pid2 = 1.5707963267948966;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setFont(btn.getFont());
            g2.setColor(btn.getForeground());
            FontMetrics fm = btn.getFontMetrics(btn.getFont());
            Icon icon = btn.getIcon();
            Insets i = btn.getInsets();
            String text = btn.getText();
            if (zone == 1) {
                g2.translate(0, btn.getHeight());
                g2.rotate(-pid2);
                if (icon != null) {
                    icon.paintIcon(btn, g2, i.bottom, i.left);
                    if (text != null) {
                        g2.drawString(text, i.bottom + icon.getIconWidth() + btn.getIconTextGap(), i.left + btn.getWidth() / 2 + fm.getAscent() / 2);
                    }
                } else if (text != null) {
                    g2.drawString(text, i.bottom, i.left + btn.getWidth() / 2 + fm.getAscent() / 2);
                }
            } else {
                g2.translate(btn.getWidth(), 0);
                g2.rotate(pid2);
                if (icon != null) {
                    icon.paintIcon(btn, g2, 1, 1);
                    if (text != null) {
                        g2.drawString(text, i.top + icon.getIconWidth() + btn.getIconTextGap(), btn.getWidth() / 2 + fm.getAscent() / 2);
                    }
                } else if (text != null) {
                    g2.drawString(text, i.top, btn.getWidth() / 2 + fm.getAscent() / 2);
                }
            }
        }
    }
}

