/*******************************************************************************

	$Id: JD3CarbonFunctions.java,v 1.7 2004/08/11 03:16:52 steve Exp $
	
	File:		JD3CarbonFunctions.java
	Author:		Steve Roy
	Copyright:	Copyright (c) 2003-2004 Steve Roy <sroy@roydesign.net>
				
	Part of MRJ Adapter, a unified API for easy integration of Mac OS specific
	functionality within your cross-platform Java application.
	
	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation; either version 2.1 of the License, or
	(at your option) any later version.
	
	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
	License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation, Inc.,
	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Change History:
	02/05/03	Created this file - Steve
	03/31/03	Renamed from CarbonFunctions to JD3CarbonFunctions - Steve

*******************************************************************************/

package net.roydesign.mac;

import com.apple.mrj.jdirect.Linker;

/**
 * A JDirect 3 interface to some Carbon functions we use to implement
 * functionality for the Preferences menu item and the Reopen Application event
 * when running in MRJ 3.0 and MRJ 3.1 on Mac OS X. Those two versions of MRJ
 * didn't have built-in support for this item and this event.
 * 
 * @version MRJ Adapter 1.0.8
 */
class JD3CarbonFunctions
{
	public static final String JDirect_MacOSX =
		"/System/Library/Frameworks/Carbon.framework/Versions/A/Carbon";
	
	private static final Object linkage = new Linker(JD3CarbonFunctions.class);
	
	public static native void EnableMenuCommand(int menu, int commandID);
	
	public static native void DisableMenuCommand(int menu, int commandID);
	
	public static native int AEInstallEventHandler(int eventClass,
		int eventID, int handler, int refcon, boolean isSysHandler);
}
