/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class SVNException
extends Exception {
    private static final long serialVersionUID = 4845L;
    private SVNErrorMessage myErrorMessage;

    public SVNException(SVNErrorMessage errorMessage) {
        this(errorMessage, errorMessage.getCause());
    }

    public SVNException(SVNErrorMessage errorMessage, Throwable cause) {
        super(cause);
        if (cause instanceof SVNException) {
            SVNErrorMessage childMessages = ((SVNException)cause).getErrorMessage();
            SVNErrorMessage parent = errorMessage;
            while (parent.hasChildErrorMessage()) {
                parent = parent.getChildErrorMessage();
            }
            if (parent != childMessages) {
                parent.setChildErrorMessage(childMessages);
            }
        }
        this.myErrorMessage = errorMessage;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public String getMessage() {
        SVNErrorMessage error = this.getErrorMessage();
        if (error != null) {
            return error.getFullMessage();
        }
        return super.getMessage();
    }

    public boolean isEnoent() {
        SVNErrorCode errorCode = this.getErrorMessage().getErrorCode();
        return errorCode == SVNErrorCode.ENTRY_NOT_FOUND || errorCode == SVNErrorCode.FS_NOT_FOUND || errorCode == SVNErrorCode.FS_NOT_OPEN || errorCode == SVNErrorCode.FS_NOT_FILE;
    }
}

