/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;

public class SaslInputStream
extends InputStream {
    private InputStream mySource;
    private SaslClient myClient;
    private byte[] myReadBuffer;
    private ByteBuffer myByteBuffer;

    public SaslInputStream(SaslClient client, int bufferSize, InputStream in) {
        this.mySource = in;
        this.myReadBuffer = new byte[bufferSize * 2];
        this.myClient = client;
    }

    public void close() throws IOException {
        this.mySource.close();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b, 0, 1);
        if (r != 1) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toCopy;
        int read = 0;
        do {
            if (this.myByteBuffer == null) {
                this.fetchDecodedBuffer();
            }
            toCopy = Math.min(len, this.myByteBuffer.remaining());
            this.myByteBuffer.get(b, off, toCopy);
            off += toCopy;
            read += toCopy;
        } while ((len -= toCopy) != 0 && this.myByteBuffer.remaining() != 0);
        if (this.myByteBuffer.remaining() == 0) {
            this.myByteBuffer = null;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        return 0L;
    }

    private void fetchDecodedBuffer() throws IOException {
        DataInputStream dis = new DataInputStream(this.mySource);
        int encodedLength = dis.readInt();
        if (this.myReadBuffer.length < encodedLength) {
            this.myReadBuffer = new byte[encodedLength * 3 / 2];
        }
        dis.readFully(this.myReadBuffer, 0, encodedLength);
        this.myByteBuffer = ByteBuffer.wrap(this.myClient.unwrap(this.myReadBuffer, 0, encodedLength));
    }
}

