/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SqlJetVersion {
    private static String PROPERTIES_PATH = "/sqljet.build.properties";
    private static Properties ourProperties;
    private static final String VERSION_MAJOR_PROPERTY = "sqljet.version.major";
    private static final String VERSION_MINOR_PROPERTY = "sqljet.version.minor";
    private static final String VERSION_MICRO_PROPERTY = "sqljet.version.micro";
    private static final String VERSION_QUALIFIER_PROPERTY = "sqljet.version.qualifier";
    private static final String VERSION_BUILD_PROPERTY = "sqljet.version.build";
    private static final String VERSION_MAJOR_DEFAULT = "1";
    private static final String VERSION_MINOR_DEFAULT = "1";
    private static final String VERSION_MICRO_DEFAULT = "3";
    private static final String VERSION_BUILD_DEFAULT = "0";

    private SqlJetVersion() {
    }

    public static String getVersionString() {
        SqlJetVersion.loadProperties();
        StringBuffer version = new StringBuffer();
        version.append(SqlJetVersion.getMajorVersion());
        version.append('.');
        version.append(SqlJetVersion.getMinorVersion());
        version.append('.');
        version.append(SqlJetVersion.getMicroVersion());
        if (SqlJetVersion.getVersionQualifier() != null) {
            version.append('.');
            version.append(SqlJetVersion.getVersionQualifier());
        }
        if (SqlJetVersion.getBuildNumberString() != null) {
            version.append('_');
            version.append(SqlJetVersion.getBuildNumberString());
        }
        return version.toString();
    }

    public static int getMajorVersion() {
        SqlJetVersion.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MAJOR_PROPERTY, "1"));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt("1");
        }
    }

    public static int getMinorVersion() {
        SqlJetVersion.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MINOR_PROPERTY, "1"));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt("1");
        }
    }

    public static int getMicroVersion() {
        SqlJetVersion.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MICRO_PROPERTY, VERSION_MICRO_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MICRO_DEFAULT);
        }
    }

    public static String getVersionQualifier() {
        SqlJetVersion.loadProperties();
        return ourProperties.getProperty(VERSION_QUALIFIER_PROPERTY, null);
    }

    public static long getBuildNumber() {
        SqlJetVersion.loadProperties();
        try {
            return Long.parseLong(ourProperties.getProperty(VERSION_BUILD_PROPERTY, VERSION_BUILD_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static String getBuildNumberString() {
        SqlJetVersion.loadProperties();
        return ourProperties.getProperty(VERSION_BUILD_PROPERTY, VERSION_BUILD_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        Class<SqlJetVersion> clazz = SqlJetVersion.class;
        synchronized (SqlJetVersion.class) {
            if (ourProperties != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            InputStream is = SqlJetVersion.class.getResourceAsStream(PROPERTIES_PATH);
            ourProperties = new Properties();
            if (is == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ourProperties.load(is);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

