/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetError;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryManager;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetByteBuffer;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryManager;
import org.tmatesoft.sqljet.core.table.SqlJetScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlJetUtility {
    public static final String SQLJET_PACKAGENAME = "org.tmatesoft.sqljet";
    private static final boolean SQLJET_LOG_STACKTRACE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_STACKTRACE", false);
    private static final boolean SQLJET_LOG_SIGNED = SqlJetUtility.getBoolSysProp("SQLJET_LOG_SIGNED", false);
    private static final Logger signedLogger = Logger.getLogger("SQLJET_LOG_SIGNED");
    public static final ISqlJetMemoryManager memoryManager = new SqlJetMemoryManager();
    private static final Pattern NUMBER_PATTER = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");
    private static final Pattern REAL_PATTERN = Pattern.compile("[\\.eE]+");

    public static void log(Logger logger, String format, Object ... args) {
        StringBuilder s = new StringBuilder();
        s.append(String.format(format, args)).append('\n');
        if (SQLJET_LOG_STACKTRACE) {
            SqlJetUtility.logStackTrace(s);
        }
        logger.info(s.toString());
    }

    private static void logStackTrace(StringBuilder s) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String l = stackTraceElement.toString();
            if (!l.startsWith(SQLJET_PACKAGENAME)) continue;
            s.append('\t').append(l).append('\n');
        }
    }

    private static void logSigned(long v) {
        if (SQLJET_LOG_SIGNED && v < 0L) {
            SqlJetUtility.log(signedLogger, "signed %d", v);
        }
    }

    public static final ISqlJetMemoryPointer allocatePtr(int size) {
        return memoryManager.allocatePtr(size);
    }

    public static final ISqlJetMemoryPointer allocatePtr(int size, SqlJetMemoryBufferType bufferType) {
        return memoryManager.allocatePtr(size, bufferType);
    }

    public static final ISqlJetMemoryPointer pointer(ISqlJetMemoryPointer p) {
        return p.getBuffer().getPointer(p.getPointer());
    }

    public static final ISqlJetMemoryPointer pointer(ISqlJetMemoryPointer p, int pos) {
        return p.getBuffer().getPointer(p.getAbsolute(pos));
    }

    public static final void movePtr(ISqlJetMemoryPointer p, int pos) {
        p.movePointer(pos);
    }

    public static final ISqlJetMemoryPointer wrapPtr(byte[] bs) {
        ISqlJetMemoryPointer p = SqlJetUtility.allocatePtr(bs.length);
        p.putBytes(bs);
        return p;
    }

    public static String getSysProp(String propName, String defValue) throws SqlJetError {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return System.getProperty(propName, defValue);
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static int getIntSysProp(String propName, int defValue) throws SqlJetError {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Integer.valueOf(System.getProperty(propName, Integer.toString(defValue)));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static boolean getBoolSysProp(String propName, boolean defValue) {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        try {
            return Boolean.valueOf(System.getProperty(propName, Boolean.toString(defValue)));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static <T extends Enum<T>> T getEnumSysProp(String propName, T defValue) {
        if (null == propName) {
            throw new SqlJetError("Undefined property name");
        }
        if (null == defValue) {
            throw new SqlJetError("Undefined default value");
        }
        try {
            return Enum.valueOf(defValue.getDeclaringClass(), System.getProperty(propName, defValue.toString()));
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get int value for property " + propName, t);
        }
    }

    public static final int get2byte(ISqlJetMemoryPointer x) {
        return SqlJetUtility.get2byte(x, 0);
    }

    public static final int get2byte(ISqlJetMemoryPointer x, int off) {
        return x.getShortUnsigned(off);
    }

    public static final void put2byte(ISqlJetMemoryPointer p, int v) {
        SqlJetUtility.put2byte(p, 0, v);
    }

    public static final void put2byte(ISqlJetMemoryPointer p, int off, int v) {
        p.putShortUnsigned(off, v);
    }

    public static final ISqlJetMemoryPointer put4byte(int v) {
        SqlJetUtility.logSigned(v);
        ISqlJetMemoryPointer b = SqlJetUtility.allocatePtr(4);
        b.putInt(0, v);
        return b;
    }

    public static final int get4byte(ISqlJetMemoryPointer p) {
        return SqlJetUtility.get4byte(p, 0);
    }

    public static final int get4byte(ISqlJetMemoryPointer p, int pos) {
        int v = p.getInt(pos);
        SqlJetUtility.logSigned(v);
        return v;
    }

    public static final void put4byte(ISqlJetMemoryPointer p, int pos, long v) {
        if (null == p || p.remaining() - pos < 4) {
            throw new SqlJetError("Wrong destination");
        }
        SqlJetUtility.logSigned(v);
        p.putIntUnsigned(pos, v);
    }

    public static final void put4byte(ISqlJetMemoryPointer p, long v) {
        SqlJetUtility.put4byte(p, 0, v);
    }

    public static final void memcpy(byte[] dest, byte[] src, int length) {
        System.arraycopy(src, 0, dest, 0, length);
    }

    public static final void memcpy(byte[] dest, int dstPos, byte[] src, int srcPos, int length) {
        System.arraycopy(src, srcPos, dest, dstPos, length);
    }

    public static final void memcpy(ISqlJetMemoryPointer dest, ISqlJetMemoryPointer src, int length) {
        dest.copyFrom(src, length);
    }

    public static final void memcpy(ISqlJetMemoryPointer dest, int dstPos, ISqlJetMemoryPointer src, int srcPos, int length) {
        dest.copyFrom(dstPos, src, srcPos, length);
    }

    public static final void memcpy(SqlJetCloneable[] dest, SqlJetCloneable[] src, int length) throws SqlJetException {
        SqlJetUtility.memcpy(src, 0, dest, 0, length);
    }

    public static final <T extends SqlJetCloneable> T memcpy(T src) throws SqlJetException {
        try {
            return (T)((SqlJetCloneable)src.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)e);
        }
    }

    private static final void memcpy(SqlJetCloneable[] src, int srcPos, SqlJetCloneable[] dest, int dstPos, int length) throws SqlJetException {
        int x = srcPos;
        for (int y = dstPos; x < src.length && y < dest.length; ++x, ++y) {
            SqlJetCloneable o = src[x];
            if (null == o) continue;
            try {
                dest[y] = (SqlJetCloneable)o.clone();
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new SqlJetException(SqlJetErrorCode.INTERNAL, (Throwable)e);
            }
        }
    }

    public static final void memset(ISqlJetMemoryPointer data, int from, byte value, int count) {
        data.fill(from, count, value);
    }

    public static final void memset(ISqlJetMemoryPointer data, byte value, int count) {
        SqlJetUtility.memset(data, 0, value, count);
    }

    public static final void memset(ISqlJetMemoryPointer data, byte value) {
        SqlJetUtility.memset(data, value, data.remaining());
    }

    public static int strlen(byte[] s, int from) {
        int p;
        for (p = from; p < s.length && s[p] != 0; ++p) {
        }
        return p - from;
    }

    public static int strlen(ISqlJetMemoryPointer s, int from) {
        int p;
        for (p = from; p < s.remaining() && SqlJetUtility.getUnsignedByte(s, p) != 0; ++p) {
        }
        return p - from;
    }

    public static boolean bitSetTest(BitSet bitSet, int index) {
        if (bitSet == null) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        return bitSet.get(index);
    }

    public static final int memcmp(byte[] a1, byte[] a2, int count) {
        for (int i = 0; i < count; ++i) {
            Byte b2;
            Byte b1 = a1[i];
            int c = b1.compareTo(b2 = Byte.valueOf(a2[i]));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static final int memcmp(byte[] a1, int from1, byte[] a2, int from2, int count) {
        for (int i = 0; i < count; ++i) {
            Byte b2;
            Byte b1 = a1[from1 + i];
            int c = b1.compareTo(b2 = Byte.valueOf(a2[from2 + i]));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer a1, ISqlJetMemoryPointer a2, int count) {
        for (int i = 0; i < count; ++i) {
            int b2;
            int b1 = SqlJetUtility.getUnsignedByte(a1, i);
            int c = b1 - (b2 = SqlJetUtility.getUnsignedByte(a2, i));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static final int memcmp(ISqlJetMemoryPointer a1, int a1offs, ISqlJetMemoryPointer a2, int a2offs, int count) {
        for (int i = 0; i < count; ++i) {
            int b2;
            int b1 = SqlJetUtility.getUnsignedByte(a1, a1offs + i);
            int c = b1 - (b2 = SqlJetUtility.getUnsignedByte(a2, a2offs + i));
            if (0 == c) continue;
            return c;
        }
        return 0;
    }

    public static byte[] addZeroByteEnd(byte[] b) {
        if (null == b) {
            throw new SqlJetError("Undefined byte array");
        }
        byte[] r = new byte[b.length + 1];
        SqlJetUtility.memcpy(r, b, b.length);
        r[b.length] = 0;
        return r;
    }

    public static byte[] getBytes(String string) {
        if (null == string) {
            throw new SqlJetError("Undefined string");
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (Throwable t) {
            throw new SqlJetError("Error while get bytes for string \"" + string + "\"", t);
        }
    }

    public static int putVarint(ISqlJetMemoryPointer p, long v) {
        if ((v & 0xFF00000000000000L) != 0L) {
            SqlJetUtility.putUnsignedByte(p, 8, (byte)v);
            v >>= 8;
            for (int i = 7; i >= 0; --i) {
                SqlJetUtility.putUnsignedByte(p, i, (byte)(v & 0x7FL | 0x80L));
                v >>= 7;
            }
            return 9;
        }
        int n = 0;
        byte[] buf = new byte[10];
        do {
            buf[n++] = (byte)(v & 0x7FL | 0x80L);
        } while ((v >>= 7) != 0L);
        buf[0] = (byte)(buf[0] & 0x7F);
        assert (n <= 9);
        int i = 0;
        int j = n - 1;
        while (j >= 0) {
            SqlJetUtility.putUnsignedByte(p, i, buf[j]);
            --j;
            ++i;
        }
        return n;
    }

    public static int putVarint32(ISqlJetMemoryPointer p, int v) {
        if (v < 128) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFFF80) == 0) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)v);
            return 1;
        }
        if ((v & 0xFFFFC000) == 0) {
            SqlJetUtility.putUnsignedByte(p, 0, (byte)(v >> 7 | 0x80));
            SqlJetUtility.putUnsignedByte(p, 1, (byte)(v & 0x7F));
            return 2;
        }
        return SqlJetUtility.putVarint(p, v);
    }

    public static byte getVarint(ISqlJetMemoryPointer p, long[] v) {
        return SqlJetUtility.getVarint(p, 0, v);
    }

    public static byte getVarint(ISqlJetMemoryPointer p, int offset, long[] v) {
        long l = 0L;
        for (byte i = 0; i < 8; i = (byte)((byte)(i + 1))) {
            int b = SqlJetUtility.getUnsignedByte(p, i + offset);
            l = l << 7 | (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            v[0] = l;
            i = (byte)(i + 1);
            return i;
        }
        int b = SqlJetUtility.getUnsignedByte(p, 8 + offset);
        v[0] = l = l << 8 | (long)b;
        return 9;
    }

    public static byte getVarint32(ISqlJetMemoryPointer p, int[] v) {
        return SqlJetUtility.getVarint32(p, 0, v);
    }

    public static byte getVarint32(ISqlJetMemoryPointer p, int offset, int[] v) {
        int b;
        int x = SqlJetUtility.getUnsignedByte(p, 0 + offset);
        if (x < 128) {
            v[0] = x;
            return 1;
        }
        int i = 0;
        int a = SqlJetUtility.getUnsignedByte(p, i + offset);
        if ((a & 0x80) == 0) {
            v[0] = a;
            return 1;
        }
        if (((b = SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            a &= 0x7F;
            v[0] = (a <<= 7) | b;
            return 2;
        }
        a <<= 14;
        if (((a |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            b &= 0x7F;
            v[0] = (a &= 0x1FC07F) | (b <<= 7);
            return 3;
        }
        b <<= 14;
        if (((b |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            a &= 0x1FC07F;
            v[0] = (a <<= 7) | (b &= 0x1FC07F);
            return 4;
        }
        a <<= 14;
        if (((a |= SqlJetUtility.getUnsignedByte(p, ++i + offset)) & 0x80) == 0) {
            b &= 0xF01FC07F;
            v[0] = (a &= 0xF01FC07F) | (b <<= 7);
            return 5;
        }
        long[] v64 = new long[1];
        i -= 4;
        byte n = SqlJetUtility.getVarint(p, offset, v64);
        assert (n > 5 && n <= 9);
        v[0] = (int)v64[0];
        return n;
    }

    public static int sqlite3VarintLen(long v) {
        int i = 0;
        while ((v >>= 7) != 0L && ++i < 9) {
        }
        return i;
    }

    public static final boolean mutex_held(ISqlJetMutex mutex) {
        return mutex == null || mutex.held();
    }

    public static int strlen30(ISqlJetMemoryPointer z) {
        int i;
        int l = z.getPointer();
        for (i = 0; i < l && SqlJetUtility.getUnsignedByte(z, i) != 0; ++i) {
        }
        return 0x3FFFFFFF & i;
    }

    public static final int getUnsignedByte(ISqlJetMemoryPointer byteBuffer, int index) {
        return byteBuffer.getByteUnsigned(index);
    }

    public static final ISqlJetMemoryPointer putUnsignedByte(ISqlJetMemoryPointer byteBuffer, int index, int value) {
        byteBuffer.putByteUnsigned(index, value);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ISqlJetMemoryPointer buf) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = buf;
        synchronized (iSqlJetMemoryPointer) {
            byte[] bytes = new byte[buf.remaining()];
            buf.getBytes(bytes);
            return new String(bytes);
        }
    }

    public static String toString(ISqlJetMemoryPointer buf, SqlJetEncoding enc) throws SqlJetException {
        if (buf == null) {
            return null;
        }
        if (enc == null) {
            return null;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer = buf;
        synchronized (iSqlJetMemoryPointer) {
            byte[] bytes = new byte[buf.remaining()];
            buf.getBytes(bytes);
            try {
                String s = new String(bytes, enc.getCharsetName());
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) != '\u0000') continue;
                    return s.substring(0, i);
                }
                return s;
            }
            catch (UnsupportedEncodingException e) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + enc.name());
            }
        }
    }

    public static ISqlJetMemoryPointer fromString(String s, SqlJetEncoding enc) throws SqlJetException {
        try {
            return SqlJetUtility.wrapPtr(s.getBytes(enc.getCharsetName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Unknown charset " + enc.name());
        }
    }

    public static ISqlJetMemoryPointer translate(ISqlJetMemoryPointer buf, SqlJetEncoding from, SqlJetEncoding to) throws SqlJetException {
        return SqlJetUtility.fromString(SqlJetUtility.toString(buf, from), to);
    }

    public static final String trim(String s) {
        return null != s ? s.trim() : null;
    }

    public static int varintLen(long v) {
        int i = 0;
        while ((v >>= 7) != 0L && ++i < 9) {
        }
        return i;
    }

    public static final short toUnsigned(byte value) {
        return (short)(value & 0xFF);
    }

    public static final byte fromUnsigned(short value) {
        return (byte)(value & 0xFF);
    }

    public static final int toUnsigned(short value) {
        return value & 0xFFFF;
    }

    public static final short fromUnsigned(int value) {
        return (short)(value & 0xFFFF);
    }

    public static long toUnsigned(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static final int fromUnsigned(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static final long get4byteUnsigned(byte[] p) {
        return SqlJetUtility.get4byteUnsigned(SqlJetUtility.wrapPtr(p));
    }

    public static final long get4byteUnsigned(byte[] p, int pos) {
        return SqlJetUtility.get4byteUnsigned(SqlJetUtility.wrapPtr(p));
    }

    public static final ISqlJetMemoryPointer put4byteUnsigned(long v) {
        SqlJetUtility.logSigned(v);
        ISqlJetMemoryPointer b = SqlJetUtility.allocatePtr(4);
        b.putIntUnsigned(v);
        return b;
    }

    public static final void put4byteUnsigned(byte[] p, int pos, long v) {
        SqlJetUtility.put4byteUnsigned(SqlJetUtility.wrapPtr(p), pos, v);
    }

    public static final long get4byteUnsigned(ISqlJetMemoryPointer p) {
        return p.getIntUnsigned();
    }

    public static final long get4byteUnsigned(ISqlJetMemoryPointer p, int pos) {
        return p.getIntUnsigned(pos);
    }

    public static final void put4byteUnsigned(ISqlJetMemoryPointer p, int pos, long v) {
        p.putIntUnsigned(pos, v);
    }

    public static final void put4byteUnsigned(ISqlJetMemoryPointer p, long v) {
        p.putIntUnsigned(v);
    }

    public static final void memmove(ISqlJetMemoryPointer dst, ISqlJetMemoryPointer src, int n) {
        SqlJetUtility.memmove(dst, 0, src, 0, n);
    }

    public static final void memmove(ISqlJetMemoryPointer dst, int dstOffs, ISqlJetMemoryPointer src, int srcOffs, int n) {
        byte[] b = new byte[n];
        src.getBytes(srcOffs, b, n);
        dst.putBytes(dstOffs, b, n);
    }

    public static final double atof(ISqlJetMemoryPointer z) {
        String s = SqlJetUtility.toString(z);
        return Double.valueOf(s);
    }

    public static final Long atoi64(String str) {
        return Long.valueOf(str);
    }

    public static final long absolute(long i) {
        long u;
        long l = u = i < 0L ? -i : i;
        if (u == Integer.MIN_VALUE || u == Long.MIN_VALUE) {
            --u;
        }
        return u;
    }

    public static final Object[] addArrays(Object[] array1, Object[] array2) {
        Object[] a = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, a, 0, array1.length);
        System.arraycopy(array2, 0, a, array1.length, array2.length);
        return a;
    }

    public static final Object[] insertArray(Object[] intoArray, Object[] insertArray, int pos) {
        Object[] a = new Object[intoArray.length + insertArray.length];
        System.arraycopy(intoArray, 0, a, 0, pos);
        System.arraycopy(insertArray, 0, a, pos, insertArray.length);
        System.arraycopy(intoArray, pos, a, insertArray.length + pos, intoArray.length - pos);
        return a;
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e1, E ... e) {
        return EnumSet.of(e1, e);
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e) {
        return EnumSet.of(e);
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        return EnumSet.of(e1, e2);
    }

    public static final <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        return EnumSet.of(e1, e2, e3);
    }

    public static final <E extends Enum<E>> EnumSet<E> noneOf(Class<E> elementType) {
        return EnumSet.noneOf(elementType);
    }

    public static final Object[] adjustNumberTypes(Object[] key) {
        if (null == key) {
            return null;
        }
        for (int i = 0; i < key.length; ++i) {
            key[i] = SqlJetUtility.adjustNumberType(key[i]);
        }
        return key;
    }

    public static final SqlJetScope adjustScopeNumberTypes(SqlJetScope scope) {
        if (null == scope) {
            return null;
        }
        SqlJetScope.SqlJetScopeBound leftBound = scope.getLeftBound();
        SqlJetScope.SqlJetScopeBound rightBound = scope.getRightBound();
        if (leftBound != null) {
            leftBound = new SqlJetScope.SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(leftBound.getValue()), leftBound.isInclusive());
        }
        if (rightBound != null) {
            rightBound = new SqlJetScope.SqlJetScopeBound(SqlJetUtility.adjustNumberTypes(rightBound.getValue()), rightBound.isInclusive());
        }
        return new SqlJetScope(leftBound, rightBound);
    }

    public static final Object adjustNumberType(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return ((Number)value).longValue();
            }
            if (value instanceof Float) {
                return Double.parseDouble(Float.toString(((Float)value).floatValue()));
            }
        }
        return value;
    }

    public static ISqlJetMemoryPointer streamToBuffer(InputStream stream) throws SqlJetException {
        if (stream == null) {
            return null;
        }
        try {
            byte[] b = new byte[stream.available()];
            stream.read(b);
            stream.reset();
            return SqlJetUtility.wrapPtr(b);
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    public static byte[] readByteBuffer(ISqlJetMemoryPointer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] array = new byte[buffer.remaining()];
        buffer.getBytes(array);
        return array;
    }

    public static Object[] copyArray(Object[] array) {
        if (null == array) {
            return null;
        }
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static boolean isNumber(String s, boolean[] realnum) {
        if (s == null) {
            return false;
        }
        if (!NUMBER_PATTER.matcher(s).matches()) {
            return false;
        }
        if (realnum != null && realnum.length > 0) {
            realnum[0] = REAL_PATTERN.matcher(s).matches();
        }
        return true;
    }

    public static Long doubleToInt64(Double r) {
        double rint;
        if (r == null) {
            return null;
        }
        if (r == Double.NaN) {
            return null;
        }
        if (r == Double.POSITIVE_INFINITY) {
            return null;
        }
        if (r == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double rdbl = r;
        if (rdbl != (rint = Math.rint(rdbl))) {
            return null;
        }
        return r.longValue();
    }

    public static ISqlJetMemoryPointer fromByteBuffer(ByteBuffer b) {
        return new SqlJetByteBuffer(b).getPointer(0);
    }

    public static ISqlJetMemoryPointer getMoved(ISqlJetMemoryPointer preceding, ISqlJetMemoryPointer ptr, int offset) {
        if (ptr.getPointer() + offset >= 0) {
            return ptr.getMoved(offset);
        }
        assert (preceding != null);
        int getFromPreceding = -(ptr.getPointer() + offset);
        int ptrLength = ptr.getLimit() - ptr.getPointer();
        int precedingLength = preceding.getLimit() - preceding.getPointer();
        ISqlJetMemoryPointer newPtr = SqlJetUtility.allocatePtr(ptrLength + getFromPreceding);
        newPtr.copyFrom(0, preceding, precedingLength - getFromPreceding, getFromPreceding);
        newPtr.copyFrom(getFromPreceding, ptr, 0, ptrLength);
        return newPtr;
    }
}

