/*******************************************************************************

	$Id: AppleEventHandler.java,v 1.7 2004/08/11 03:16:52 steve Exp $
	
	File:		AppleEventHandler.java
	Author:		Steve Roy
	Copyright:	Copyright (c) 2003-2004 Steve Roy <sroy@roydesign.net>
				
	Part of MRJ Adapter, a unified API for easy integration of Mac OS specific
	functionality within your cross-platform Java application.
	
	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation; either version 2.1 of the License, or
	(at your option) any later version.
	
	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
	License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation, Inc.,
	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Change History:
	02/05/03	Created this file - Steve

*******************************************************************************/

package net.roydesign.mac;

/**
 * This interface is implemented by objects that wish to be notified of
 * incoming Apple events. This is only currently implemented to handle
 * the Preferences menu item on MRJ 3.0 and 3.1. The fact that it is public
 * is just a byproduct of this implementation and by no means indicates
 * any built-in support for handling arbitrary Apple events by your
 * application.
 * 
 * @version MRJ Adapter 1.0.8
 */
public interface AppleEventHandler
{
	/**
	 * Handle an incoming Apple event.
	 * @param event a native pointer to the Apple event
	 * @param reply a native pointer to the event reply
	 * @param refcon the application-defined reference constant
	 */
	public short handleEvent(int event, int reply, int refcon);
}
