<?php 
class ControllerPaymentMalsE extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/malse');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('malse', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
				
		$this->data['entry_account'] = $this->language->get('entry_account');
		$this->data['entry_domain'] = $this->language->get('entry_domain');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_account'] = @$this->error['account'];
		$this->data['error_domain'] = @$this->error['domain'];

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/malse'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/malse');
		
		$this->data['cancel'] = $this->url->https('extension/payment');
		
		

		

		
		
		if (isset($this->request->post['malse_account'])) {
			$this->data['malse_account'] = $this->request->post['malse_account'];
		} else {
			$this->data['malse_account'] = $this->config->get('malse_account');
		}

		if (isset($this->request->post['malse_account'])) {
			$this->data['malse_domain'] = $this->request->post['malse_domain'];
		} else {
			$this->data['malse_domain'] = $this->config->get('malse_domain');
		}
		
		if (isset($this->request->post['malse_order_status_id'])) {
			$this->data['malse_order_status_id'] = $this->request->post['malse_order_status_id'];
		} else {
			$this->data['malse_order_status_id'] = $this->config->get('malse_order_status_id'); 
		} 
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['malse_geo_zone_id'])) {
			$this->data['malse_geo_zone_id'] = $this->request->post['malse_geo_zone_id'];
		} else {
			$this->data['malse_geo_zone_id'] = $this->config->get('malse_geo_zone_id'); 
		} 	
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['malse_status'])) {
			$this->data['malse_status'] = $this->request->post['malse_status'];
		} else {
			$this->data['malse_status'] = $this->config->get('malse_status');
		}
		
		if (isset($this->request->post['malse_sort_order'])) {
			$this->data['malse_sort_order'] = $this->request->post['malse_sort_order'];
		} else {
			$this->data['malse_sort_order'] = $this->config->get('malse_sort_order');
		}

		$this->id       = 'content';
		$this->template = 'payment/malse.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/malse')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!@$this->request->post['malse_account']) {
			$this->error['account'] = $this->language->get('error_account');
		}

		if (!@$this->request->post['malse_domain']) {
			$this->error['domain'] = $this->language->get('error_domain');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>