<?php 
class ControllerPaymentVerisign extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/verisign');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('verisign', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_australia'] = $this->language->get('text_australia');
		$this->data['text_usa'] = $this->language->get('text_usa');
		
		$this->data['entry_merchant'] = $this->language->get('entry_merchant');
		$this->data['entry_partner'] = $this->language->get('entry_partner');
		$this->data['entry_country'] = $this->language->get('entry_country');
		$this->data['entry_test'] = $this->language->get('entry_test');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_merchant'] = @$this->error['merchant'];
		$this->data['error_partner'] = @$this->error['partner'];

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/verisign'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/verisign');
		
		$this->data['cancel'] = $this->url->https('extension/payment');
		
		if (isset($this->request->post['verisign_merchant'])) {
			$this->data['verisign_merchant'] = $this->request->post['verisign_merchant'];
		} else {
			$this->data['verisign_merchant'] = $this->config->get('verisign_merchant');
		}
		
		if (isset($this->request->post['verisign_partner'])) {
			$this->data['verisign_partner'] = $this->request->post['verisign_partner'];
		} else {
			$this->data['verisign_partner'] = $this->config->get('verisign_partner');
		}
		
		if (isset($this->request->post['verisign_country'])) {
			$this->data['verisign_country'] = $this->request->post['verisign_country'];
		} else {
			$this->data['verisign_country'] = $this->config->get('verisign_country');
		}
		
		if (isset($this->request->post['verisign_test'])) {
			$this->data['verisign_test'] = $this->request->post['verisign_test'];
		} else {
			$this->data['verisign_test'] = $this->config->get('verisign_test');
		}
		
		if (isset($this->request->post['verisign_order_status_id'])) {
			$this->data['verisign_order_status_id'] = $this->request->post['verisign_order_status_id'];
		} else {
			$this->data['verisign_order_status_id'] = $this->config->get('verisign_order_status_id'); 
		} 

		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['verisign_geo_zone_id'])) {
			$this->data['verisign_geo_zone_id'] = $this->request->post['verisign_geo_zone_id'];
		} else {
			$this->data['verisign_geo_zone_id'] = $this->config->get('verisign_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['verisign_status'])) {
			$this->data['verisign_status'] = $this->request->post['verisign_status'];
		} else {
			$this->data['verisign_status'] = $this->config->get('verisign_status');
		}
		
		if (isset($this->request->post['verisign_sort_order'])) {
			$this->data['verisign_sort_order'] = $this->request->post['verisign_sort_order'];
		} else {
			$this->data['verisign_sort_order'] = $this->config->get('verisign_sort_order');
		}

		$this->id       = 'content';
		$this->template = 'payment/verisign.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/verisign')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!@$this->request->post['verisign_merchant']) {
			$this->error['merchant'] = $this->language->get('error_merchant');
		}
		
		if (!@$this->request->post['verisign_partner']) {
			$this->error['partner'] = $this->language->get('error_partner');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>