@echo off

goto make_release

set vcbuild="%VS80COMNTOOLS%\..\..\vc\vcpackages\vcbuild.exe"
set vsvars="%VS80COMNTOOLS%\vsvars32.bat"

echo

if not exist %vcbuild% goto no_vcbuild
if not exist %vsvars% goto no_vsvars
call %vsvars%
set INCLUDE="%INCLUDE%;%VCINSTALLDIR%\include;C:\Program Files\Microsoft SDKs\Windows\v6.1\Include"
set LIB="%INCLUDE%;%VCINSTALLDIR%\lib;C:\Program Files\Microsoft SDKs\Windows\v6.1\Lib"

goto beginning

:no_vcbuild
echo vcbuild.exe not found at this location: %vcbuild%
echo Please update its location in this file or re-install Visual C++ Express 2005
goto exit

:no_vsvars
echo vsvars32.bat not found at this location: %vsvars%
echo Please update its location in this file or re-install Visual C++ Express 2005
goto exit

:beginning

:clean_version
echo Cleaning previous version...
cd ./build/msw
%vcbuild% /useenv /clean OpenCinemaTools.sln "Debug|Win32" > build.log
if ERRORLEVEL 1 goto error_occured
%vcbuild% /useenv /clean OpenCinemaTools.sln "Release|Win32" > build.log
if ERRORLEVEL 1 goto error_occured
cd ..\..

:build_version
echo Building version...
cd ./build/msw
%vcbuild% /useenv /r OpenCinemaTools.sln "Debug|Win32" > build.log
if ERRORLEVEL 1 goto error_occured
%vcbuild% /useenv /r OpenCinemaTools.sln "Release|Win32" > build.log
if ERRORLEVEL 1 goto error_occured
cd ..\..

:make_release
set /p ver=<version.txt

:make_release_win32_bin
echo Making the Win32 binary release...
if exist .\opencinematools-%ver% rmdir /S /Q .\opencinematools-%ver%
mkdir .\opencinematools-%ver%
copy .\*.txt .\opencinematools-%ver%\
mkdir .\opencinematools-%ver%\bin
copy .\bin\release\*.exe .\opencinematools-%ver%\bin\
copy .\bin\release\*.dll .\opencinematools-%ver%\bin\

if not exist .\setup mkdir .\setup
if exist .\setup\opencinematools-%ver%-bin-win32.zip del .\setup\opencinematools-%ver%-bin-win32.zip
.\dep\zip\zip -r .\setup\opencinematools-%ver%-bin-win32.zip .\opencinematools-%ver%\*

:make_release_source
echo Making the source release...
if exist .\opencinematools-%ver% rmdir /S /Q .\opencinematools-%ver%
mkdir .\opencinematools-%ver%
copy .\*.txt .\opencinematools-%ver%\
copy .\*.bat .\opencinematools-%ver%\
mkdir .\opencinematools-%ver%\build
mkdir .\opencinematools-%ver%\build\msw
mkdir .\opencinematools-%ver%\build\unix
mkdir .\opencinematools-%ver%\build\macosx
copy .\build\msw\*.sln .\opencinematools-%ver%\build\msw\
copy .\build\msw\*.vcproj .\opencinematools-%ver%\build\msw\
copy .\build\unix\*.* .\opencinematools-%ver%\build\unix\
copy .\build\macosx\*.* .\opencinematools-%ver%\build\macosx\
mkdir .\opencinematools-%ver%\src
xcopy /S /Q .\src\*.cpp .\opencinematools-%ver%\src\
xcopy /S /Q .\src\*.h .\opencinematools-%ver%\src\
xcopy /S /Q .\src\*.rc .\opencinematools-%ver%\src\
xcopy /S /Q .\src\*.manifest .\opencinematools-%ver%\src\
xcopy /S /Q .\src\*.fbp .\opencinematools-%ver%\src\
xcopy /S /Q .\src\*.ico .\opencinematools-%ver%\src\
mkdir .\opencinematools-%ver%\dep
xcopy /S /Q .\dep\*.* .\opencinematools-%ver%\dep\
mkdir .\opencinematools-%ver%\bin
mkdir .\opencinematools-%ver%\lib

if not exist .\setup mkdir .\setup
if exist .\setup\opencinematools-%ver%-src.zip del .\setup\opencinematools-%ver%-src.zip
.\dep\zip\zip -r .\setup\opencinematools-%ver%-src.zip .\opencinematools-%ver%\*

:cleanup
if exist .\opencinematools-%ver% rmdir /S /Q .\opencinematools-%ver%

:done
echo Distribution created sucessfully.
goto exit

:error_occured
echo !!! An ERROR occured !!!
notepad build.log
pause
goto exit_nopause

:exit
pause

:exit_nopause

