/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

class MessageLog {
    private String message;
    private String source;
    private String destination;
    private long timeStamp;
    private boolean isSender;
    private String firstLine;
    private String statusMessage;
    private String tid;
    private String callId;
    private int debugLine;

    public boolean equals(Object other) {
        if (!(other instanceof MessageLog)) {
            return false;
        }
        MessageLog otherLog = (MessageLog)other;
        return otherLog.message.equals(this.message) && otherLog.timeStamp == this.timeStamp;
    }

    public MessageLog(String message, String source, String destination, String timeStamp, boolean isSender, String firstLine, String statusMessage, String tid, String callId, int lineCount) {
        if (message == null || message.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = message;
        this.source = source;
        this.destination = destination;
        try {
            long ts = Long.parseLong(timeStamp);
            if (ts < 0L) {
                throw new IllegalArgumentException("Bad time stamp ");
            }
            this.timeStamp = ts;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad number format " + timeStamp);
        }
        this.isSender = isSender;
        this.firstLine = firstLine;
        this.statusMessage = statusMessage;
        this.tid = tid;
        this.callId = callId;
        this.debugLine = lineCount;
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    public MessageLog(String message, String source, String destination, long timeStamp, boolean isSender, String firstLine, String statusMessage, String tid, String callId, int lineCount) {
        if (message == null || message.equals("")) {
            throw new IllegalArgumentException("null msg");
        }
        this.message = message;
        this.source = source;
        this.destination = destination;
        if (timeStamp < 0L) {
            throw new IllegalArgumentException("negative ts");
        }
        this.timeStamp = timeStamp;
        this.isSender = isSender;
        this.firstLine = firstLine;
        this.statusMessage = statusMessage;
        this.tid = tid;
        this.callId = callId;
        this.debugLine = lineCount;
    }

    public String flush(long startTime) {
        String log;
        if (this.statusMessage != null) {
            log = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + (this.timeStamp - startTime) + "\" \nisSender=\"" + this.isSender + "\" \nstatusMessage=\"" + this.statusMessage + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\">\n";
            log = log + "<![CDATA[";
            log = log + this.message;
            log = log + "]]>\n";
            log = log + "</message>\n";
        } else {
            log = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + (this.timeStamp - startTime) + "\" \nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\">\n";
            log = log + "<![CDATA[";
            log = log + this.message;
            log = log + "]]>\n";
            log = log + "</message>\n";
        }
        return log;
    }

    public String flush() {
        String log;
        if (this.statusMessage != null) {
            log = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\" \nisSender=\"" + this.isSender + "\" \nstatusMessage=\"" + this.statusMessage + "\" \ntransactionId=\"" + this.tid + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ncallId=\"" + this.callId + "\" \ndebugLine=\"" + this.debugLine + "\" \n>\n";
            log = log + "<![CDATA[";
            log = log + this.message;
            log = log + "]]>\n";
            log = log + "</message>\n";
        } else {
            log = "<message\nfrom=\"" + this.source + "\" \nto=\"" + this.destination + "\" \ntime=\"" + this.timeStamp + "\" \nisSender=\"" + this.isSender + "\" \ntransactionId=\"" + this.tid + "\" \ncallId=\"" + this.callId + "\" \nfirstLine=\"" + this.firstLine.trim() + "\" \ndebugLine=\"" + this.debugLine + "\" \n>\n";
            log = log + "<![CDATA[";
            log = log + this.message;
            log = log + "]]>\n";
            log = log + "</message>\n";
        }
        return log;
    }
}

