/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction {
    private ConcurrentHashMap sipDialogs;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private ServerResponseInterface respondTo;
    private SIPDialog defaultDialog;
    private Hop nextHop;
    private boolean notifyOnRetransmit;

    protected SIPClientTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        super(sIPTransactionStack, messageChannel);
        this.setBranch(Utils.generateBranchId());
        this.messageProcessor = messageChannel.messageProcessor;
        this.setEncapsulatedChannel(messageChannel);
        this.notifyOnRetransmit = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating clientTransaction " + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.sipDialogs = new ConcurrentHashMap();
    }

    public void setResponseInterface(ServerResponseInterface serverResponseInterface) {
        this.respondTo = serverResponseInterface;
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage sIPMessage) {
        ViaList viaList = sIPMessage.getViaHeaders();
        String string = ((Via)viaList.getFirst()).getBranch();
        boolean bl = this.getBranch() != null && string != null && this.getBranch().toLowerCase().startsWith("z9hg4bk") && string.toLowerCase().startsWith("z9hg4bk");
        boolean bl2 = false;
        if (TransactionState.COMPLETED == this.getState()) {
            bl2 = bl ? this.getBranch().equalsIgnoreCase(((Via)viaList.getFirst()).getBranch()) && this.getMethod().equals(sIPMessage.getCSeq().getMethod()) : this.getBranch().equals(sIPMessage.getTransactionId());
        } else if (!this.isTerminated()) {
            if (bl) {
                if (viaList != null && this.getBranch().equalsIgnoreCase(((Via)viaList.getFirst()).getBranch())) {
                    bl2 = this.getOriginalRequest().getCSeq().getMethod().equals(sIPMessage.getCSeq().getMethod());
                }
            } else {
                bl2 = this.getBranch() != null ? this.getBranch().equalsIgnoreCase(sIPMessage.getTransactionId()) : this.getOriginalRequest().getTransactionId().equalsIgnoreCase(sIPMessage.getTransactionId());
            }
        }
        return bl2;
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        SIPRequest sIPRequest = (SIPRequest)sIPMessage;
        Via via = (Via)sIPRequest.getViaHeaders().getFirst();
        try {
            via.setBranch(this.getBranch());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Sending Message " + sIPMessage);
            this.sipStack.getLogWriter().logDebug("TransactionState " + this.getState());
        }
        if ((TransactionState.PROCEEDING == this.getState() || TransactionState.CALLING == this.getState()) && sIPRequest.getMethod().equals("ACK")) {
            if (this.isReliable()) {
                this.setState(TransactionState.TERMINATED);
            } else {
                this.setState(TransactionState.COMPLETED);
            }
            super.sendMessage(sIPRequest);
            return;
        }
        try {
            this.lastRequest = sIPRequest;
            if (this.getState() == null) {
                this.setOriginalRequest(sIPRequest);
                if (sIPRequest.getMethod().equals("INVITE")) {
                    this.setState(TransactionState.CALLING);
                } else if (sIPRequest.getMethod().equals("ACK")) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.TRYING);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                if (this.isInviteTransaction()) {
                    this.enableTimeoutTimer(64);
                } else {
                    this.enableTimeoutTimer(64);
                }
            }
            super.sendMessage(sIPRequest);
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            throw iOException;
        }
    }

    public synchronized void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel, SIPDialog sIPDialog) {
        if (this.getState() == null) {
            return;
        }
        if ((TransactionState.COMPLETED == this.getState() || TransactionState.TERMINATED == this.getState()) && sIPResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("processing " + sIPResponse.getFirstLine() + "current state = " + this.getState());
            this.sipStack.logWriter.logDebug("dialog = " + sIPDialog);
        }
        this.lastResponse = sIPResponse;
        if (sIPDialog != null && sIPResponse.getStatusCode() != 100 && sIPResponse.getTo().getTag() != null) {
            sIPDialog.setLastResponse(this, sIPResponse);
            this.setDialog(sIPDialog, sIPResponse.getDialogId(false));
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(sIPResponse, messageChannel, sIPDialog);
            } else {
                this.nonInviteClientTransaction(sIPResponse, messageChannel, sIPDialog);
            }
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse sIPResponse, MessageChannel messageChannel, SIPDialog sIPDialog) throws IOException {
        int n = sIPResponse.getStatusCode();
        if (TransactionState.TRYING == this.getState()) {
            if (n / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (200 <= n && n <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_K);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (n / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (200 <= n && n <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_K);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.getSIPStack().logWriter.logDebug(" Not sending response to TU! " + this.getState());
            }
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteClientTransaction(SIPResponse sIPResponse, MessageChannel messageChannel, SIPDialog sIPDialog) throws IOException {
        int n = sIPResponse.getStatusCode();
        if (TransactionState.TERMINATED == this.getState()) {
            this.semaphore.release();
            return;
        }
        if (TransactionState.CALLING == this.getState()) {
            if (n / 100 == 2) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (n / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.PROCEEDING);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (300 <= n && n <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException sipException) {
                    InternalErrorHandler.handleException((Exception)((Object)sipException));
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_D);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (n / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (n / 100 == 2) {
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
            } else if (300 <= n && n <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createAck());
                }
                catch (SipException sipException) {
                    InternalErrorHandler.handleException((Exception)((Object)sipException));
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(sIPResponse, this, sIPDialog);
                } else {
                    this.semaphore.release();
                }
                if (!this.isReliable()) {
                    this.enableTimeoutTimer(this.TIMER_D);
                }
            }
        } else if (TransactionState.COMPLETED == this.getState() && 300 <= n && n <= 699) {
            try {
                this.sendMessage((SIPRequest)this.createAck());
            }
            catch (SipException sipException) {
                InternalErrorHandler.handleException((Exception)((Object)sipException));
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    public void sendRequest() throws SipException {
        SIPRequest sIPRequest = this.getOriginalRequest();
        if (this.getState() != null) {
            throw new SipException("Request already sent");
        }
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("sendRequest() " + sIPRequest);
        }
        try {
            sIPRequest.checkHeaders();
        }
        catch (ParseException parseException) {
            this.sipStack.logWriter.logError("missing required header");
            throw new SipException(parseException.getMessage());
        }
        if (this.getMethod().equals("SUBSCRIBE") && sIPRequest.getHeader("Expires") == null) {
            this.sipStack.logWriter.logWarning("Expires header missing in outgoing subscribe -- Notifier will assume implied value on event package");
        }
        try {
            if (this.getOriginalRequest().getMethod().equals("CANCEL")) {
                SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.sipStack.findCancelTransaction(this.getOriginalRequest(), false);
                if (sIPClientTransaction == null) {
                    throw new SipException("Could not find original tx to cancel. RFC 3261 9.1");
                }
                if (sIPClientTransaction.getState() == null) {
                    throw new SipException("State is null no provisional response yet -- cannot cancel RFC 3261 9.1");
                }
                if (!sIPClientTransaction.getMethod().equals("INVITE")) {
                    throw new SipException("Cannot cancel non-invite requests RFC 3261 9.1");
                }
            } else if (this.getOriginalRequest().getMethod().equals("BYE") || this.getOriginalRequest().getMethod().equals("NOTIFY")) {
                SIPDialog sIPDialog = this.sipStack.getDialog(this.getOriginalRequest().getDialogId(false));
                if (this.getSipProvider().isAutomaticDialogSupportEnabled() && sIPDialog != null) {
                    throw new SipException("Dialog is present and AutomaticDialogSupport is enabled for  the provider -- Send the Request using the Dialog.sendRequest(transaction)");
                }
            }
            this.isMapped = true;
            this.sendMessage(sIPRequest);
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            throw new SipException("IO Error sending request", (Throwable)iOException);
        }
    }

    protected void fireRetransmissionTimer() {
        block7: {
            try {
                if (this.getState() == null || !this.isMapped) {
                    return;
                }
                if (TransactionState.CALLING != this.getState() && TransactionState.TRYING != this.getState() || this.lastRequest == null) break block7;
                if (this.sipStack.generateTimeStampHeader && this.lastRequest.getHeader("Timestamp") != null) {
                    long l = System.currentTimeMillis();
                    TimeStamp timeStamp = new TimeStamp();
                    try {
                        timeStamp.setTimeStamp(l);
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        InternalErrorHandler.handleException((Exception)((Object)invalidArgumentException));
                    }
                    this.lastRequest.setHeader(timeStamp);
                }
                super.sendMessage(this.lastRequest);
                if (this.notifyOnRetransmit) {
                    TimeoutEvent timeoutEvent = new TimeoutEvent((Object)this.getSipProvider(), (ClientTransaction)this, Timeout.RETRANSMIT);
                    this.getSipProvider().handleEvent((EventObject)timeoutEvent, this);
                }
            }
            catch (IOException iOException) {
                this.raiseIOExceptionEvent();
                this.raiseErrorEvent(2);
            }
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("fireTimeoutTimer " + this);
        }
        SIPDialog sIPDialog = (SIPDialog)this.getDialog();
        if (TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState() || TransactionState.PROCEEDING == this.getState()) {
            if (sIPDialog != null && (sIPDialog.getState() == null || sIPDialog.getState() == DialogState.EARLY)) {
                if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod())) {
                    sIPDialog.delete();
                }
            } else if (sIPDialog != null && this.getOriginalRequest().getMethod().equalsIgnoreCase("BYE") && sIPDialog.isTerminatedOnBye()) {
                sIPDialog.delete();
            }
        }
        if (TransactionState.COMPLETED != this.getState()) {
            SIPClientTransaction sIPClientTransaction;
            this.raiseErrorEvent(1);
            if (this.getOriginalRequest().getMethod().equalsIgnoreCase("CANCEL") && (sIPClientTransaction = (SIPClientTransaction)this.getOriginalRequest().getInviteTransaction()) != null && (sIPClientTransaction.getState() == TransactionState.CALLING || sIPClientTransaction.getState() == TransactionState.PROCEEDING) && sIPClientTransaction.getDialog() != null) {
                sIPClientTransaction.setState(TransactionState.TERMINATED);
            }
        } else {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest sIPRequest = this.getOriginalRequest();
        if (sIPRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (!sIPRequest.getMethod().equals("INVITE")) {
            throw new SipException("Only INIVTE may be cancelled");
        }
        if (sIPRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        SIPRequest sIPRequest2 = sIPRequest.createCancelRequest();
        sIPRequest2.setInviteTransaction(this);
        return sIPRequest2;
    }

    public Request createAck() throws SipException {
        Route route;
        AddressParametersHeader addressParametersHeader;
        SIPRequest sIPRequest = this.getOriginalRequest();
        if (sIPRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest sIPRequest2 = sIPRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            if (this.lastResponse.getContactHeaders() != null && this.lastResponse.getStatusCode() / 100 != 3) {
                Contact contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uRI = (URI)contact.getAddress().getURI().clone();
                sIPRequest2.setRequestURI(uRI);
            }
            return sIPRequest2;
        }
        sIPRequest2.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator listIterator = recordRouteList.listIterator(recordRouteList.size());
        while (listIterator.hasPrevious()) {
            addressParametersHeader = (RecordRoute)listIterator.previous();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)addressParametersHeader.getAddress()).clone());
            route.setParameters((NameValueList)addressParametersHeader.getParameters().clone());
            routeList.add(route);
        }
        addressParametersHeader = null;
        if (this.lastResponse.getContactHeaders() != null) {
            addressParametersHeader = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (addressParametersHeader != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)((Contact)addressParametersHeader).getAddress()).clone());
            }
            Route route2 = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uRI = route2.getAddress().getURI();
            sIPRequest2.setRequestURI(uRI);
            if (route != null) {
                routeList.add(route);
            }
            sIPRequest2.addHeader(routeList);
        } else if (addressParametersHeader != null) {
            route = (URI)((Contact)addressParametersHeader).getAddress().getURI().clone();
            sIPRequest2.setRequestURI((URI)route);
            sIPRequest2.addHeader(routeList);
        }
        return sIPRequest2;
    }

    protected void setViaPort(int n) {
        this.viaPort = n;
    }

    protected void setViaHost(String string) {
        this.viaHost = string;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public void clearState() {
    }

    public void setState(TransactionState transactionState) {
        if (transactionState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        if (super.getState() != TransactionState.COMPLETED && (transactionState == TransactionState.COMPLETED || transactionState == TransactionState.TERMINATED)) {
            this.sipStack.decrementActiveClientTransactionCount();
        }
        super.setState(transactionState);
    }

    protected void startTransactionTimer() {
        TransactionTimer transactionTimer = new TransactionTimer();
        this.sipStack.timer.schedule((TimerTask)transactionTimer, 500L, 500L);
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
    }

    public boolean checkFromTag(SIPResponse sIPResponse) {
        String string = ((SIPRequest)this.getRequest()).getFromTag();
        if (this.defaultDialog != null) {
            if (string == null ^ sIPResponse.getFrom().getTag() == null) {
                this.sipStack.getLogWriter().logDebug("From tag mismatch -- dropping response");
                return false;
            }
            if (string != null && !string.equalsIgnoreCase(sIPResponse.getFrom().getTag())) {
                this.sipStack.getLogWriter().logDebug("From tag mismatch -- dropping response");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        SipStackImpl sipStackImpl = (SipStackImpl)this.getSIPStack();
        String string = sIPResponse.getDialogId(false);
        SIPDialog sIPDialog = this.getDialog(string);
        if (sIPDialog == null) {
            SIPClientTransaction sIPClientTransaction = this;
            synchronized (sIPClientTransaction) {
                if (this.defaultDialog != null && sipStackImpl.isDialogCreated(sIPResponse.getCSeq().getMethod()) && sIPResponse.getStatusCode() != 100 && sIPResponse.getFromTag() != null && sIPResponse.getToTag() != null) {
                    SIPResponse sIPResponse2 = this.defaultDialog.getLastResponse();
                    String string2 = this.defaultDialog.getDialogId();
                    if (sIPResponse2 == null || sIPResponse.getCSeq().getMethod().equals("SUBSCRIBE") && sIPResponse2.getCSeq().getMethod().equals("NOTIFY") && string2.equals(string)) {
                        this.defaultDialog.setLastResponse(this, sIPResponse);
                        sIPDialog = this.defaultDialog;
                    } else if (this.getDialog(string) == null) {
                        sIPDialog = sipStackImpl.getDialog(string);
                        if (sIPDialog == null) {
                            sIPDialog = new SIPDialog(this, sIPResponse);
                        }
                    } else {
                        sIPDialog = this.getDialog(string);
                        sIPDialog.setLastResponse(this, sIPResponse);
                    }
                    this.setDialog(sIPDialog, sIPDialog.getDialogId());
                }
            }
        }
        if (sIPDialog == null) {
            sIPDialog = this.defaultDialog;
        }
        this.processResponse(sIPResponse, messageChannel, sIPDialog);
    }

    public synchronized Dialog getDialog() {
        SIPDialog sIPDialog = null;
        if (this.lastResponse != null && this.lastResponse.getFromTag() != null && this.lastResponse.getToTag() != null && this.lastResponse.getStatusCode() != 100) {
            String string = this.lastResponse.getDialogId(false);
            sIPDialog = this.getDialog(string);
        }
        if (sIPDialog == null) {
            sIPDialog = this.defaultDialog;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug(" sipDialogs =  " + this.sipDialogs + " default dialog " + this.defaultDialog + " retval " + sIPDialog);
        }
        return sIPDialog;
    }

    public synchronized SIPDialog getDialog(String string) {
        SIPDialog sIPDialog = (SIPDialog)this.sipDialogs.get((Object)string);
        return sIPDialog;
    }

    public synchronized void setDialog(SIPDialog sIPDialog, String string) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("setDialog: " + string + "sipDialog = " + sIPDialog);
        }
        if (sIPDialog == null) {
            this.sipStack.logWriter.logError("NULL DIALOG!!");
            throw new NullPointerException("bad dialog null");
        }
        if (this.defaultDialog == null) {
            this.defaultDialog = sIPDialog;
        }
        if (string != null && sIPDialog.getDialogId() != null) {
            this.sipDialogs.put((Object)string, (Object)sIPDialog);
        }
    }

    public synchronized SIPDialog getDefaultDialog() {
        return this.defaultDialog;
    }

    public void setNextHop(Hop hop) {
        this.nextHop = hop;
    }

    public Hop getNextHop() {
        return this.nextHop;
    }

    public void setNotifyOnRetransmit(boolean bl) {
        this.notifyOnRetransmit = bl;
    }

    public boolean isNotifyOnRetransmit() {
        return this.notifyOnRetransmit;
    }

    public class TransactionTimer
    extends SIPStackTimerTask {
        protected void runTask() {
            SIPClientTransaction sIPClientTransaction = SIPClientTransaction.this;
            SIPTransactionStack sIPTransactionStack = sIPClientTransaction.sipStack;
            if (sIPClientTransaction.isTerminated()) {
                block10: {
                    if (sIPTransactionStack.isLoggingEnabled()) {
                        sIPTransactionStack.logWriter.logDebug("removing  = " + sIPClientTransaction + " isReliable " + sIPClientTransaction.isReliable());
                    }
                    sIPTransactionStack.removeTransaction(sIPClientTransaction);
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (sIPTransactionStack.isAlive()) break block10;
                        return;
                    }
                }
                if (!sIPTransactionStack.cacheClientConnections && sIPClientTransaction.isReliable()) {
                    int n = sIPClientTransaction.getMessageChannel() instanceof TCPMessageChannel ? --((TCPMessageChannel)sIPClientTransaction.getMessageChannel()).useCount : --((TLSMessageChannel)sIPClientTransaction.getMessageChannel()).useCount;
                    if (n <= 0) {
                        SIPTransaction.LingerTimer lingerTimer = new SIPTransaction.LingerTimer(SIPClientTransaction.this);
                        sIPTransactionStack.timer.schedule((TimerTask)lingerTimer, 8000L);
                    }
                } else if (sIPTransactionStack.isLoggingEnabled() && sIPClientTransaction.isReliable()) {
                    int n = sIPClientTransaction.getMessageChannel() instanceof TCPMessageChannel ? ((TCPMessageChannel)sIPClientTransaction.getMessageChannel()).useCount : ((TLSMessageChannel)sIPClientTransaction.getMessageChannel()).useCount;
                    if (sIPTransactionStack.isLoggingEnabled()) {
                        sIPTransactionStack.logWriter.logDebug("Client Use Count = " + n);
                    }
                }
            } else {
                sIPClientTransaction.fireTimer();
            }
        }
    }
}

