/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets.out.ClusterCommandPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterGetMemberInfoPacket
extends ClusterCommandPacket {
    private List<Integer> members;

    public ClusterGetMemberInfoPacket(QQUser qQUser) {
        super(qQUser);
        this.subCommand = (byte)12;
        this.members = new ArrayList<Integer>();
    }

    public ClusterGetMemberInfoPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    @Override
    public String getPacketName() {
        return "Cluster Get Member Info _08Packet";
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        byteBuffer.putInt(this.clusterId);
        for (Integer n : this.members) {
            byteBuffer.putInt(n);
        }
    }

    public void addMember(int n) {
        this.members.add(new Integer(n));
    }

    public void addMember(Integer n) {
        this.members.add(n);
    }

    public void addMembers(int[] nArray) {
        for (int n : nArray) {
            this.members.add(n);
        }
    }

    public void setMembers(List<Integer> list) {
        this.members = list;
    }

    public int getMember(int n) {
        return this.members.get(n);
    }
}

