/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.chat.RecvChatMsgIcbm;
import net.kano.joscar.snaccmd.chat.RoomInfoUpdate;
import net.kano.joscar.snaccmd.chat.UsersJoinedCmd;
import net.kano.joscar.snaccmd.chat.UsersLeftCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientChatCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(14, 2), new CmdType(14, 3), new CmdType(14, 4), new CmdType(14, 6)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 14) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 2) {
            return new RoomInfoUpdate(packet);
        }
        if (command == 3) {
            return new UsersJoinedCmd(packet);
        }
        if (command == 4) {
            return new UsersLeftCmd(packet);
        }
        if (command == 6) {
            return new RecvChatMsgIcbm(packet);
        }
        return null;
    }
}

