/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.TimeStampHeader;

public class TimeStamp
extends SIPHeader
implements TimeStampHeader {
    private static final long serialVersionUID = -3711322366481232720L;
    protected long timeStamp = -1L;
    protected int delay = -1;
    protected float delayFloat = -1.0f;
    private float timeStampFloat = -1.0f;

    public TimeStamp() {
        super("Timestamp");
    }

    private String getTimeStampAsString() {
        if (this.timeStamp == -1L && this.timeStampFloat == -1.0f) {
            return "";
        }
        if (this.timeStamp != -1L) {
            return new Long(this.timeStamp).toString();
        }
        return new Float(this.timeStampFloat).toString();
    }

    private String getDelayAsString() {
        if (this.delay == -1 && this.delayFloat == -1.0f) {
            return "";
        }
        if (this.delay != -1) {
            return new Integer(this.delay).toString();
        }
        return new Float(this.delayFloat).toString();
    }

    public String encodeBody() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getTimeStampAsString();
        String string2 = this.getDelayAsString();
        if (string.equals("") && string2.equals("")) {
            return "";
        }
        if (!string.equals("")) {
            stringBuffer.append(string);
        }
        if (!string2.equals("")) {
            stringBuffer.append(" ").append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean hasDelay() {
        return this.delay != -1;
    }

    public void removeDelay() {
        this.delay = -1;
    }

    public void setTimeStamp(float f) throws InvalidArgumentException {
        if (f < 0.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setTimeStamp(), the timeStamp parameter is <0");
        }
        this.timeStamp = -1L;
        this.timeStampFloat = f;
    }

    public float getTimeStamp() {
        return this.timeStampFloat == -1.0f ? new Float(this.timeStamp).floatValue() : this.timeStampFloat;
    }

    public float getDelay() {
        return this.delayFloat == -1.0f ? new Float(this.delay).floatValue() : this.delayFloat;
    }

    public void setDelay(float f) throws InvalidArgumentException {
        if (f < 0.0f && f != -1.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setDelay(), the delay parameter is <0");
        }
        this.delayFloat = f;
        this.delay = -1;
    }

    public long getTime() {
        return this.timeStamp == -1L ? (long)this.timeStampFloat : this.timeStamp;
    }

    public int getTimeDelay() {
        return this.delay == -1 ? (int)this.delayFloat : this.delay;
    }

    public void setTime(long l) throws InvalidArgumentException {
        if (l < -1L) {
            throw new InvalidArgumentException("Illegal timestamp");
        }
        this.timeStamp = l;
        this.timeStampFloat = -1.0f;
    }

    public void setTimeDelay(int n) throws InvalidArgumentException {
        if (n < -1) {
            throw new InvalidArgumentException("Value out of range " + n);
        }
        this.delay = n;
        this.delayFloat = -1.0f;
    }
}

