/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.sip.address.Hop;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    protected InputStream myClientInputStream;
    protected OutputStream myClientOutputStream;
    protected String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    protected SIPTransactionStack sipStack;
    protected String myAddress;
    protected int myPort;
    protected InetAddress peerAddress;
    protected int peerPort;
    protected String peerProtocol;
    protected int useCount;
    private TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(SIPTransactionStack sIPTransactionStack) {
        this.sipStack = sIPTransactionStack;
    }

    protected TCPMessageChannel(Socket socket, SIPTransactionStack sIPTransactionStack, TCPMessageProcessor tCPMessageProcessor) throws IOException {
        if (sIPTransactionStack.isLoggingEnabled()) {
            sIPTransactionStack.logWriter.logDebug("creating new TCPMessageChannel ");
            sIPTransactionStack.logWriter.logStackTrace();
        }
        this.mySock = socket;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = tCPMessageProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TCPMessageChannelThread");
        this.sipStack = sIPTransactionStack;
        this.tcpMessageProcessor = tCPMessageProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = tCPMessageProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddress, int n, SIPTransactionStack sIPTransactionStack, TCPMessageProcessor tCPMessageProcessor) throws IOException {
        if (sIPTransactionStack.isLoggingEnabled()) {
            sIPTransactionStack.logWriter.logDebug("creating new TCPMessageChannel ");
            sIPTransactionStack.logWriter.logStackTrace();
        }
        this.peerAddress = inetAddress;
        this.peerPort = n;
        this.myPort = tCPMessageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.sipStack = sIPTransactionStack;
        this.tcpMessageProcessor = tCPMessageProcessor;
        this.myAddress = tCPMessageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = tCPMessageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Closing message Channel " + this);
                }
            }
            catch (IOException iOException) {
                if (!this.sipStack.isLoggingEnabled()) break block4;
                this.sipStack.logWriter.logDebug("Error closing socket " + iOException);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] byArray, boolean bl) throws IOException {
        Socket socket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        byte[] byArray = sIPMessage.encodeAsBytes();
        long l = System.currentTimeMillis();
        this.sendMessage(byArray, sIPMessage instanceof SIPRequest);
        if (this.sipStack.logWriter.isLoggingEnabled(16)) {
            this.logMessage(sIPMessage, this.peerAddress, this.peerPort, l);
        }
    }

    public void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (byArray == null || inetAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket socket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), inetAddress, n, "TCP", byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void handleException(ParseException parseException, SIPMessage sIPMessage, Class clazz, String string, String string2) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(parseException);
        }
        if (clazz != null && (clazz.equals(From.class) || clazz.equals(To.class) || clazz.equals(CSeq.class) || clazz.equals(Via.class) || clazz.equals(CallID.class) || clazz.equals(RequestLine.class) || clazz.equals(StatusLine.class))) {
            if (this.sipStack.isLoggingEnabled()) {
                this.getSIPStack().getLogWriter().logDebug("Encountered Bad Message \n" + sIPMessage.toString());
            }
            throw parseException;
        }
        sIPMessage.addUnparsed(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sIPMessage) throws Exception {
        block34: {
            Object object;
            if (sIPMessage.getFrom() == null || sIPMessage.getTo() == null || sIPMessage.getCallId() == null || sIPMessage.getCSeq() == null || sIPMessage.getViaHeaders() == null) {
                String string = sIPMessage.encode();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug(">>> Dropped Bad Msg");
                    this.sipStack.logWriter.logDebug(string);
                }
                return;
            }
            ViaList viaList = sIPMessage.getViaHeaders();
            if (sIPMessage instanceof SIPRequest) {
                Via via = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(via.getHop());
                this.peerPort = hop.getPort();
                this.peerProtocol = via.getTransport();
                try {
                    this.peerAddress = this.mySock.getInetAddress();
                    if (via.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        via.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    via.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException parseException) {
                    InternalErrorHandler.handleException(parseException, this.sipStack.logWriter);
                }
                if (!this.isCached) {
                    ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                    this.isCached = true;
                    object = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                    this.sipStack.ioHandler.putSocket((String)object, this.mySock);
                }
            }
            long l = System.currentTimeMillis();
            if (sIPMessage instanceof SIPRequest) {
                object = (SIPRequest)sIPMessage;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("----Processing Message---");
                }
                if (this.sipStack.getMaxMessageSize() > 0 && ((SIPMessage)object).getSize() + (((SIPMessage)object).getContentLength() == null ? 0 : ((SIPMessage)object).getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sIPResponse = ((SIPRequest)object).createResponse(513);
                    byte[] byArray = sIPResponse.encodeAsBytes();
                    this.sendMessage(byArray, false);
                    throw new Exception("Message size exceeded");
                }
                ServerRequestInterface serverRequestInterface = this.sipStack.newSIPServerRequest((SIPRequest)object, this);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("---- sipServerRequest = " + serverRequestInterface);
                }
                if (serverRequestInterface != null) {
                    try {
                        serverRequestInterface.processRequest((SIPRequest)object, this);
                    }
                    finally {
                        SIPServerTransaction sIPServerTransaction;
                        if (serverRequestInterface instanceof SIPTransaction && !(sIPServerTransaction = (SIPServerTransaction)serverRequestInterface).passToListener()) {
                            ((SIPTransaction)((Object)serverRequestInterface)).releaseSem();
                        }
                    }
                } else {
                    this.sipStack.logWriter.logWarning("Dropping request -- could not acquire semaphore in 10 sec");
                    SIPResponse sIPResponse = ((SIPRequest)object).createResponse(503);
                    this.sendMessage(sIPResponse);
                }
                if (this.sipStack.logWriter.isLoggingEnabled(16)) {
                    this.sipStack.serverLog.logMessage(sIPMessage, this.getPeerHostPort().toString(), this.getMessageProcessor().getIpAddress().getHostAddress() + ":" + this.getMessageProcessor().getPort(), false, l);
                }
                break block34;
            }
            object = (SIPResponse)sIPMessage;
            if (((SIPResponse)object).getStatusCode() == 100) {
                ((SIPMessage)object).getTo().removeParameter("tag");
            }
            try {
                ((SIPResponse)object).checkHeaders();
            }
            catch (ParseException parseException) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + object);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && ((SIPMessage)object).getSize() + (((SIPMessage)object).getContentLength() == null ? 0 : ((SIPMessage)object).getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface serverResponseInterface = this.sipStack.newSIPServerResponse((SIPResponse)object, this);
            if (serverResponseInterface != null) {
                try {
                    if (serverResponseInterface instanceof SIPClientTransaction && !((SIPClientTransaction)serverResponseInterface).checkFromTag((SIPResponse)object)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logError("Dropping response message with invalid tag >>> " + object);
                        }
                        return;
                    }
                    serverResponseInterface.processResponse((SIPResponse)object, this);
                    break block34;
                }
                finally {
                    if (serverResponseInterface instanceof SIPTransaction && !((SIPTransaction)((Object)serverResponseInterface)).passToListener()) {
                        ((SIPTransaction)((Object)serverResponseInterface)).releaseSem();
                    }
                }
            }
            this.sipStack.getLogWriter().logWarning("Application is blocked -- could not acquire semaphore -- dropping response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        var1_1 = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.timer);
        this.myParser = new PipelinedMsgParser(this, var1_1, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        var2_2 = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        while (true) lbl-1000:
        // 3 sources

        {
            if ((var4_6 = this.myClientInputStream.read(var3_3 = new byte[var2_2], 0, var2_2)) == -1) {
                var1_1.write("\r\n\r\n".getBytes("UTF-8"));
                try {
                    if (this.sipStack.maxConnections != -1) {
                        var5_11 = this.tcpMessageProcessor;
                        synchronized (var5_11) {
                            --this.tcpMessageProcessor.nConnections;
                            this.tcpMessageProcessor.notify();
                        }
                    }
                    var1_1.close();
                    this.mySock.close();
                }
                catch (IOException var5_12) {
                    // empty catch block
                }
                return;
            }
            try {
                var1_1.write(var3_3, 0, var4_6);
            }
            catch (IOException var3_4) {
                try {
                    var1_1.write("\r\n\r\n".getBytes("UTF-8"));
                }
                catch (Exception var4_7) {
                    // empty catch block
                }
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("IOException  closing sock " + var3_4);
                    }
                    try {
                        if (this.sipStack.maxConnections != -1) {
                            var4_8 = this.tcpMessageProcessor;
                            synchronized (var4_8) {
                                --this.tcpMessageProcessor.nConnections;
                                this.tcpMessageProcessor.notify();
                            }
                        }
                        this.mySock.close();
                        var1_1.close();
                    }
                    catch (IOException var4_9) {
                    }
                }
                catch (Exception var4_10) {
                    // empty catch block
                }
                return;
            }
            catch (Exception var3_5) {
                InternalErrorHandler.handleException(var3_5, this.sipStack.logWriter);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
        }
    }

    protected void uncache() {
        this.tcpMessageProcessor.remove(this);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        TCPMessageChannel tCPMessageChannel = (TCPMessageChannel)object;
        return this.mySock == tCPMessageChannel.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return false;
    }
}

