/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitVector;

class SegmentTermDocs
implements TermDocs {
    protected SegmentReader parent;
    protected IndexInput freqStream;
    protected int count;
    protected int df;
    protected BitVector deletedDocs;
    int doc = 0;
    int freq;
    private int skipInterval;
    private int numSkips;
    private int skipCount;
    private IndexInput skipStream;
    private int skipDoc;
    private long freqPointer;
    private long proxPointer;
    private long skipPointer;
    private boolean haveSkipped;

    protected SegmentTermDocs(SegmentReader parent) {
        this.parent = parent;
        this.freqStream = (IndexInput)parent.freqStream.clone();
        this.deletedDocs = parent.deletedDocs;
        this.skipInterval = parent.tis.getSkipInterval();
    }

    public void seek(Term term) throws IOException {
        TermInfo ti = this.parent.tis.get(term);
        this.seek(ti);
    }

    public void seek(TermEnum termEnum) throws IOException {
        TermInfo ti = termEnum instanceof SegmentTermEnum && ((SegmentTermEnum)termEnum).fieldInfos == this.parent.fieldInfos ? ((SegmentTermEnum)termEnum).termInfo() : this.parent.tis.get(termEnum.term());
        this.seek(ti);
    }

    void seek(TermInfo ti) throws IOException {
        this.count = 0;
        if (ti == null) {
            this.df = 0;
        } else {
            this.df = ti.docFreq;
            this.doc = 0;
            this.skipDoc = 0;
            this.skipCount = 0;
            this.numSkips = this.df / this.skipInterval;
            this.freqPointer = ti.freqPointer;
            this.proxPointer = ti.proxPointer;
            this.skipPointer = this.freqPointer + (long)ti.skipOffset;
            this.freqStream.seek(this.freqPointer);
            this.haveSkipped = false;
        }
    }

    public void close() throws IOException {
        this.freqStream.close();
        if (this.skipStream != null) {
            this.skipStream.close();
        }
    }

    public final int doc() {
        return this.doc;
    }

    public final int freq() {
        return this.freq;
    }

    protected void skippingDoc() throws IOException {
    }

    public boolean next() throws IOException {
        while (true) {
            if (this.count == this.df) {
                return false;
            }
            int docCode = this.freqStream.readVInt();
            this.doc += docCode >>> 1;
            this.freq = (docCode & 1) != 0 ? 1 : this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs == null || !this.deletedDocs.get(this.doc)) break;
            this.skippingDoc();
        }
        return true;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        int length = docs.length;
        int i = 0;
        while (i < length && this.count < this.df) {
            int docCode = this.freqStream.readVInt();
            this.doc += docCode >>> 1;
            this.freq = (docCode & 1) != 0 ? 1 : this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            docs[i] = this.doc;
            freqs[i] = this.freq;
            ++i;
        }
        return i;
    }

    protected void skipProx(long proxPointer) throws IOException {
    }

    public boolean skipTo(int target) throws IOException {
        if (this.df >= this.skipInterval) {
            if (this.skipStream == null) {
                this.skipStream = (IndexInput)this.freqStream.clone();
            }
            if (!this.haveSkipped) {
                this.skipStream.seek(this.skipPointer);
                this.haveSkipped = true;
            }
            int lastSkipDoc = this.skipDoc;
            long lastFreqPointer = this.freqStream.getFilePointer();
            long lastProxPointer = -1L;
            int numSkipped = -1 - this.count % this.skipInterval;
            while (target > this.skipDoc) {
                lastSkipDoc = this.skipDoc;
                lastFreqPointer = this.freqPointer;
                lastProxPointer = this.proxPointer;
                if (this.skipDoc != 0 && this.skipDoc >= this.doc) {
                    numSkipped += this.skipInterval;
                }
                if (this.skipCount >= this.numSkips) break;
                this.skipDoc += this.skipStream.readVInt();
                this.freqPointer += (long)this.skipStream.readVInt();
                this.proxPointer += (long)this.skipStream.readVInt();
                ++this.skipCount;
            }
            if (lastFreqPointer > this.freqStream.getFilePointer()) {
                this.freqStream.seek(lastFreqPointer);
                this.skipProx(lastProxPointer);
                this.doc = lastSkipDoc;
                this.count += numSkipped;
            }
        }
        do {
            if (this.next()) continue;
            return false;
        } while (target > this.doc);
        return true;
    }
}

