/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.ChatCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UsersCmd
extends ChatCommand {
    private final List<FullUserInfo> users;

    protected UsersCmd(int command, SnacPacket packet) {
        super(command);
        FullUserInfo user;
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ArrayList<FullUserInfo> userList = new ArrayList<FullUserInfo>();
        ByteBlock block = packet.getData();
        while ((user = FullUserInfo.readUserInfo(block)) != null) {
            userList.add(user);
            block = block.subBlock(user.getTotalSize());
        }
        this.users = DefensiveTools.getUnmodifiable(userList);
    }

    protected UsersCmd(int command, Collection<FullUserInfo> users) {
        super(command);
        this.users = DefensiveTools.getSafeNonnullListCopy(users, (String)"users");
    }

    public final List<FullUserInfo> getUsers() {
        return this.users;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.users != null) {
            for (FullUserInfo user : this.users) {
                user.write(out);
            }
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + " for " + this.users.size() + " users";
    }
}

