/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.MiniUserInfo;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class WarningNotification
extends ConnCommand {
    private final WarningLevel level;
    private final MiniUserInfo by;

    protected WarningNotification(SnacPacket packet) {
        super(16);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        int wval = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        this.level = wval == -1 ? null : WarningLevel.getInstanceFromX10(wval);
        this.by = MiniUserInfo.readUserInfo(snacData.subBlock(2));
    }

    public WarningNotification(int level) {
        this(level, null);
    }

    public WarningNotification(int level, MiniUserInfo by) {
        this(WarningLevel.getInstanceFromX10(level), by);
    }

    public WarningNotification(WarningLevel level, MiniUserInfo by) {
        super(16);
        DefensiveTools.checkNull((Object)level, (String)"level");
        this.level = level;
        this.by = by;
    }

    public final WarningLevel getNewLevel() {
        return this.level;
    }

    public final MiniUserInfo getWarner() {
        return this.by;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.level.getX10Value());
        if (this.by != null) {
            this.by.write(out);
        }
    }

    public String toString() {
        return "WarningNotification: warned to " + this.level + "% by <" + this.by + ">";
    }
}

