/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrentlinkedhashmap;

import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.GuardedBy;
import com.googlecode.concurrentlinkedhashmap.ThreadSafe;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int REORDER_THRESHOLD = 64;
    static final int MAXIMUM_SEGMENTS = 65536;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAXIMUM_WEIGHT = 0x20000000;
    static final Queue discardingQueue = new DiscardingQueue();
    final ConcurrentMap<K, Node<K, V>> data;
    final int concurrencyLevel;
    final int segments;
    final int segmentMask;
    final int segmentShift;
    final Lock[] segmentLock;
    @GuardedBy(value="evictionLock")
    volatile int weightedSize;
    @GuardedBy(value="evictionLock")
    final Node<K, V> sentinel;
    volatile int capacity;
    final Lock evictionLock;
    final Weigher<V> weigher;
    final Queue<Runnable> writeQueue;
    final Queue<Node<K, V>>[] reorderQueue;
    final AtomicInteger[] reorderQueueLength;
    final Queue<Node<K, V>> listenerQueue;
    final EvictionListener<K, V> listener;
    private static final long serialVersionUID = 1L;

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        int ssize;
        this.concurrencyLevel = builder.concurrencyLevel > 65536 ? 65536 : builder.concurrencyLevel;
        int sshift = 0;
        for (ssize = 1; ssize < this.concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = ssize;
        this.segmentLock = new Lock[this.segments];
        this.data = new ConcurrentHashMap<K, Node<K, V>>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.capacity = builder.maximumWeightedCapacity > 0x40000000 ? 0x40000000 : builder.maximumWeightedCapacity;
        this.weigher = builder.weigher;
        this.sentinel = new Node();
        this.evictionLock = new ReentrantLock();
        this.writeQueue = new ConcurrentLinkedQueue<Runnable>();
        this.reorderQueueLength = new AtomicInteger[this.segments];
        this.reorderQueue = new Queue[this.segments];
        for (int i = 0; i < this.segments; ++i) {
            this.segmentLock[i] = new ReentrantLock();
            this.reorderQueueLength[i] = new AtomicInteger();
            this.reorderQueue[i] = new ConcurrentLinkedQueue<Node<K, V>>();
        }
        this.listener = builder.listener;
        this.listenerQueue = this.listener == DiscardingListener.INSTANCE ? discardingQueue : new ConcurrentLinkedQueue();
    }

    private static void checkNotNull(Object o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
    }

    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.evictionLock.lock();
        try {
            this.drainReorderQueues();
            this.drainWriteQueue();
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    private boolean isOverflow() {
        return this.weightedSize > this.capacity;
    }

    @GuardedBy(value="evictionLock")
    private void evict() {
        while (this.isOverflow()) {
            Node node = this.sentinel.next;
            if (this.data.remove(node.key, node)) {
                this.listenerQueue.add(node);
            }
            this.weightedSize -= node.weightedValue.weight;
            node.remove();
        }
    }

    int segmentFor(Object key) {
        int hash = ConcurrentLinkedHashMap.hash(key.hashCode());
        return hash >>> this.segmentShift & this.segmentMask;
    }

    private static int hash(int hashCode) {
        hashCode += hashCode << 15 ^ 0xFFFFCD7D;
        hashCode ^= hashCode >>> 10;
        hashCode += hashCode << 3;
        hashCode ^= hashCode >>> 6;
        hashCode += (hashCode << 2) + (hashCode << 14);
        return hashCode ^ hashCode >>> 16;
    }

    private int addToReorderQueue(Node<K, V> node) {
        int segment = node.segment;
        this.reorderQueue[segment].add(node);
        return this.reorderQueueLength[segment].incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToDrainEvictionQueues(int segment, boolean onlyIfWrites) {
        if (this.writeQueue.isEmpty() && onlyIfWrites) {
            return;
        }
        if (this.evictionLock.tryLock()) {
            try {
                this.drainReorderQueue(segment);
                this.drainWriteQueue();
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToDrainWriteQueue() {
        if (!this.writeQueue.isEmpty() && this.evictionLock.tryLock()) {
            try {
                this.drainWriteQueue();
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteQueue() {
        Runnable task;
        while ((task = this.writeQueue.poll()) != null) {
            task.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReorderQueues() {
        for (int segment = 0; segment < this.segments; ++segment) {
            this.drainReorderQueue(segment);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReorderQueue(int segment) {
        Node<K, V> node;
        int delta = 0;
        Queue<Node<K, V>> queue = this.reorderQueue[segment];
        while ((node = queue.poll()) != null) {
            if (node.isLinked()) {
                node.moveToTail();
            }
            --delta;
        }
        this.reorderQueueLength[segment].addAndGet(delta);
    }

    private void processEvents(int segment, boolean onlyIfWrites) {
        this.attemptToDrainEvictionQueues(segment, onlyIfWrites);
        this.notifyListeners();
    }

    private void notifyListeners() {
        Node<K, V> node;
        while ((node = this.listenerQueue.poll()) != null) {
            this.listener.onEviction(node.key, node.weightedValue.value);
        }
    }

    @Override
    public boolean isEmpty() {
        this.attemptToDrainWriteQueue();
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        this.attemptToDrainWriteQueue();
        return this.data.size();
    }

    public int weightedSize() {
        this.attemptToDrainWriteQueue();
        return this.weightedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            this.drainWriteQueue();
            Node current = this.sentinel.next;
            while (current != this.sentinel) {
                this.weightedSize -= current.weightedValue.weight;
                this.data.remove(current.key, current);
                current = current.next;
                current.prev.prev = null;
                current.prev.next = null;
            }
            this.sentinel.next = this.sentinel;
            this.sentinel.prev = this.sentinel;
            this.drainReorderQueues();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        this.processEvents(this.segmentFor(key), true);
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        this.attemptToDrainWriteQueue();
        for (Node node : this.data.values()) {
            if (!node.weightedValue.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int segment;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        V value = null;
        boolean delayReorder = true;
        Node node = (Node)this.data.get(key);
        if (node == null) {
            segment = this.segmentFor(key);
        } else {
            int buffered = this.addToReorderQueue(node);
            delayReorder = buffered <= 64;
            value = node.weightedValue.value;
            segment = node.segment;
        }
        this.processEvents(segment, delayReorder);
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(K key, V value, boolean onlyIfAbsent) {
        Node<K, V> prior;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        V oldValue = null;
        int weightedDifference = 0;
        boolean delayReorder = true;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node<K, V> node = new Node<K, V>(key, weightedValue, segment, this.sentinel);
        AddTask task = new AddTask(node, weight);
        lock.lock();
        try {
            prior = this.data.putIfAbsent(node.key, node);
            if (prior == null) {
                this.writeQueue.add(task);
            } else if (onlyIfAbsent) {
                oldValue = prior.weightedValue.value;
            } else {
                WeightedValue oldWeightedValue = prior.weightedValue;
                weightedDifference = weight - oldWeightedValue.weight;
                prior.weightedValue = node.weightedValue;
                oldValue = oldWeightedValue.value;
            }
        }
        finally {
            lock.unlock();
        }
        if (prior != null) {
            int buffered;
            if (weightedDifference != 0) {
                this.writeQueue.add(new UpdateTask(weightedDifference));
            }
            delayReorder = (buffered = this.addToReorderQueue(prior)) <= 64;
        }
        this.processEvents(segment, delayReorder);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        V value = null;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        Node node = (Node)this.data.remove(key);
        if (node != null) {
            value = node.weightedValue.value;
            RemovalTask task = new RemovalTask(node);
            lock.lock();
            try {
                this.writeQueue.add(task);
            }
            finally {
                lock.unlock();
            }
        }
        this.processEvents(segment, true);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        boolean removed = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        lock.lock();
        try {
            Node node = (Node)this.data.get(key);
            if (node != null && node.weightedValue.value.equals(value)) {
                this.writeQueue.add(new RemovalTask(node));
                this.data.remove(key);
                removed = true;
            }
        }
        finally {
            lock.unlock();
        }
        this.processEvents(segment, true);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(value, "null value");
        V prior = null;
        int weightedDifference = 0;
        boolean delayReorder = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        lock.lock();
        try {
            node = (Node)this.data.get(key);
            if (node != null) {
                WeightedValue oldWeightedValue = node.weightedValue;
                weightedDifference = weight - oldWeightedValue.weight;
                node.weightedValue = weightedValue;
                prior = oldWeightedValue.value;
            }
        }
        finally {
            lock.unlock();
        }
        if (node != null) {
            int buffered;
            if (weightedDifference != 0) {
                this.writeQueue.add(new UpdateTask(weightedDifference));
            }
            delayReorder = (buffered = this.addToReorderQueue(node)) <= 64;
        }
        this.processEvents(segment, delayReorder);
        return prior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(key, "null key");
        ConcurrentLinkedHashMap.checkNotNull(oldValue, "null oldValue");
        ConcurrentLinkedHashMap.checkNotNull(newValue, "null newValue");
        boolean delayReorder = false;
        int segment = this.segmentFor(key);
        Lock lock = this.segmentLock[segment];
        int weight = this.weigher.weightOf(newValue);
        WeightedValue<V> oldWeightedValue = null;
        WeightedValue<V> newWeightedValue = new WeightedValue<V>(newValue, weight);
        lock.lock();
        try {
            node = (Node)this.data.get(key);
            if (node != null) {
                oldWeightedValue = node.casValue(oldValue, newWeightedValue);
            }
        }
        finally {
            lock.unlock();
        }
        if (node != null) {
            int buffered;
            if (oldWeightedValue != null) {
                this.writeQueue.add(new UpdateTask(newWeightedValue.weight - oldWeightedValue.weight));
            }
            delayReorder = (buffered = this.addToReorderQueue(node)) <= 64;
        }
        this.processEvents(segment, delayReorder);
        return oldWeightedValue != null;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<K, V> {
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        EvictionListener<K, V> listener;
        int maximumWeightedCapacity = -1;
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        Weigher<V> weigher = Weighers.singleton();

        public Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(int maximumWeightedCapacity) {
            if (maximumWeightedCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.maximumWeightedCapacity = maximumWeightedCapacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            if (concurrencyLevel <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> listener) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<V> weigher) {
            if (weigher == null) {
                throw new IllegalArgumentException();
            }
            this.weigher = weigher;
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            this.maximumWeightedCapacity(this.maximumWeightedCapacity);
            return new ConcurrentLinkedHashMap(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SerializationProxy<K, V>
    implements Serializable {
        private final EvictionListener<K, V> listener;
        private final int concurrencyLevel;
        private final Weigher<V> weigher;
        private final Map<K, V> data;
        private final int capacity;
        private static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> map) {
            this.concurrencyLevel = map.concurrencyLevel;
            this.data = new HashMap(map.size());
            this.listener = map.listener;
            this.capacity = map.capacity;
            this.weigher = map.weigher;
            for (Node node : map.data.values()) {
                this.data.put(node.key, node.weightedValue.value);
            }
        }

        private Object readResolve() {
            ConcurrentLinkedHashMap<K, V> map = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            map.putAll(this.data);
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DiscardingListener implements EvictionListener
    {
        INSTANCE;


        public void onEviction(Object key, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DiscardingQueue<E>
    extends AbstractQueue<E> {
        private DiscardingQueue() {
        }

        @Override
        public boolean add(E e) {
            return true;
        }

        @Override
        public boolean offer(E e) {
            return true;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        private static final long serialVersionUID = 1L;

        public WriteThroughEntry(Node<K, V> node) {
            super(node.key, node.weightedValue.value);
        }

        @Override
        public V setValue(V value) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }

        private Object writeReplace() {
            return new SimpleEntry(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Node<K, V>> iterator;
        private Node<K, V> current;

        public EntryIterator(Iterator<Node<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key, this.current.weightedValue.value);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map.data.values().iterator());
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.weightedValue.value.equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public Object[] toArray() {
            ArrayList entries = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                entries.add(new SimpleEntry(entry));
            }
            return entries.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            ArrayList entries = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                entries.add(new SimpleEntry(entry));
            }
            return entries.toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    implements Iterator<V> {
        private final EntryIterator iterator;

        private ValueIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }

        @Override
        public Object[] toArray() {
            ArrayList values = new ArrayList(this.size());
            for (Object value : this) {
                values.add(value);
            }
            return values.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            ArrayList values = new ArrayList(this.size());
            for (Object value : this) {
                values.add(value);
            }
            return values.toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    implements Iterator<K> {
        private final EntryIterator iterator;

        private KeyIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<K, V> {
        final Node<K, V> sentinel;
        Node<K, V> prev;
        Node<K, V> next;
        final K key;
        final int segment;
        @GuardedBy(value="segmentLock")
        volatile WeightedValue<V> weightedValue;

        public Node() {
            this.sentinel = this;
            this.segment = -1;
            this.key = null;
            this.prev = this;
            this.next = this;
        }

        public Node(K key, WeightedValue<V> weightedValue, int segment, Node<K, V> sentinel) {
            this.weightedValue = weightedValue;
            this.sentinel = sentinel;
            this.segment = segment;
            this.key = key;
            this.prev = null;
            this.next = null;
        }

        @GuardedBy(value="segmentLock")
        public WeightedValue<V> casValue(V expect, WeightedValue<V> update) {
            WeightedValue<V> weightedValue = this.weightedValue;
            if (weightedValue.value.equals(expect)) {
                this.weightedValue = update;
                return weightedValue;
            }
            return null;
        }

        @GuardedBy(value="evictionLock")
        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        @GuardedBy(value="evictionLock")
        public void appendToTail() {
            this.prev = this.sentinel.prev;
            this.next = this.sentinel;
            this.sentinel.prev.next = this;
            this.sentinel.prev = this;
        }

        @GuardedBy(value="evictionLock")
        public void moveToTail() {
            if (this.next != this.sentinel) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.appendToTail();
            }
        }

        @GuardedBy(value="evictionLock")
        public boolean isLinked() {
            return this.next != null;
        }

        public String toString() {
            return this.key + "=" + (this == this.sentinel ? "null" : this.weightedValue.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        public WeightedValue(V value, int weight) {
            if (weight < 1 || weight > 0x20000000) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
            this.value = value;
        }
    }

    private final class UpdateTask
    implements Runnable {
        private final int weightDifference;

        public UpdateTask(int weightDifference) {
            this.weightDifference = weightDifference;
        }

        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weightDifference;
            ConcurrentLinkedHashMap.this.evict();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RemovalTask
    implements Runnable {
        private final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (this.node.isLinked()) {
                ConcurrentLinkedHashMap.this.weightedSize -= this.node.weightedValue.weight;
                this.node.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddTask
    implements Runnable {
        private final Node<K, V> node;
        private final int weight;

        AddTask(Node<K, V> node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weight;
            this.node.appendToTail();
            ConcurrentLinkedHashMap.this.evict();
        }
    }
}

