/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.FontStyle;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets.out.ClusterCommandPacket;

public class ClusterSendIMExPacket
extends ClusterCommandPacket {
    protected FontStyle fontStyle;
    protected String message;
    protected int totalFragments;
    protected int fragmentSequence;
    protected char messageId;

    public ClusterSendIMExPacket(QQUser qQUser) {
        super(qQUser);
        this.subCommand = (byte)26;
        this.totalFragments = 1;
        this.fragmentSequence = 0;
        this.messageId = (char)Util.random().nextInt();
        this.fontStyle = new FontStyle();
        this.message = "";
    }

    public ClusterSendIMExPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "Cluster Send IM Ex _08Packet";
    }

    protected void putBody(ByteBuffer byteBuffer) {
        String string;
        int n;
        byteBuffer.put(this.subCommand);
        byteBuffer.putInt(this.clusterId);
        int n2 = byteBuffer.position();
        byteBuffer.putChar('\u0000');
        byteBuffer.putChar('\u0001');
        byteBuffer.put((byte)this.totalFragments);
        byteBuffer.put((byte)this.fragmentSequence);
        byteBuffer.putChar(this.messageId);
        byteBuffer.putInt(0);
        byte[] byArray = null;
        int n3 = 0;
        while ((n = this.message.indexOf(20, n3)) != -1) {
            string = this.message.substring(n3, n);
            if (!string.equals("")) {
                byArray = Util.getBytes(string);
                byteBuffer.put(byArray);
            }
            byteBuffer.put((byte)20);
            byteBuffer.put((byte)(this.message.charAt(n + 1) & 0xFF));
            n3 = n + 2;
        }
        if (n3 < this.message.length()) {
            string = this.message.substring(n3);
            byArray = Util.getBytes(string);
            byteBuffer.put(byArray);
        }
        if (this.fragmentSequence == this.totalFragments - 1) {
            byteBuffer.put((byte)32);
            this.fontStyle.writeBean(byteBuffer);
        }
        int n4 = byteBuffer.position();
        byteBuffer.position(n2);
        byteBuffer.putChar((char)(n4 - n2 - 2));
        byteBuffer.position(n4);
    }

    public int getFragmentSequence() {
        return this.fragmentSequence;
    }

    public void setFragmentSequence(int n) {
        this.fragmentSequence = n;
    }

    public int getTotalFragments() {
        return this.totalFragments;
    }

    public void setTotalFragments(int n) {
        this.totalFragments = n;
    }

    public char getMessageId() {
        return this.messageId;
    }

    public void setMessageId(char c) {
        this.messageId = c;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public int getBlue() {
        return this.fontStyle.getBlue();
    }

    public void setBlue(int n) {
        this.fontStyle.setBlue(n);
    }

    public boolean isBold() {
        return this.fontStyle.isBold();
    }

    public void setBold(boolean bl) {
        this.fontStyle.setBold(bl);
    }

    public char getEncoding() {
        return this.fontStyle.getEncodingCode();
    }

    public void setEncoding(char c) {
        this.fontStyle.setEncodingCode(c);
    }

    public String getFontName() {
        return this.fontStyle.getFontName();
    }

    public void setFontName(String string) {
        this.fontStyle.setFontName(string);
    }

    public int getGreen() {
        return this.fontStyle.getGreen();
    }

    public void setGreen(int n) {
        this.fontStyle.setGreen(n);
    }

    public boolean isItalic() {
        return this.fontStyle.isItalic();
    }

    public void setItalic(boolean bl) {
        this.fontStyle.setItalic(bl);
    }

    public int getRed() {
        return this.fontStyle.getRed();
    }

    public void setRed(int n) {
        this.fontStyle.setRed(n);
    }

    public boolean isUnderline() {
        return this.fontStyle.isUnderline();
    }

    public void setUnderline(boolean bl) {
        this.fontStyle.setUnderline(bl);
    }

    public int getFontSize() {
        return this.fontStyle.getFontSize();
    }

    public void setFontSize(int n) {
        this.fontStyle.setFontSize(n);
    }
}

