/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.CSeqHeader;

public class CSeq
extends SIPHeader
implements CSeqHeader {
    protected Integer seqno;
    protected String method;

    public CSeq() {
        super("CSeq");
    }

    public CSeq(int seqno, String method) {
        this();
        this.seqno = new Integer(seqno);
        this.method = SIPRequest.getCannonicalName(method);
    }

    public boolean equals(Object other) {
        try {
            CSeq that = (CSeq)other;
            if (!this.seqno.equals(that.seqno)) {
                return false;
            }
            return this.method.compareToIgnoreCase(that.method) == 0;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    public String encodeBody() {
        return this.seqno + " " + this.method.toUpperCase();
    }

    public String getMethod() {
        return this.method;
    }

    public void setSequenceNumber(int sequenceNumber) throws InvalidArgumentException {
        if (sequenceNumber < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, CSeq, setSequenceNumber(), the sequence number parameter is < 0");
        }
        this.seqno = new Integer(sequenceNumber);
    }

    public void setMethod(String meth) throws ParseException {
        if (meth == null) {
            throw new NullPointerException("JAIN-SIP Exception, CSeq, setMethod(), the meth parameter is null");
        }
        this.method = SIPRequest.getCannonicalName(meth);
    }

    public int getSequenceNumber() {
        if (this.seqno == null) {
            return 0;
        }
        return this.seqno;
    }
}

