/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;
import org.jrobin.core.Util;

public class XmlWriter {
    static final String INDENT_STR = "   ";
    private PrintWriter writer;
    private StringBuffer indent = new StringBuffer("");
    private Stack<String> openTags = new Stack();

    public XmlWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream, true);
    }

    public void startTag(String string) {
        this.writer.println(this.indent + "<" + string + ">");
        this.openTags.push(string);
        this.indent.append(INDENT_STR);
    }

    public void closeTag() {
        String string = this.openTags.pop();
        this.indent.setLength(this.indent.length() - INDENT_STR.length());
        this.writer.println(this.indent + "</" + string + ">");
    }

    public void writeTag(String string, Object object) {
        if (object != null) {
            this.writer.println(this.indent + "<" + string + ">" + XmlWriter.escape(object.toString()) + "</" + string + ">");
        } else {
            this.writer.println(this.indent + "<" + string + "></" + string + ">");
        }
    }

    public void writeTag(String string, int n) {
        this.writeTag(string, "" + n);
    }

    public void writeTag(String string, long l) {
        this.writeTag(string, "" + l);
    }

    public void writeTag(String string, double d, String string2) {
        this.writeTag(string, Util.formatDouble(d, string2, true));
    }

    public void writeTag(String string, double d) {
        this.writeTag(string, Util.formatDouble(d, true));
    }

    public void writeTag(String string, boolean bl) {
        this.writeTag(string, "" + bl);
    }

    public void writeTag(String string, Color color) {
        int n = color.getRGB() & 0xFFFFFF;
        this.writeTag(string, "#" + Integer.toHexString(n).toUpperCase());
    }

    public void writeTag(String string, Font font) {
        this.startTag(string);
        this.writeTag("name", font.getName());
        int n = font.getStyle();
        if ((n & 1) != 0 && (n & 2) != 0) {
            this.writeTag("style", "BOLDITALIC");
        } else if ((n & 1) != 0) {
            this.writeTag("style", "BOLD");
        } else if ((n & 2) != 0) {
            this.writeTag("style", "ITALIC");
        } else {
            this.writeTag("style", "PLAIN");
        }
        this.writeTag("size", font.getSize());
        this.closeTag();
    }

    public void writeTag(String string, File file) {
        this.writeTag(string, file.getPath());
    }

    public void flush() {
        this.writer.flush();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.writer.close();
    }

    public void writeComment(Object object) {
        this.writer.println(this.indent + "<!-- " + XmlWriter.escape(object.toString()) + " -->");
    }

    private static String escape(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

