/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class ClientStateMonitor
implements Observer {
    static Logger log = Logger.getLogger(ClientStateMonitor.class);
    private IRCConnection connection;
    private boolean enabled = false;

    ClientStateMonitor(IRCConnection connection) {
        this.connection = connection;
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.connection.addCommandObserver(this);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.connection.removeCommandObserver(this);
        this.enabled = false;
    }

    public void update(Observable observable, Object command_o) {
        InCommand command = (InCommand)command_o;
        try {
            if (command.updateClientState(this.connection.getClientState())) {
                log.debug((Object)"ClientStateMonnitor: Client state updated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"ClientStateMonitor: Client state update failed.", e);
        }
    }
}

