/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foobar.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.Locale;

public class NumberFormatProviderImpl
extends NumberFormatProvider {
    static Locale[] avail = new Locale[]{Locale.JAPAN, new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), new Locale("zz")};
    static String[] dialect = new String[]{"\u3067\u3059\u3002", "\u3084\u3002", "\u3069\u3059\u3002", "-zz"};
    static String[] patterns = new String[]{"#,##0.###{0};-#,##0.###{1}", "\u00a4#,##0{0};-\u00a4#,##0{1}", "#,##0%{0}"};
    static final int NUMBERSTYLE = 0;
    static final int CURRENCYSTYLE = 1;
    static final int PERCENTSTYLE = 2;

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public NumberFormat getCurrencyInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            String string = MessageFormat.format(patterns[1], dialect[i], dialect[i]);
            DecimalFormat decimalFormat = new DecimalFormat(string, DecimalFormatSymbols.getInstance(locale));
            this.adjustForCurrencyDefaultFractionDigits(decimalFormat);
            return decimalFormat;
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            String string = MessageFormat.format(patterns[0], dialect[i], dialect[i]);
            DecimalFormat decimalFormat = new DecimalFormat(string, DecimalFormatSymbols.getInstance(locale));
            decimalFormat.setMaximumFractionDigits(0);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setParseIntegerOnly(true);
            return decimalFormat;
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            String string = MessageFormat.format(patterns[0], dialect[i], dialect[i]);
            return new DecimalFormat(string, DecimalFormatSymbols.getInstance(locale));
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            String string = MessageFormat.format(patterns[2], dialect[i]);
            return new DecimalFormat(string, DecimalFormatSymbols.getInstance(locale));
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    void adjustForCurrencyDefaultFractionDigits(DecimalFormat decimalFormat) {
        int n;
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        Currency currency = decimalFormatSymbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(decimalFormatSymbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n = currency.getDefaultFractionDigits()) != -1) {
            int n2 = decimalFormat.getMinimumFractionDigits();
            if (n2 == decimalFormat.getMaximumFractionDigits()) {
                decimalFormat.setMinimumFractionDigits(n);
                decimalFormat.setMaximumFractionDigits(n);
            } else {
                decimalFormat.setMinimumFractionDigits(Math.min(n, n2));
                decimalFormat.setMaximumFractionDigits(n);
            }
        }
    }
}

