/*
 * Copyright (c) 1997, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_zh_CN extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre \u65f6\u95f4", "ACT",
                                     "Acre \u590f\u4ee4\u65f6", "ACST"};
        String ADELAIDE[] = new String[] {"\u4e2d\u592e\u6807\u51c6\u65f6\u95f4\uff08\u5357\u6fb3\u5927\u5229\u4e9a\uff09", "CST",
                                          "\u4e2d\u592e\u590f\u4ee4\u65f6\uff08\u5357\u6fb3\u5927\u5229\u4e9a\uff09", "CST"};
        String AGT[] = new String[] {"\u963f\u6839\u5ef7\u65f6\u95f4", "ART",
                                     "\u963f\u6839\u5ef7\u590f\u4ee4\u65f6", "ARST"};
        String AKST[] = new String[] {"\u963f\u62c9\u65af\u52a0\u6807\u51c6\u65f6\u95f4", "AKST",
                                      "\u963f\u62c9\u65af\u52a0\u590f\u4ee4\u65f6", "AKDT"};
        String AMT[] = new String[] {"\u4e9a\u9a6c\u900a\u65f6\u95f4", "AMT",
                                     "\u4e9a\u9a6c\u900a\u590f\u4ee4\u65f6", "AMST"};
        String ARAST[] = new String[] {"\u963f\u62c9\u4f2f\u6807\u51c6\u65f6\u95f4", "AST",
                                       "\u963f\u62c9\u4f2f\u590f\u4ee4\u65f6", "ADT"};
        String ARMT[] = new String[] {"\u4e9a\u7f8e\u5c3c\u4e9a\u65f6\u95f4", "AMT",
                                      "\u4e9a\u7f8e\u5c3c\u4e9a\u590f\u4ee4\u65f6", "AMST"};
        String AST[] = new String[] {"\u5927\u897f\u6d0b\u6807\u51c6\u65f6\u95f4", "AST",
                                     "\u5927\u897f\u6d0b\u590f\u4ee4\u65f6", "ADT"};
        String BDT[] = new String[] {"\u5b5f\u52a0\u62c9\u65f6\u95f4", "BDT",
                                     "\u5b5f\u52a0\u62c9\u590f\u4ee4\u65f6", "BDST"};
        String BRISBANE[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u6606\u58eb\u5170\uff09", "EST",
                                          "\u4e1c\u90e8\u590f\u4ee4\u65f6\uff08\u6606\u58eb\u5170\uff09", "EST"};
        String BROKEN_HILL[] = new String[] {"\u4e2d\u592e\u6807\u51c6\u65f6\u95f4\uff08\u5357\u6fb3\u5927\u5229\u4e9a/\u65b0\u5357\u5a01\u5c14\u65af\uff09", "CST",
                                             "\u4e2d\u592e\u590f\u4ee4\u65f6\uff08\u5357\u6fb3\u5927\u5229\u4e9a/\u65b0\u5357\u5a01\u5c14\u65af\uff09", "CST"};
        String BRT[] = new String[] {"\u5df4\u897f\u5229\u4e9a\u65f6\u95f4", "BRT",
                                     "\u5df4\u897f\u5229\u4e9a\u590f\u4ee4\u65f6", "BRST"};
        String BTT[] = new String[] {"\u4e0d\u4e39\u65f6\u95f4", "BTT",
                                     "\u4e0d\u4e39\u590f\u4ee4\u65f6", "BTST"};
        String CAT[] = new String[] {"\u4e2d\u975e\u65f6\u95f4", "CAT",
                                     "\u4e2d\u975e\u590f\u4ee4\u65f6", "CAST"};
        String CET[] = new String[] {"\u4e2d\u6b27\u65f6\u95f4", "CET",
                                     "\u4e2d\u6b27\u590f\u4ee4\u65f6", "CEST"};
        String CHAST[] = new String[] {"\u67e5\u8428\u59c6\u6807\u51c6\u65f6\u95f4", "CHAST",
                                       "\u67e5\u8428\u59c6\u590f\u4ee4\u65f6", "CHADT"};
        String CHUT[] = new String[] {"Chuuk Time", "CHUT",
                                      "Chuuk Summer Time", "CHUST"};
        String CIT[] = new String[] {"\u4e2d\u90e8\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "CIT",
                                     "\u4e2d\u90e8\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "CIST"};
        String CLT[] = new String[] {"\u667a\u5229\u65f6\u95f4", "CLT",
                                     "\u667a\u5229\u590f\u4ee4\u65f6", "CLST"};
        String CST[] = new String[] {"\u4e2d\u592e\u6807\u51c6\u65f6\u95f4", "CST",
                                     "\u4e2d\u592e\u590f\u4ee4\u65f6", "CDT"};
        String CTT[] = new String[] {"\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", "CST",
                                     "\u4e2d\u56fd\u590f\u4ee4\u65f6", "CDT"};
        String CUBA[] = new String[] {"\u53e4\u5df4\u6807\u51c6\u65f6\u95f4", "CST",
                                      "\u53e4\u5df4\u590f\u4ee4\u65f6", "CDT"};
        String DARWIN[] = new String[] {"\u4e2d\u592e\u6807\u51c6\u65f6\u95f4\uff08\u5317\u9886\u5730\uff09", "CST",
                                        "\u4e2d\u592e\u590f\u4ee4\u65f6\uff08\u5317\u9886\u5730\uff09", "CST"};
        String DUBLIN[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                        "\u7231\u5c14\u5170\u590f\u4ee4\u65f6", "IST"};
        String EAT[] = new String[] {"\u4e1c\u975e\u65f6\u95f4", "EAT",
                                     "\u4e1c\u975e\u590f\u4ee4\u65f6", "EAST"};
        String EASTER[] = new String[] {"\u590d\u6d3b\u5c9b\u65f6\u95f4", "EAST",
                                        "\u590d\u6d3b\u5c9b\u590f\u4ee4\u65f6", "EASST"};
        String EET[] = new String[] {"\u4e1c\u6b27\u65f6\u95f4", "EET",
                                     "\u4e1c\u6b27\u590f\u4ee4\u65f6", "EEST"};
        String EGT[] = new String[] {"\u4e1c\u683c\u6797\u5c9b\u65f6\u95f4", "EGT",
                                     "\u4e1c\u683c\u6797\u5c9b\u590f\u4ee4\u65f6", "EGST"};
        String EST[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EST",
                                     "\u4e1c\u90e8\u590f\u4ee4\u65f6", "EDT"};
        String EST_NSW[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u65b0\u5357\u5a01\u5c14\u65af\uff09", "EST",
                                         "\u4e1c\u90e8\u590f\u4ee4\u65f6\uff08\u65b0\u5357\u5a01\u5c14\u65af\uff09", "EST"};
        String GHMT[] = new String[] {"\u52a0\u7eb3\u65f6\u95f4", "GMT",
                                     "\u52a0\u7eb3\u590f\u4ee4\u65f6", "GHST"};
        String GAMBIER[] =  new String[] {"\u5188\u6bd4\u4e9a\u65f6\u95f4", "GAMT",
                                          "\u5188\u6bd4\u4e9a\u590f\u4ee4\u65f6", "GAMST"};
        String GMT[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                     "\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT"};
        String GMTBST[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                        "\u82f1\u56fd\u590f\u4ee4\u65f6", "BST"};
        String GST[] = new String[] {"\u6ce2\u65af\u6e7e\u6807\u51c6\u65f6\u95f4", "GST",
                                     "\u6ce2\u65af\u6e7e\u590f\u4ee4\u65f6", "GDT"};
        String HAST[] = new String[] {"\u590f\u5a01\u5937-\u963f\u7559\u7533\u7fa4\u5c9b\u6807\u51c6\u65f6\u95f4", "HAST",
                                      "\u590f\u5a01\u5937-\u963f\u7559\u7533\u7fa4\u5c9b\u590f\u4ee4\u65f6", "HADT"};
        String HKT[] =  new String[] {"\u9999\u6e2f\u65f6\u95f4", "HKT",
                                      "\u9999\u6e2f\u590f\u4ee4\u65f6", "HKST"};
        String HST[] = new String[] {"\u590f\u5a01\u5937\u6807\u51c6\u65f6\u95f4", "HST",
                                     "\u590f\u5a01\u5937\u590f\u4ee4\u65f6", "HDT"};
        String ICT[] = new String[] {"\u5370\u5ea6\u652f\u90a3\u65f6\u95f4", "ICT",
                                     "\u5370\u5ea6\u652f\u90a3\u590f\u4ee4\u65f6", "ICST"};
        String IRT[] = new String[] {"\u4f0a\u6717\u6807\u51c6\u65f6\u95f4", "IRST",
                                     "\u4f0a\u6717\u590f\u4ee4\u65f6", "IRDT"};
        String ISRAEL[] = new String[] {"\u4ee5\u8272\u5217\u6807\u51c6\u65f6\u95f4", "IST",
                                        "\u4ee5\u8272\u5217\u590f\u4ee4\u65f6", "IDT"};
        String IST[] = new String[] {"\u5370\u5ea6\u6807\u51c6\u65f6\u95f4", "IST",
                                     "\u5370\u5ea6\u590f\u4ee4\u65f6", "IDT"};
        String JST[] = new String[] {"\u65e5\u672c\u6807\u51c6\u65f6\u95f4", "JST",
                                     "\u65e5\u672c\u590f\u4ee4\u65f6", "JDT"};
        String KST[] = new String[] {"\u97e9\u56fd\u6807\u51c6\u65f6\u95f4", "KST",
                                     "\u97e9\u56fd\u590f\u4ee4\u65f6", "KDT"};
        String LORD_HOWE[] = new String[] {"\u8c6a\u516c\u6807\u51c6\u65f6\u95f4", "LHST",
                                           "\u8c6a\u516c\u590f\u4ee4\u65f6", "LHST"};
        String MHT[] = new String[] {"\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u65f6\u95f4", "MHT",
                                     "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "MHST"};
        String MSK[] = new String[] {"\u83ab\u65af\u79d1\u6807\u51c6\u65f6\u95f4", "MSK",
                                     "\u83ab\u65af\u79d1\u590f\u4ee4\u65f6", "MSD"};
        String MST[] = new String[] {"Mountain \u6807\u51c6\u65f6\u95f4", "MST",
                                     "Mountain \u590f\u4ee4\u65f6", "MDT"};
        String MYT[] = new String[] {"\u9a6c\u6765\u897f\u4e9a\u65f6\u95f4", "MYT",
                                     "\u9a6c\u6765\u897f\u4e9a\u590f\u4ee4\u65f6", "MYST"};
        String NORONHA[] = new String[] {"\u8d39\u5c14\u5357\u591a\u5fb7\u8bfa\u7f57\u5c3c\u4e9a\u65f6\u95f4", "FNT",
                                         "\u8d39\u5c14\u5357\u591a\u5fb7\u8bfa\u7f57\u5c3c\u4e9a\u590f\u4ee4\u65f6", "FNST"};
        String NOVT[] = new String[] {"Novosibirsk \u65f6\u95f4", "NOVT",
                                      "Novosibirsk \u590f\u4ee4\u65f6", "NOVST"};
        String NPT[] = new String[] {"\u5c3c\u6cca\u5c14\u65f6\u95f4", "NPT",
                                     "\u5c3c\u6cca\u5c14\u590f\u4ee4\u65f6", "NPST"};
        String NST[] = new String[] {"\u7ebd\u82ac\u5170\u6807\u51c6\u65f6\u95f4", "NST",
                                     "\u7ebd\u82ac\u5170\u590f\u4ee4\u65f6", "NDT"};
        String NZST[] = new String[] {"\u65b0\u897f\u5170\u6807\u51c6\u65f6\u95f4", "NZST",
                                      "\u65b0\u897f\u5170\u590f\u4ee4\u65f6", "NZDT"};
        String PITCAIRN[] = new String[] {"\u76ae\u7279\u5eb7\u5c9b\u6807\u51c6\u65f6\u95f4", "PST",
                                          "\u76ae\u7279\u5eb7\u5c9b\u590f\u4ee4\u65f6", "PDT"};
        String PKT[] = new String[] {"\u5df4\u57fa\u65af\u5766\u65f6\u95f4", "PKT",
                                     "\u5df4\u57fa\u65af\u5766\u590f\u4ee4\u65f6", "PKST"};
        String PONT[] = new String[] {"Pohnpei Time", "PONT",
                                      "Pohnpei Summer Time", "PONST"};
        String PST[] = new String[] {"\u592a\u5e73\u6d0b\u6807\u51c6\u65f6\u95f4", "PST",
                                     "\u592a\u5e73\u6d0b\u590f\u4ee4\u65f6", "PDT"};
        String RST[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EST",
                                     "\u4e2d\u592e\u590f\u4ee4\u65f6", "CDT"};
        String SAST[] = new String[] {"\u5357\u975e\u6807\u51c6\u65f6\u95f4", "SAST",
                                      "\u5357\u975e\u590f\u4ee4\u65f6", "SAST"};
        String SBT[] = new String[] {"\u6240\u7f57\u95e8\u7fa4\u5c9b\u65f6\u95f4", "SBT",
                                     "\u6240\u7f57\u95e8\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SBST"};
        String SGT[] = new String[] {"\u65b0\u52a0\u5761\u65f6\u95f4", "SGT",
                                     "\u65b0\u52a0\u5761\u590f\u4ee4\u65f6", "SGST"};
        String SLST[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                      "\u585e\u62c9\u5229\u6602\u590f\u4ee4\u65f6", "SLST"};
        String TASMANIA[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u5854\u65af\u9a6c\u5c3c\u4e9a\uff09", "EST",
                                          "\u4e1c\u90e8\u590f\u4ee4\u65f6\uff08\u5854\u65af\u9a6c\u5c3c\u4e9a\uff09", "EST"};
        String TMT[] = new String[] {"\u571f\u5e93\u66fc\u65f6\u95f4", "TMT",
                                     "\u571f\u5e93\u66fc\u590f\u4ee4\u65f6", "TMST"};
        String ULAT[]= new String[] {"\u5e93\u4f26\u65f6\u95f4", "ULAT",
                                     "\u5e93\u4f26\u590f\u4ee4\u65f6", "ULAST"};
        String WART[] = new String[] {"\u897f\u963f\u6839\u5ef7\u65f6\u95f4", "WART",
                                      "\u897f\u963f\u6839\u5ef7\u590f\u4ee4\u65f6", "WARST"};
        String WAT[] = new String[] {"\u897f\u975e\u65f6\u95f4", "WAT",
                                     "\u897f\u975e\u590f\u4ee4\u65f6", "WAST"};
        String WET[] = new String[] {"\u897f\u6b27\u65f6\u95f4", "WET",
                                     "\u897f\u6b27\u590f\u4ee4\u65f6", "WEST"};
        String WIT[] = new String[] {"\u897f\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "WIT",
                                     "\u897f\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "WIST"};
        String WST_AUS[] = new String[] {"\u897f\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u6fb3\u5927\u5229\u4e9a\uff09", "WST",
                                         "\u897f\u90e8\u590f\u4ee4\u65f6\uff08\u6fb3\u5927\u5229\u4e9a\uff09", "WST"};
        String SAMOA[] = new String[] {"\u8428\u6469\u4e9a\u7fa4\u5c9b\u6807\u51c6\u65f6\u95f4", "SST",
                                       "\u8428\u6469\u4e9a\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SDT"};
        String WST_SAMOA[] = new String[] {"\u897f\u8428\u6469\u4e9a\u65f6\u95f4", "WST",
                                           "\u897f\u8428\u6469\u4e9a\u590f\u4ee4\u65f6", "WSST"};
        String ChST[] = new String[] {"Chamorro \u6807\u51c6\u65f6\u95f4", "ChST",
                                      "Chamorro \u590f\u4ee4\u65f6", "ChDT"};
        String VICTORIA[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u7ef4\u591a\u5229\u4e9a\uff09", "EST",
                                          "\u4e1c\u90e8\u590f\u4ee4\u65f6\uff08\u7ef4\u591a\u5229\u4e9a\uff09", "EST"};
        String UTC[] = new String[] {"\u534f\u8c03\u4e16\u754c\u65f6\u95f4", "UTC",
                                     "\u534f\u8c03\u4e16\u754c\u65f6\u95f4", "UTC"};
        String UZT[] = new String[] {"\u4e4c\u5179\u522b\u514b\u65af\u5766\u65f6\u95f4", "UZT",
                                     "\u4e4c\u5179\u522b\u514b\u65af\u5766\u590f\u4ee4\u65f6", "UZST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", SLST},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HAST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", WART},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"\u5df4\u62c9\u572d\u65f6\u95f4", "PYT",
                                               "\u5df4\u62c9\u572d\u590f\u4ee4\u65f6", "PYST"}},
            {"America/Atikokan", EST},
            {"America/Atka", HAST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"\u54e5\u4f26\u6bd4\u4e9a\u65f6\u95f4", "COT",
                                             "\u54e5\u4f26\u6bd4\u4e9a\u590f\u4ee4\u65f6", "COST"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", CST},
            {"America/Caracas", new String[] {"\u59d4\u5185\u745e\u62c9\u65f6\u95f4", "VET",
                                              "\u59d4\u5185\u745e\u62c9\u590f\u4ee4\u65f6", "VEST"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"\u6cd5\u5c5e\u572d\u4e9a\u90a3\u65f6\u95f4", "GFT",
                                              "\u6cd5\u5c5e\u572d\u4e9a\u90a3\u590f\u4ee4\u65f6", "GFST"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", AMT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"\u897f\u683c\u6797\u5170\u5c9b\u65f6\u95f4", "WGT",
                                              "\u897f\u683c\u6797\u5170\u5c9b\u590f\u4ee4\u65f6", "WGST"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"\u5384\u74dc\u591a\u5c14\u65f6\u95f4", "ECT",
                                                "\u5384\u74dc\u591a\u5c14\u590f\u4ee4\u65f6", "ECST"}},
            {"America/Guyana", new String[] {"\u572d\u4e9a\u90a3\u65f6\u95f4", "GYT",
                                             "\u572d\u4e9a\u90a3\u590f\u4ee4\u65f6", "GYST"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/La_Paz", new String[] {"\u73bb\u5229\u7ef4\u4e9a\u65f6\u95f4", "BOT",
                                             "\u73bb\u5229\u7ef4\u4e9a\u590f\u4ee4\u65f6", "BOST"}},
            {"America/Lima", new String[] {"\u79d8\u9c81\u65f6\u95f4", "PET",
                                           "\u79d8\u9c81\u590f\u4ee4\u65f6", "PEST"}},
            {"America/Louisville", EST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"\u76ae\u57c3\u5c14\u5c9b\u53ca\u5bc6\u514b\u9686\u5c9b\u6807\u51c6\u65f6\u95f4", "PMST",
                                               "\u76ae\u57c3\u5c14\u5c9b\u53ca\u5bc6\u514b\u9686\u5c9b\u590f\u4ee4\u65f6", "PMDT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"\u4e4c\u62c9\u572d\u65f6\u95f4", "UYT",
                                                 "\u4e4c\u62c9\u572d\u590f\u4ee4\u65f6", "UYST"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"\u82cf\u5229\u5357\u65f6\u95f4", "SRT",
                                                 "\u82cf\u5229\u5357\u590f\u4ee4\u65f6", "SRST"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", AMT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", RST},
            {"America/Rio_Branco", AMT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"\u6234\u7ef4\u65af\u65f6\u95f4", "DAVT",
                                               "\u6234\u7ef4\u65af\u590f\u4ee4\u65f6", "DAVST"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville \u65f6\u95f4", "DDUT",
                                                        "Dumont-d'Urville \u590f\u4ee4\u65f6", "DDUST"}},
            {"Antarctica/Macquarie", new String[] {"Macquarie Island Time", "MIST",
                                                   "Macquarie Island Summer Time", "MIST"}},
            {"Antarctica/Mawson", new String[] {"\u83ab\u68ee\u65f6\u95f4", "MAWT",
                                                "\u83ab\u68ee\u590f\u4ee4\u65f6", "MAWST"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"\u7f57\u745f\u62c9\u65f6\u95f4", "ROTT",
                                                 "\u7f57\u745f\u62c9\u590f\u4ee4\u65f6", "ROTST"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa \u65f6\u95f4", "SYOT",
                                               "Syowa \u590f\u4ee4\u65f6", "SYOST"}},
            {"Antarctica/Vostok", new String[] {"\u83ab\u65af\u6258\u514b\u65f6\u95f4", "VOST",
                                                "\u83ab\u65af\u6258\u514b\u590f\u4ee4\u65f6", "VOSST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma-Ata \u65f6\u95f4", "ALMT",
                                          "Alma-Ata \u590f\u4ee4\u65f6", "ALMST"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"\u963f\u90a3\u5e95\u6cb3\u65f6\u95f4", "ANAT",
                                          "\u963f\u90a3\u5e95\u6cb3\u590f\u4ee4\u65f6", "ANAST"}},
            {"Asia/Aqtau", new String[] {"Aqtau \u65f6\u95f4", "AQTT",
                                         "Aqtau \u590f\u4ee4\u65f6", "AQTST"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe \u65f6\u95f4", "AQTT",
                                          "Aqtobe \u590f\u4ee4\u65f6", "AQTST"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"\u4e9a\u585e\u62dc\u7136\u65f6\u95f4", "AZT",
                                        "\u4e9a\u585e\u62dc\u7136\u590f\u4ee4\u65f6", "AZST"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"\u5409\u5c14\u5409\u65af\u65af\u5766\u65f6\u95f4", "KGT",
                                           "\u5409\u5c14\u5409\u65af\u65af\u5766\u590f\u4ee4\u65f6", "KGST"}},
            {"Asia/Brunei", new String[] {"\u6587\u83b1\u65f6\u95f4", "BNT",
                                          "\u6587\u83b1\u590f\u4ee4\u65f6", "BNST"}},
            {"Asia/Calcutta", IST},
            {"Asia/Choibalsan", new String[] {"Choibalsan \u65f6\u95f4", "CHOT",
                                              "Choibalsan \u590f\u4ee4\u65f6", "CHOST"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"\u4e1c\u5e1d\u6c76\u65f6\u95f4", "TLT",
                                        "\u4e1c\u5e1d\u6c76\u590f\u4ee4\u65f6", "TLST"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"\u5854\u5409\u514b\u65af\u5766\u65f6\u95f4", "TJT",
                                            "\u5854\u5409\u514b\u65af\u5766\u590f\u4ee4\u65f6", "TJST"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"\u79d1\u5e03\u591a\u65f6\u95f4", "HOVT",
                                        "\u79d1\u5e03\u591a\u590f\u4ee4\u65f6", "HOVST"}},
            {"Asia/Irkutsk", new String[] {"\u4f0a\u5c14\u5e93\u6b21\u514b\u65f6\u95f4", "IRKT",
                                           "\u4f0a\u5c14\u5e93\u6b21\u514b\u590f\u4ee4\u65f6", "IRKST"}},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\u4e1c\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "EIT",
                                            "\u4e1c\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "EIST"}},
            {"Asia/Kabul", new String[] {"\u963f\u5bcc\u6c57\u65f6\u95f4", "AFT",
                                         "\u963f\u5bcc\u6c57\u590f\u4ee4\u65f6", "AFST"}},
            {"Asia/Kamchatka", new String[] {"\u5f7c\u5f97\u7f57\u5df4\u752b\u6d1b\u592b\u65af\u514b\u65f6\u95f4", "PETT",
                                             "\u5f7c\u5f97\u7f57\u5df4\u752b\u6d1b\u592b\u65af\u514b\u590f\u4ee4\u65f6", "PETST"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", CTT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", new String[] {"\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u65f6\u95f4", "KRAT",
                                               "\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u590f\u4ee4\u65f6", "KRAST"}},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadan \u65f6\u95f4", "MAGT",
                                           "Magadan \u590f\u4ee4\u65f6", "MAGST"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"\u83f2\u5f8b\u5bbe\u65f6\u95f4", "PHT",
                                          "\u83f2\u5f8b\u5bbe\u590f\u4ee4\u65f6", "PHST"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", NOVT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral \u65f6\u95f4", "ORAT",
                                        "Oral \u590f\u4ee4\u65f6", "ORAST"}},
            {"Asia/Omsk", new String[] {"\u9102\u6728\u65af\u514b\u65f6\u95f4", "OMST",
                                        "\u9102\u6728\u65af\u514b\u590f\u4ee4\u65f6", "OMSST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda \u65f6\u95f4", "QYZT",
                                             "Qyzylorda \u590f\u4ee4\u65f6", "QYZST"}},
            {"Asia/Rangoon", new String[] {"\u7f05\u7538\u65f6\u95f4", "MMT",
                                           "\u7f05\u7538\u590f\u4ee4\u65f6", "MMST"}},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"\u5e93\u9875\u5c9b\u65f6\u95f4", "SAKT",
                                            "\u5e93\u9875\u5c9b\u590f\u4ee4\u65f6", "SAKST"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"\u4e54\u6cbb\u4e9a\u65f6\u95f4", "GET",
                                           "\u4e54\u6cbb\u4e9a\u590f\u4ee4\u65f6", "GEST"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", CTT},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"\u6d77\u53c2\u5d34\u65f6\u95f4", "VLAT",
                                               "\u6d77\u53c2\u5d34\u590f\u4ee4\u65f6", "VLAST"}},
            {"Asia/Yakutsk", new String[] {"\u4e9a\u5e93\u6b21\u514b\u65f6\u95f4", "YAKT",
                                           "\u4e9a\u5e93\u6b21\u514b\u590f\u4ee4\u65f6", "YAKST"}},
            {"Asia/Yekaterinburg", new String[] {"Yekaterinburg \u65f6\u95f4", "YEKT",
                                                 "Yekaterinburg \u590f\u4ee4\u65f6", "YEKST"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"\u4e9a\u901f\u5c14\u7fa4\u5c9b\u65f6\u95f4", "AZOT",
                                              "\u4e9a\u901f\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "AZOST"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"\u4f5b\u5fb7\u89d2\u65f6\u95f4", "CVT",
                                                  "\u4f5b\u5fb7\u89d2\u590f\u4ee4\u65f6", "CVST"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"\u5357\u4e54\u6cbb\u4e9a\u6807\u51c6\u65f6\u95f4", "GST",
                                                     "\u5357\u4e54\u6cbb\u4e9a\u590f\u4ee4\u65f6", "GDT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"\u798f\u514b\u5170\u7fa4\u5c9b\u65f6\u95f4", "FKT",
                                               "\u798f\u514b\u5170\u7fa4\u5c9b\u590f\u4ee4\u65f6", "FKST"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"\u4e2d\u897f\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u6fb3\u5927\u5229\u4e9a\uff09", "CWST",
                                              "\u4e2d\u897f\u90e8\u590f\u4ee4\u65f6\uff08\u6fb3\u5927\u5229\u4e9a\uff09", "CWST"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", AMT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", EET},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"\u6c99\u9a6c\u62c9\u65f6\u95f4", "SAMT",
                                            "\u6c99\u9a6c\u62c9\u590f\u4ee4\u65f6", "SAMST"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", EET},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", new String[] {"\u4f0f\u5c14\u52a0\u683c\u52d2\u65f6\u95f4", "VOLT",
                                               "\u4f0f\u5c14\u52a0\u683c\u52d2\u590f\u4ee4\u65f6", "VOLST"}},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"\u5370\u5ea6\u6d0b\u5730\u5e26\u65f6\u95f4", "IOT",
                                            "\u5370\u5ea6\u6d0b\u5730\u5e26\u590f\u4ee4\u65f6", "IOST"}},
            {"Indian/Christmas", new String[] {"\u5723\u8bde\u5c9b\u65f6\u95f4", "CXT",
                                               "\u5723\u8bde\u5c9b\u590f\u4ee4\u65f6", "CXST"}},
            {"Indian/Cocos", new String[] {"\u53ef\u53ef\u65af\u7fa4\u5c9b\u65f6\u95f4", "CCT",
                                           "\u53ef\u53ef\u65af\u7fa4\u5c9b\u590f\u4ee4\u65f6", "CCST"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"\u6cd5\u5c5e\u5357\u6781\u65f6\u95f4", "TFT",
                                               "\u6cd5\u5c5e\u5357\u6781\u590f\u4ee4\u65f6", "TFST"}},
            {"Indian/Mahe", new String[] {"\u585e\u5e2d\u5c14\u7fa4\u5c9b\u65f6\u95f4", "SCT",
                                          "\u585e\u5e2d\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SCST"}},
            {"Indian/Maldives", new String[] {"\u9a6c\u5c14\u4ee3\u592b\u65f6\u95f4", "MVT",
                                              "\u9a6c\u5c14\u4ee3\u592b\u590f\u4ee4\u65f6", "MVST"}},
            {"Indian/Mauritius", new String[] {"\u6469\u91cc\u897f\u65af\u65f6\u95f4", "MUT",
                                               "\u6469\u91cc\u897f\u65af\u590f\u4ee4\u65f6", "MUST"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"\u7559\u5c3c\u65fa\u5c9b\u65f6\u95f4", "RET",
                                             "\u7559\u5c3c\u65fa\u5c9b\u590f\u4ee4\u65f6", "REST"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"\u4e2d\u6b27\u65f6\u95f4", "MET",
                                  "\u4e2d\u6b27\u590f\u4ee4\u65f6", "MEST"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"\u74e6\u5974\u963f\u56fe\u65f6\u95f4", "VUT",
                                            "\u74e6\u5974\u963f\u56fe\u590f\u4ee4\u65f6", "VUST"}},
            {"Pacific/Enderbury", new String[] {"\u83f2\u5c3c\u514b\u65af\u7fa4\u5c9b\u65f6\u95f4", "PHOT",
                                                "\u83f2\u5c3c\u514b\u65af\u7fa4\u5c9b\u590f\u4ee4\u65f6", "PHOST"}},
            {"Pacific/Fakaofo", new String[] {"\u6258\u514b\u52b3\u7fa4\u5c9b\u65f6\u95f4", "TKT",
                                              "\u6258\u514b\u52b3\u7fa4\u5c9b\u590f\u4ee4\u65f6", "TKST"}},
            {"Pacific/Fiji", new String[] {"\u6590\u6d4e\u65f6\u95f4", "FJT",
                                           "\u6590\u6d4e\u590f\u4ee4\u65f6", "FJST"}},
            {"Pacific/Funafuti", new String[] {"\u5410\u9c81\u74e6\u65f6\u95f4", "TVT",
                                               "\u5410\u9c81\u74e6\u590f\u4ee4\u65f6", "TVST"}},
            {"Pacific/Galapagos", new String[] {"\u52a0\u62c9\u5df4\u54e5\u65f6\u95f4", "GALT",
                                                "\u52a0\u62c9\u5df4\u54e5\u590f\u4ee4\u65f6", "GALST"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line \u5c9b\u65f6\u95f4", "LINT",
                                                 "Line \u5c9b\u590f\u4ee4\u65f6", "LINST"}},
            {"Pacific/Kosrae", new String[] {"Kosrae \u65f6\u95f4", "KOST",
                                             "Kosrae \u590f\u4ee4\u65f6", "KOSST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"\u9a6c\u514b\u8428\u65af\u65f6\u95f4", "MART",
                                                "\u9a6c\u514b\u8428\u65af\u590f\u4ee4\u65f6", "MARST"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"\u8bfa\u9c81\u65f6\u95f4", "NRT",
                                            "\u8bfa\u9c81\u590f\u4ee4\u65f6", "NRST"}},
            {"Pacific/Niue", new String[] {"\u7ebd\u5a01\u5c9b\u65f6\u95f4", "NUT",
                                           "\u7ebd\u5a01\u5c9b\u590f\u4ee4\u65f6", "NUST"}},
            {"Pacific/Norfolk", new String[] {"\u8bfa\u798f\u514b\u65f6\u95f4", "NFT",
                                              "\u8bfa\u798f\u514b\u590f\u4ee4\u65f6", "NFST"}},
            {"Pacific/Noumea", new String[] {"\u65b0\u52a0\u52d2\u591a\u5c3c\u4e9a\u65f6\u95f4", "NCT",
                                             "\u65b0\u52a0\u52d2\u591a\u5c3c\u4e9a\u590f\u4ee4\u65f6", "NCST"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"\u5e1b\u7409\u65f6\u95f4", "PWT",
                                            "\u5e1b\u7409\u590f\u4ee4\u65f6", "PWST"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u65f6\u95f4", "PGT",
                                                   "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u590f\u4ee4\u65f6", "PGST"}},
            {"Pacific/Rarotonga", new String[] {"\u5e93\u514b\u7fa4\u5c9b\u65f6\u95f4", "CKT",
                                                "\u5e93\u514b\u7fa4\u5c9b\u590f\u4ee4\u65f6", "CKHST"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"\u5927\u6eaa\u5730\u5c9b\u65f6\u95f4", "TAHT",
                                             "\u5927\u6eaa\u5730\u5c9b\u590f\u4ee4\u65f6", "TAHST"}},
            {"Pacific/Tarawa", new String[] {"\u5409\u4f2f\u7279\u7fa4\u5c9b\u65f6\u95f4", "GILT",
                                             "\u5409\u4f2f\u7279\u7fa4\u5c9b\u590f\u4ee4\u65f6", "GILST"}},
            {"Pacific/Tongatapu", new String[] {"\u4e1c\u52a0\u65f6\u95f4", "TOT",
                                                "\u4e1c\u52a0\u590f\u4ee4\u65f6", "TOST"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"\u5a01\u514b\u65f6\u95f4", "WAKT",
                                           "\u5a01\u514b\u590f\u4ee4\u65f6", "WAKST"}},
            {"Pacific/Wallis", new String[] {"\u74e6\u5229\u65af\u53ca\u798f\u675c\u7eb3\u7fa4\u5c9b\u65f6\u95f4", "WFT",
                                             "\u74e6\u5229\u65af\u53ca\u798f\u675c\u7eb3\u7fa4\u5c9b\u590f\u4ee4\u65f6", "WFST"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HAST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
