/*
 * Copyright 2006-2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 6402062 6487891
 * @summary Tests TitledBorderUIResource encoding
 * @author Sergey Malenkov
 */

import java.awt.Color;
import java.awt.Font;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.BorderUIResource.TitledBorderUIResource;

public final class javax_swing_plaf_BorderUIResource_TitledBorderUIResource extends AbstractTest<TitledBorderUIResource> {
    public static void main(String[] args) {
        new javax_swing_plaf_BorderUIResource_TitledBorderUIResource().test(true);
    }

    protected TitledBorderUIResource getObject() {
        return new TitledBorderUIResource(
                new EmptyBorder(1, 2, 3, 4),
                "TITLE",
                TitledBorder.CENTER,
                TitledBorder.ABOVE_TOP,
                new Font("Serif", Font.ITALIC, 12),
                Color.RED);
    }

    protected TitledBorderUIResource getAnotherObject() {
        return null; // TODO: could not update property
        // return new TitledBorderUIResource("");
    }
}
