/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.DocumentLinkEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class BDocumentViewer
extends Widget {
    public BDocumentViewer() {
        this.component = this.createComponent();
        JEditorPane ep = (JEditorPane)this.component;
        ep.setEditable(false);
        ep.addPropertyChangeListener("page", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if (BDocumentViewer.this.component.isDisplayable()) {
                    BDocumentViewer.this.updateScrollPane();
                }
                BDocumentViewer.this.dispatchEvent(new ValueChangedEvent(BDocumentViewer.this));
            }
        });
        ep.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                if (BDocumentViewer.this.component.isDisplayable()) {
                    BDocumentViewer.this.updateScrollPane();
                }
            }
        });
        ep.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BDocumentViewer.this.dispatchEvent(new DocumentLinkEvent(BDocumentViewer.this, e));
                }
            }
        });
    }

    public BDocumentViewer(URL document) throws IOException {
        this();
        this.setDocument(document);
    }

    protected JEditorPane createComponent() {
        return new JEditorPane();
    }

    public URL getDocument() {
        return ((JEditorPane)this.component).getPage();
    }

    public void setDocument(URL document) throws IOException {
        ((JEditorPane)this.component).setPage(document);
    }

    public void setDocument(String text, String type) {
        JEditorPane ep = (JEditorPane)this.component;
        ep.setContentType(type);
        ep.setText(text);
    }

    public String getContentType() {
        return ((JEditorPane)this.component).getContentType();
    }

    public void processLinkEvent(DocumentLinkEvent event) throws IOException {
        if (event.getEvent() instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent ev = (HTMLFrameHyperlinkEvent)event.getEvent();
            ((HTMLDocument)((JEditorPane)this.component).getDocument()).processHTMLFrameHyperlinkEvent(ev);
        } else {
            this.setDocument(event.getURL());
        }
    }

    protected void updateScrollPane() {
        this.invalidateSize();
        if (this.getParent() instanceof BScrollPane) {
            this.getParent().layoutChildren();
        }
    }
}

