/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ValueChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;

public class BScrollBar
extends Widget {
    private DefaultBoundedRangeModel model;
    private int suppressEvents;
    public static final Orientation HORIZONTAL = new Orientation(0);
    public static final Orientation VERTICAL = new Orientation(1);

    public BScrollBar() {
        this(0, 10, 0, 100, VERTICAL);
    }

    public BScrollBar(int value, int extent, int minimum, int maximum, Orientation orientation) {
        this.component = this.createComponent(orientation);
        this.model = new DefaultBoundedRangeModel(value, extent, minimum, maximum);
        ((JScrollBar)this.component).setModel(this.model);
    }

    protected JScrollBar createComponent(Orientation orientation) {
        return new BScrollBarComponent(orientation);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int value) {
        this.model.setMinimum(value);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int value) {
        this.model.setMaximum(value);
    }

    public int getValue() {
        return this.model.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        try {
            ++this.suppressEvents;
            this.model.setValue(value);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public int getExtent() {
        return this.model.getExtent();
    }

    public void setExtent(int value) {
        this.model.setExtent(value);
    }

    public Orientation getOrientation() {
        int orient = ((JScrollBar)this.component).getOrientation();
        return orient == BScrollBar.HORIZONTAL.value ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orientation) {
        ((JScrollBar)this.component).setOrientation(orientation.value);
        this.invalidateSize();
    }

    public int getUnitIncrement() {
        return ((JScrollBar)this.component).getUnitIncrement();
    }

    protected int getUnitIncrement(int direction) {
        return this.getUnitIncrement();
    }

    public void setUnitIncrement(int increment) {
        ((JScrollBar)this.component).setUnitIncrement(increment);
    }

    public int getBlockIncrement() {
        return ((JScrollBar)this.component).getBlockIncrement();
    }

    protected int getBlockIncrement(int direction) {
        return this.getBlockIncrement();
    }

    public void setBlockIncrement(int increment) {
        ((JScrollBar)this.component).setBlockIncrement(increment);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BScrollBar.class));
    }

    public static class Orientation {
        protected int value;

        private Orientation(int value) {
            this.value = value;
        }
    }

    private class BScrollBarComponent
    extends JScrollBar
    implements AdjustmentListener {
        public BScrollBarComponent(Orientation orientation) {
            super(orientation.value);
            this.addAdjustmentListener(this);
        }

        public void adjustmentValueChanged(AdjustmentEvent ev) {
            if (BScrollBar.this.suppressEvents == 0) {
                BScrollBar.this.dispatchEvent(new ValueChangedEvent(BScrollBar.this, ((JScrollBar)BScrollBar.this.component).getValueIsAdjusting()));
            }
        }

        public int getUnitIncrement(int direction) {
            return BScrollBar.this.getUnitIncrement(direction);
        }

        public int getBlockIncrement(int direction) {
            return BScrollBar.this.getBlockIncrement(direction);
        }
    }
}

