/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.RepaintEvent;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BScrollBar;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BScrollPane
extends WidgetContainer {
    private ContentViewport contentPort;
    private JViewport rowHeaderPort;
    private JViewport colHeaderPort;
    private Widget content;
    private Widget rowHeader;
    private Widget colHeader;
    private BScrollBar hscroll;
    private BScrollBar vscroll;
    private ScrollbarPolicy hPolicy;
    private ScrollbarPolicy vPolicy;
    private Dimension preferredViewSize;
    private Dimension prefSize;
    private Dimension minSize;
    private boolean forceWidth;
    private boolean forceHeight;
    public static final ScrollbarPolicy SCROLLBAR_NEVER = new ScrollbarPolicy();
    public static final ScrollbarPolicy SCROLLBAR_AS_NEEDED = new ScrollbarPolicy();
    public static final ScrollbarPolicy SCROLLBAR_ALWAYS = new ScrollbarPolicy();
    private static final boolean IS_MACINTOSH;

    public BScrollPane() {
        this(SCROLLBAR_AS_NEEDED, SCROLLBAR_AS_NEEDED);
    }

    public BScrollPane(Widget contentWidget) {
        this(SCROLLBAR_AS_NEEDED, SCROLLBAR_AS_NEEDED);
        this.setContent(contentWidget);
    }

    public BScrollPane(ScrollbarPolicy horizontalPolicy, ScrollbarPolicy verticalPolicy) {
        JScrollPane panel = this.createComponent();
        this.component = panel;
        this.hPolicy = horizontalPolicy;
        this.vPolicy = verticalPolicy;
        ChangeListener scrollListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Point pos = BScrollPane.this.contentPort.getViewPosition();
                if (BScrollPane.this.hPolicy != SCROLLBAR_NEVER) {
                    pos.x = BScrollPane.this.hscroll.getValue();
                }
                if (BScrollPane.this.vPolicy != SCROLLBAR_NEVER) {
                    pos.y = BScrollPane.this.vscroll.getValue();
                }
                BScrollPane.this.contentPort.setViewPositionInternal(pos);
                BScrollPane.this.rowHeaderPort.setViewPosition(new Point(0, pos.y));
                BScrollPane.this.colHeaderPort.setViewPosition(new Point(pos.x, 0));
            }
        };
        MouseWheelListener wheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent ev) {
                int direction;
                BScrollBar bar = null;
                if (ev.getSource() == BScrollPane.this.vscroll.getComponent()) {
                    bar = BScrollPane.this.vscroll;
                } else if (ev.getSource() == BScrollPane.this.hscroll.getComponent()) {
                    bar = BScrollPane.this.hscroll;
                } else if (BScrollPane.this.vscroll.isVisible() && BScrollPane.this.vscroll.isEnabled() && BScrollPane.this.vscroll.getExtent() < BScrollPane.this.vscroll.getMaximum()) {
                    bar = BScrollPane.this.vscroll;
                } else if (BScrollPane.this.hscroll.isVisible() && BScrollPane.this.hscroll.isEnabled() && BScrollPane.this.hscroll.getExtent() < BScrollPane.this.hscroll.getMaximum()) {
                    bar = BScrollPane.this.hscroll;
                } else {
                    return;
                }
                int n = direction = ev.getWheelRotation() > 0 ? 1 : -1;
                if (ev.getScrollType() == 1) {
                    bar.setValue(bar.getValue() + bar.getBlockIncrement(direction) * ev.getWheelRotation());
                } else {
                    bar.setValue(bar.getValue() + bar.getUnitIncrement(direction) * ev.getScrollAmount() * direction);
                }
            }
        };
        this.vscroll = new ScrollPaneScrollBar(0, 1, 0, 100, BScrollBar.VERTICAL);
        panel.add(this.vscroll.component);
        this.setAsParent(this.vscroll);
        ((JScrollBar)this.vscroll.component).getModel().addChangeListener(scrollListener);
        this.vscroll.component.addMouseWheelListener(wheelListener);
        this.hscroll = new ScrollPaneScrollBar(0, 1, 0, 100, BScrollBar.HORIZONTAL);
        panel.add(this.hscroll.component);
        this.setAsParent(this.hscroll);
        ((JScrollBar)this.hscroll.component).getModel().addChangeListener(scrollListener);
        this.hscroll.component.addMouseWheelListener(wheelListener);
        this.contentPort = new ContentViewport();
        panel.setViewport(this.contentPort);
        this.rowHeaderPort = new JViewport();
        panel.setRowHeader(this.rowHeaderPort);
        this.colHeaderPort = new JViewport();
        panel.setColumnHeader(this.colHeaderPort);
        this.rowHeaderPort.setLayout(null);
        this.colHeaderPort.setLayout(null);
        this.rowHeaderPort.setOpaque(false);
        this.colHeaderPort.setOpaque(false);
        this.forceWidth = this.hPolicy == SCROLLBAR_NEVER;
        this.forceHeight = this.vPolicy == SCROLLBAR_NEVER;
        this.contentPort.addMouseWheelListener(wheelListener);
    }

    public BScrollPane(Widget contentWidget, ScrollbarPolicy horizontalPolicy, ScrollbarPolicy verticalPolicy) {
        this(horizontalPolicy, verticalPolicy);
        this.setContent(contentWidget);
    }

    protected JScrollPane createComponent() {
        return new ScrollPaneComponent();
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (this.content != null) {
            this.removeAsParent(this.content);
        }
        this.content = widget;
        if (this.content == null) {
            this.contentPort.setView(null);
        } else {
            this.setAsParent(this.content);
            this.contentPort.setView(this.content.getComponent());
        }
        this.invalidateSize();
    }

    public Widget getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(Widget widget) {
        if (this.rowHeader != null) {
            this.removeAsParent(this.rowHeader);
        }
        this.rowHeader = widget;
        if (this.rowHeader != null) {
            this.setAsParent(this.rowHeader);
        }
        this.rowHeaderPort.setView(this.rowHeader == null ? null : this.rowHeader.getComponent());
        this.invalidateSize();
    }

    public Widget getColHeader() {
        return this.colHeader;
    }

    public void setColHeader(Widget widget) {
        if (this.colHeader != null) {
            this.removeAsParent(this.colHeader);
        }
        this.colHeader = widget;
        if (this.colHeader != null) {
            this.setAsParent(this.colHeader);
        }
        this.colHeaderPort.setView(this.colHeader == null ? null : this.colHeader.getComponent());
        this.invalidateSize();
    }

    public BScrollBar getHorizontalScrollBar() {
        return this.hscroll;
    }

    public BScrollBar getVerticalScrollBar() {
        return this.vscroll;
    }

    public ScrollbarPolicy getHorizontalScrollbarPolicy() {
        return this.hPolicy;
    }

    public void setHorizontalScrollbarPolicy(ScrollbarPolicy policy) {
        this.hPolicy = policy;
        this.invalidateSize();
        this.layoutChildren();
    }

    public ScrollbarPolicy getVerticalScrollbarPolicy() {
        return this.vPolicy;
    }

    public void setVerticalScrollbarPolicy(ScrollbarPolicy policy) {
        this.vPolicy = policy;
        this.invalidateSize();
        this.layoutChildren();
    }

    public Dimension getPreferredViewSize() {
        return this.preferredViewSize;
    }

    public void setPreferredViewSize(Dimension size) {
        this.preferredViewSize = size;
        this.invalidateSize();
    }

    public Dimension getViewSize() {
        return this.contentPort.getSize();
    }

    public boolean getForceWidth() {
        return this.forceWidth;
    }

    public void setForceWidth(boolean force) {
        this.forceWidth = force;
    }

    public boolean getForceHeight() {
        return this.forceHeight;
    }

    public void setForceHeight(boolean force) {
        this.forceHeight = force;
    }

    public int getChildCount() {
        int count = 2;
        if (this.content != null) {
            ++count;
        }
        if (this.rowHeader != null) {
            ++count;
        }
        if (this.colHeader != null) {
            ++count;
        }
        return count;
    }

    public Collection getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(5);
        if (this.content != null) {
            ls.add(this.content);
        }
        if (this.rowHeader != null) {
            ls.add(this.rowHeader);
        }
        if (this.colHeader != null) {
            ls.add(this.colHeader);
        }
        ls.add(this.hscroll);
        ls.add(this.vscroll);
        return ls;
    }

    public void remove(Widget widget) {
        if (this.content == widget) {
            this.setContent(null);
        }
        if (this.rowHeader == widget) {
            this.setRowHeader(null);
        }
        if (this.colHeader == widget) {
            this.setColHeader(null);
        }
        this.invalidateSize();
    }

    public void removeAll() {
        this.setContent(null);
        this.setRowHeader(null);
        this.setColHeader(null);
    }

    public void layoutChildren() {
        Dimension size;
        boolean hasVScroll;
        int topMargin = 0;
        int leftMargin = 0;
        int bottomMargin = 0;
        int rightMargin = 0;
        Dimension colHeaderSize = this.colHeader == null ? null : this.colHeader.getPreferredSize();
        Dimension rowHeaderSize = this.rowHeader == null ? null : this.rowHeader.getPreferredSize();
        Dimension hScrollSize = this.hscroll.getPreferredSize();
        Dimension vScrollSize = this.vscroll.getPreferredSize();
        Dimension contentSize = this.content == null ? new Dimension() : this.content.getPreferredSize();
        Rectangle bounds = this.getBounds();
        if (colHeaderSize != null) {
            topMargin = colHeaderSize.height;
        }
        if (rowHeaderSize != null) {
            leftMargin = rowHeaderSize.width;
        }
        boolean hasHScroll = this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && bounds.width - leftMargin - vScrollSize.width < contentSize.width;
        boolean bl = hasVScroll = this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && bounds.height - topMargin - hScrollSize.height < contentSize.height;
        if (hasHScroll) {
            bottomMargin = hScrollSize.height;
        }
        if (hasVScroll) {
            rightMargin = vScrollSize.width;
        }
        if (this.hPolicy == SCROLLBAR_AS_NEEDED && this.vPolicy == SCROLLBAR_AS_NEEDED && bounds.width - leftMargin >= contentSize.width && bounds.height - topMargin >= contentSize.height) {
            hasHScroll = false;
            hasVScroll = false;
            bottomMargin = 0;
            rightMargin = 0;
        }
        Rectangle viewBounds = new Rectangle(leftMargin, topMargin, bounds.width - leftMargin - rightMargin, bounds.height - topMargin - bottomMargin);
        Dimension forceSize = new Dimension(viewBounds.width, viewBounds.height);
        if (this.content != null) {
            Dimension minSize = this.content.getMinimumSize();
            Dimension maxSize = this.content.getMaximumSize();
            forceSize.width = Math.max(minSize.width, Math.min(maxSize.width, forceSize.width));
            forceSize.height = Math.max(minSize.height, Math.min(maxSize.height, forceSize.height));
        }
        this.colHeaderPort.setBounds(new Rectangle(leftMargin, 0, viewBounds.width, topMargin));
        if (this.colHeader != null) {
            size = new Dimension(colHeaderSize);
            if (this.forceWidth) {
                size.width = forceSize.width;
            }
            this.colHeader.component.setSize(size);
        }
        this.rowHeaderPort.setBounds(new Rectangle(0, topMargin, leftMargin, viewBounds.height));
        if (this.rowHeader != null) {
            size = new Dimension(rowHeaderSize);
            if (this.forceHeight) {
                size.height = forceSize.height;
            }
            this.rowHeader.component.setSize(size);
        }
        this.contentPort.setBounds(viewBounds);
        if (this.content != null) {
            size = new Dimension(contentSize);
            if (this.forceWidth) {
                size.width = forceSize.width;
            }
            if (this.forceHeight) {
                size.height = forceSize.height;
            }
            this.content.component.setSize(size);
        }
        int hScrollLength = viewBounds.width;
        int vScrollLength = viewBounds.height;
        if (IS_MACINTOSH && hasHScroll != hasVScroll) {
            WidgetContainer parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof WindowWidget); parent = parent.getParent()) {
            }
            if (parent instanceof BFrame && ((BFrame)parent).isResizable() || parent instanceof BDialog && ((BDialog)parent).isResizable()) {
                Rectangle parentBounds = parent.getBounds();
                Point offset = SwingUtilities.convertPoint(this.getComponent(), 0, 0, parent.getComponent());
                if (bounds.x + bounds.width + offset.x == parentBounds.width && bounds.y + bounds.height + offset.y == parentBounds.height) {
                    if (!hasHScroll) {
                        vScrollLength -= hScrollSize.height;
                    }
                    if (!hasVScroll) {
                        hScrollLength -= vScrollSize.width;
                    }
                }
            }
        }
        this.hscroll.component.setBounds(new Rectangle(leftMargin, viewBounds.y + viewBounds.height, hScrollLength, bottomMargin));
        if (this.content == null) {
            this.hscroll.setEnabled(false);
        } else {
            this.hscroll.setEnabled(true);
            int width = this.content.component.getWidth();
            this.hscroll.setMaximum(width);
            if (this.hscroll.getValue() + viewBounds.width > width) {
                this.hscroll.setValue(width - viewBounds.width);
            }
        }
        this.hscroll.setExtent(viewBounds.width);
        this.vscroll.component.setBounds(new Rectangle(viewBounds.x + viewBounds.width, topMargin, rightMargin, vScrollLength));
        if (this.content == null) {
            this.vscroll.setEnabled(false);
        } else {
            this.vscroll.setEnabled(true);
            int height = this.content.component.getHeight();
            this.vscroll.setMaximum(height);
            if (this.vscroll.getValue() + viewBounds.height > height) {
                this.vscroll.setValue(height - viewBounds.height);
            }
        }
        this.vscroll.setExtent(viewBounds.height);
        if (this.content instanceof WidgetContainer) {
            ((WidgetContainer)this.content).layoutChildren();
        }
        if (this.colHeader instanceof WidgetContainer) {
            ((WidgetContainer)this.colHeader).layoutChildren();
        }
        if (this.rowHeader instanceof WidgetContainer) {
            ((WidgetContainer)this.rowHeader).layoutChildren();
        }
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            Dimension contentDim;
            this.minSize = new Dimension();
            if (this.colHeader != null) {
                this.minSize.height += this.colHeader.getMinimumSize().height;
            }
            if (this.rowHeader != null) {
                this.minSize.width += this.rowHeader.getMinimumSize().width;
            }
            Dimension dimension = contentDim = this.content == null ? new Dimension() : this.content.getMinimumSize();
            if (this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && contentDim.width > 0) {
                Dimension hScrollDim = this.hscroll.getMinimumSize();
                this.minSize.width += hScrollDim.width;
                this.minSize.height += hScrollDim.height;
            }
            if (this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && contentDim.height > 0) {
                Dimension vScrollDim = this.vscroll.getMinimumSize();
                this.minSize.height += vScrollDim.height;
                this.minSize.width += vScrollDim.width;
            }
        }
        return new Dimension(this.minSize);
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension contentPrefSize;
            Dimension dimension = contentPrefSize = this.content == null ? new Dimension() : this.content.getPreferredSize();
            if (this.content != null && this.content.component instanceof Scrollable) {
                Dimension prefScrollSize = ((Scrollable)((Object)this.content.component)).getPreferredScrollableViewportSize();
                contentPrefSize = new Dimension(Math.min(contentPrefSize.width, prefScrollSize.width), Math.min(contentPrefSize.height, prefScrollSize.height));
            }
            this.prefSize = this.preferredViewSize != null ? new Dimension(this.preferredViewSize) : new Dimension(contentPrefSize);
            if (this.colHeader != null) {
                Dimension colHeaderDim = this.colHeader.getPreferredSize();
                if (colHeaderDim.width > this.prefSize.width) {
                    this.prefSize.width = colHeaderDim.width;
                }
                this.prefSize.height += colHeaderDim.height;
            }
            if (this.rowHeader != null) {
                Dimension rowHeaderDim = this.rowHeader.getPreferredSize();
                if (rowHeaderDim.height > this.prefSize.height) {
                    this.prefSize.height = rowHeaderDim.height;
                }
                this.prefSize.width += rowHeaderDim.width;
            }
            if (this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && this.prefSize.width < contentPrefSize.width) {
                Dimension hScrollDim = this.hscroll.getPreferredSize();
                if (hScrollDim.width > this.prefSize.width) {
                    this.prefSize.width = hScrollDim.width;
                }
                this.prefSize.height += hScrollDim.height;
            }
            if (this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && this.prefSize.height < contentPrefSize.height) {
                Dimension vScrollDim = this.vscroll.getPreferredSize();
                if (vScrollDim.height > this.prefSize.height) {
                    this.prefSize.height = vScrollDim.height;
                }
                this.prefSize.width += vScrollDim.width;
            }
        }
        return new Dimension(this.prefSize);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.contentPort.setBackground(background);
        this.rowHeaderPort.setBackground(background);
        this.colHeaderPort.setBackground(background);
    }

    protected void invalidateSize() {
        this.minSize = null;
        this.prefSize = null;
        super.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ScrollbarPolicy.class, new StaticFieldDelegate(BScrollPane.class));
        String os = System.getProperty("os.name", "").toLowerCase();
        IS_MACINTOSH = os.startsWith("mac os x");
    }

    public static class ScrollbarPolicy {
        private ScrollbarPolicy() {
        }
    }

    private class ContentViewport
    extends JViewport {
        public void setViewPosition(Point p) {
            BScrollPane.this.hscroll.setValue(p.x);
            BScrollPane.this.vscroll.setValue(p.y);
        }

        public void setViewPositionInternal(Point p) {
            super.setViewPosition(p);
        }

        public void doLayout() {
            BScrollPane.this.layoutChildren();
        }
    }

    private class ScrollPaneScrollBar
    extends BScrollBar {
        public ScrollPaneScrollBar(int value, int extent, int minimum, int maximum, BScrollBar.Orientation orientation) {
            super(value, extent, minimum, maximum, orientation);
        }

        public int getUnitIncrement(int direction) {
            if (BScrollPane.this.content != null && ((BScrollPane)BScrollPane.this).content.component instanceof Scrollable) {
                return ((Scrollable)((Object)((BScrollPane)BScrollPane.this).content.component)).getScrollableUnitIncrement(BScrollPane.this.contentPort.getViewRect(), this.getOrientation().value, direction);
            }
            return super.getUnitIncrement(direction);
        }

        public int getBlockIncrement(int direction) {
            if (BScrollPane.this.content != null && ((BScrollPane)BScrollPane.this).content.component instanceof Scrollable) {
                return ((Scrollable)((Object)((BScrollPane)BScrollPane.this).content.component)).getScrollableBlockIncrement(BScrollPane.this.contentPort.getViewRect(), this.getOrientation().value, direction);
            }
            return super.getBlockIncrement(direction);
        }
    }

    private class ScrollPaneComponent
    extends JScrollPane {
        private ScrollPaneComponent() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            if (BScrollPane.this.isOpaque()) {
                Dimension size = this.getSize();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this.getForeground());
            }
            BScrollPane.this.dispatchEvent(new RepaintEvent(BScrollPane.this, (Graphics2D)g));
        }

        public boolean isOpaque() {
            return BScrollPane.this.isOpaque();
        }
    }
}

