/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class DriverWrapper
extends Driver {
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    private static final String POSTGIS_PROTOCOL = "jdbc:postgresql_postGIS:";
    public static final String REVISION = "$Revision: 1.8 $";
    public final TypesAdder typesAdder = DriverWrapper.getTypesAdder(this);
    static /* synthetic */ Class class$org$postgis$PGgeometry;
    static /* synthetic */ Class class$org$postgis$PGbox3d;
    static /* synthetic */ Class class$org$postgis$PGbox2d;

    public DriverWrapper() throws SQLException {
        if (super.getMajorVersion() > 8 || super.getMinorVersion() > 1) {
            Driver.debug((String)("DriverWrapper loaded TypesAdder: " + this.typesAdder.getClass().getName()));
        }
    }

    protected static TypesAdder getTypesAdder(Driver driver) throws SQLException {
        if (driver.getMajorVersion() == 7) {
            if (driver.getMinorVersion() >= 3) {
                return DriverWrapper.loadTypesAdder(74);
            }
            return DriverWrapper.loadTypesAdder(72);
        }
        return DriverWrapper.loadTypesAdder(80);
    }

    private static TypesAdder loadTypesAdder(int n) throws SQLException {
        try {
            Class<?> clazz = Class.forName("org.postgis.DriverWrapper$TypesAdder" + n);
            return (TypesAdder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create TypesAdder instance! " + exception.getMessage());
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        string = DriverWrapper.mangleURL(string);
        Connection connection = super.connect(string, properties);
        this.typesAdder.addGT(connection);
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            string = DriverWrapper.mangleURL(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return super.acceptsURL(string);
    }

    public static String getVersion() {
        return "PostGisWrapper $Revision: 1.8 $, wrapping " + Driver.getVersion();
    }

    public static void addGISTypes(PGConnection pGConnection) {
        pGConnection.addDataType("geometry", "org.postgis.PGgeometry");
        pGConnection.addDataType("box3d", "org.postgis.PGbox3d");
        pGConnection.addDataType("box2d", "org.postgis.PGbox2d");
    }

    public static void addGISTypes80(PGConnection pGConnection) throws SQLException {
        pGConnection.addDataType("geometry", class$org$postgis$PGgeometry == null ? (class$org$postgis$PGgeometry = DriverWrapper.class$("org.postgis.PGgeometry")) : class$org$postgis$PGgeometry);
        pGConnection.addDataType("box3d", class$org$postgis$PGbox3d == null ? (class$org$postgis$PGbox3d = DriverWrapper.class$("org.postgis.PGbox3d")) : class$org$postgis$PGbox3d);
        pGConnection.addDataType("box2d", class$org$postgis$PGbox2d == null ? (class$org$postgis$PGbox2d = DriverWrapper.class$("org.postgis.PGbox2d")) : class$org$postgis$PGbox2d);
    }

    public static void addGISTypes72(org.postgresql.Connection connection) {
        connection.addDataType("geometry", "org.postgis.PGgeometry");
        connection.addDataType("box3d", "org.postgis.PGbox3d");
        connection.addDataType("box2d", "org.postgis.PGbox2d");
    }

    public static String mangleURL(String string) throws SQLException {
        if (string.startsWith(POSTGIS_PROTOCOL)) {
            return POSTGRES_PROTOCOL + string.substring(POSTGIS_PROTOCOL.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverWrapper()));
        }
        catch (SQLException sQLException) {
            Driver.info((String)"Error registering PostGIS Wrapper Driver", (Exception)sQLException);
        }
    }

    protected static class TypesAdder80
    extends TypesAdder {
        protected TypesAdder80() {
        }

        public void addGT(Connection connection) throws SQLException {
            DriverWrapper.addGISTypes80((PGConnection)connection);
        }
    }

    protected static class TypesAdder72
    extends TypesAdder {
        protected TypesAdder72() {
        }

        public void addGT(Connection connection) {
            DriverWrapper.addGISTypes72((org.postgresql.Connection)connection);
        }
    }

    protected static final class TypesAdder74
    extends TypesAdder {
        protected TypesAdder74() {
        }

        public void addGT(Connection connection) {
            DriverWrapper.addGISTypes((PGConnection)connection);
        }
    }

    protected static abstract class TypesAdder {
        protected TypesAdder() {
        }

        public abstract void addGT(Connection var1) throws SQLException;
    }
}

