/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;

public abstract class AbstractLoadSaveDatasetPlugIn
extends ThreadedBasePlugIn {
    private WorkbenchContext context;
    private Collection dataSourceQueries;

    protected String getLastFormatKey() {
        return this.getClass().getName() + " - LAST FORMAT";
    }

    protected String getLastDirectoryKey() {
        return this.getClass().getName() + " - LAST DIRECTORY";
    }

    public void initialize(final PlugInContext context) throws Exception {
        this.context = context.getWorkbenchContext();
        context.getWorkbenchFrame().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                String format = (String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(AbstractLoadSaveDatasetPlugIn.this.getLastFormatKey());
                if (format != null) {
                    AbstractLoadSaveDatasetPlugIn.this.setSelectedFormat(format);
                }
            }
        });
    }

    protected abstract void setSelectedFormat(String var1);

    protected abstract String getSelectedFormat();

    protected WorkbenchContext getContext() {
        return this.context;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dataSourceQueries = this.showDialog(context.getWorkbenchContext());
        if (this.dataSourceQueries != null) {
            PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put(this.getLastFormatKey(), (Object)this.getSelectedFormat());
        }
        return this.dataSourceQueries != null;
    }

    protected abstract Collection showDialog(WorkbenchContext var1);

    protected Collection getDataSourceQueries() {
        return this.dataSourceQueries;
    }
}

