/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.coordsys.CoordinateSystemSupport;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.util.Collection;
import javax.swing.JFileChooser;

public class LoadFileDataSourceQueryChooser
extends FileDataSourceQueryChooser {
    public static final String FILE_CHOOSER_DIRECTORY_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    public static final String FILE_CHOOSER_COORDINATE_SYSTEM_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER COORDINATE SYSTEM";
    public static final String FILE_CHOOSER_PANEL_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER PANEL";
    public static final String FILE_CHOOSER_KEY = LoadFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER";
    private WorkbenchContext context;

    public LoadFileDataSourceQueryChooser(Class dataSourceClass, String description, String[] extensions, WorkbenchContext context) {
        super(dataSourceClass, description, extensions);
        this.context = context;
    }

    private Blackboard blackboard() {
        return this.context.getBlackboard();
    }

    protected FileDataSourceQueryChooser.FileChooserPanel getFileChooserPanel() {
        if (this.blackboard().get(FILE_CHOOSER_PANEL_KEY) == null) {
            JFileChooser fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setControlButtonsAreShown(false);
            this.blackboard().put(FILE_CHOOSER_KEY, (Object)fileChooser);
            this.blackboard().put(FILE_CHOOSER_PANEL_KEY, (Object)new FileDataSourceQueryChooser.FileChooserPanel(fileChooser, this.blackboard()));
            if (PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY)));
                ((FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY)).setSelectedCoordinateSystem((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_COORDINATE_SYSTEM_KEY));
            }
            if (CoordinateSystemSupport.isEnabled((Blackboard)this.blackboard())) {
                ((FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY)).setCoordinateSystemComboBoxVisible(true);
            }
        }
        return (FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY);
    }

    public Collection getDataSourceQueries() {
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_DIRECTORY_KEY, (Object)this.getFileChooserPanel().getChooser().getCurrentDirectory().toString());
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_COORDINATE_SYSTEM_KEY, (Object)this.getFileChooserPanel().getSelectedCoordinateSystem().getName());
        return super.getDataSourceQueries();
    }
}

