/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.driver;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLReader;
import com.vividsolutions.jump.workbench.driver.AbstractInputDriver;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.AbstractDriverPanel;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GMLFileDriverPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.io.File;

public class GMLFileInputDriver
extends AbstractInputDriver {
    private GMLFileDriverPanel panel;
    private GMLReader reader = new GMLReader();

    public void input(LayerManager layerManager, String categoryName) throws Exception {
        String internalName;
        File selectedFile = this.panel.getGMLFile();
        String layerName = GUIUtil.nameWithoutExtension(selectedFile);
        String fname = selectedFile.getAbsolutePath();
        DriverProperties dp = new DriverProperties();
        String extension_gml = fname.substring(fname.length() - 3);
        String extension_template = this.panel.getTemplateFile().getAbsolutePath().substring(this.panel.getTemplateFile().getAbsolutePath().length() - 3);
        if (extension_gml.equalsIgnoreCase("zip")) {
            dp.set("CompressedFile", fname);
            internalName = CompressedFile.getInternalZipFnameByExtension((String)".gml", (String)fname);
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension((String)".xml", (String)fname);
            }
            if (internalName == null) {
                throw new Exception("Couldnt find a .xml or .gml file inside the .zip file: " + fname);
            }
            dp.set("File", internalName);
        } else if (extension_gml.equalsIgnoreCase(".gz")) {
            dp.set("CompressedFile", fname);
            dp.set("File", fname);
        } else {
            dp.set("File", fname);
        }
        if (extension_template.equalsIgnoreCase("zip")) {
            dp.set("CompressedFileTemplate", this.panel.getTemplateFile().getAbsolutePath());
            internalName = CompressedFile.getInternalZipFnameByExtension((String)"_input.xml", (String)this.panel.getTemplateFile().getAbsolutePath());
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension((String)".input", (String)this.panel.getTemplateFile().getAbsolutePath());
            }
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension((String)".template", (String)this.panel.getTemplateFile().getAbsolutePath());
            }
            if (internalName == null) {
                throw new Exception("Couldnt find a _input.xml, .input, or .template file inside the .zip file: " + this.panel.getTemplateFile().getAbsolutePath());
            }
            dp.set("TemplateFile", internalName);
        } else if (extension_template.equalsIgnoreCase(".gz")) {
            dp.set("CompressedFileTemplate", this.panel.getTemplateFile().getAbsolutePath());
            dp.set("TemplateFile", this.panel.getTemplateFile().getAbsolutePath());
        } else {
            dp.set("TemplateFile", this.panel.getTemplateFile().getAbsolutePath());
        }
        FeatureCollection featureCollection = this.reader.read(dp);
        Layer layer = layerManager.addLayer(categoryName, layerName, featureCollection);
    }

    public String toString() {
        return "GML 2.0";
    }

    public void initialize(DriverManager driverManager, ErrorHandler errorHandler) {
        super.initialize(driverManager, errorHandler);
        this.panel = new GMLFileDriverPanel(errorHandler);
        this.panel.setGMLFileMustExist(true);
        this.panel.setTemplateFileDescription("JCS GML Input Template File");
        this.panel.addPossibleTemplateExtension(".jit");
        this.panel.addPossibleTemplateExtension("_input.xml");
        this.panel.addPossibleTemplateExtension(".gz");
        this.panel.addPossibleTemplateExtension(".zip");
    }

    public AbstractDriverPanel getPanel() {
        return this.panel;
    }
}

