/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFileOpenFailedException;
import com.ermapper.ecw.JNCSRenderer;
import com.ermapper.util.JNCSDatasetPoint;
import com.ermapper.util.JNCSWorldPoint;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ECWImage
implements ReferencedImage {
    private Envelope imageEnv = new Envelope();
    private JNCSRenderer ecwRenderer;
    private int[] bandlist;
    private boolean validSetView = false;
    private Envelope lastViewportEnv = new Envelope();
    int count = 0;

    public ECWImage(String location) throws JUMPException {
        this.init(location);
    }

    private void init(String location) throws JUMPException {
        try {
            this.ecwRenderer = new JNCSRenderer(location, false);
            double xm = this.ecwRenderer.originX;
            double yM = this.ecwRenderer.originY;
            double xM = this.ecwRenderer.originX + (double)this.ecwRenderer.width * this.ecwRenderer.cellIncrementX;
            double ym = this.ecwRenderer.originY + (double)this.ecwRenderer.height * this.ecwRenderer.cellIncrementY;
            this.imageEnv = new Envelope(xm, xM, ym, yM);
            this.bandlist = new int[this.ecwRenderer.numBands];
            for (int i = 0; i < this.ecwRenderer.numBands; ++i) {
                this.bandlist[i] = i;
            }
        }
        catch (JNCSFileOpenFailedException e) {
            throw new JUMPException(e.getMessage());
        }
        catch (JNCSException e) {
            throw new JUMPException(e.getMessage());
        }
    }

    public Envelope getEnvelope() {
        return this.imageEnv;
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws JUMPException {
        block7: {
            Envelope viewportEnv = viewport.getEnvelopeInModelCoordinates();
            if (!this.imageEnv.intersects(viewportEnv)) {
                return;
            }
            if (!viewportEnv.equals((Object)this.lastViewportEnv)) {
                this.validSetView = false;
                this.lastViewportEnv = viewportEnv;
            }
            try {
                int width = viewport.getPanel().getWidth();
                int height = viewport.getPanel().getHeight();
                double dWorldTLX = viewportEnv.getMinX();
                double dWorldTLY = viewportEnv.getMaxY();
                double dWorldBRX = viewportEnv.getMaxX();
                double dWorldBRY = viewportEnv.getMinY();
                if (this.validSetView) break block7;
                JNCSDatasetPoint firstCell = this.ecwRenderer.convertWorldToDataset(dWorldTLX - this.ecwRenderer.cellIncrementX / 2.0, dWorldTLY - this.ecwRenderer.cellIncrementY / 2.0);
                int firstColumn = Math.max(0, firstCell.x);
                int firstLine = Math.max(0, firstCell.y);
                JNCSWorldPoint tlCorner = this.ecwRenderer.convertDatasetToWorld(firstColumn, firstLine);
                JNCSDatasetPoint lastCell = this.ecwRenderer.convertWorldToDataset(dWorldBRX - this.ecwRenderer.cellIncrementX / 2.0, dWorldBRY - this.ecwRenderer.cellIncrementY / 2.0);
                int lastColumn = Math.min(this.ecwRenderer.width - 1, lastCell.x + 1);
                int lastLine = Math.min(this.ecwRenderer.height - 1, lastCell.y + 1);
                JNCSWorldPoint brCorner = this.ecwRenderer.convertDatasetToWorld(lastColumn + 1, lastLine + 1);
                Envelope finalEnvelope = new Envelope(tlCorner.x, brCorner.x, brCorner.y, tlCorner.y);
                int nbColumns = lastColumn - firstColumn + 1;
                int nbLines = lastLine - firstLine + 1;
                width = width <= nbColumns ? width : nbColumns;
                height = height <= nbLines ? height : nbLines;
                BufferedImage ecwImage = new BufferedImage(width, height, 1);
                int[] pRGBArray = new int[width];
                try {
                    this.ecwRenderer.setView(this.ecwRenderer.numBands, this.bandlist, firstColumn, firstLine, lastColumn, lastLine, width, height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (int line = 0; line < height; ++line) {
                    this.ecwRenderer.readLineRGBA(pRGBArray);
                    ecwImage.setRGB(0, line, width, 1, pRGBArray, 0, width);
                }
                Rectangle2D finalRect = viewport.toViewRectangle(finalEnvelope);
                g.drawImage(ecwImage, (int)finalRect.getMinX(), (int)finalRect.getMinY(), (int)finalRect.getMaxX(), (int)finalRect.getMaxY(), 0, 0, ecwImage.getWidth(), ecwImage.getHeight(), Color.WHITE, viewport.getPanel());
            }
            catch (Exception e) {
                this.validSetView = false;
                throw new JUMPException(e.getMessage());
            }
        }
    }

    public void close() {
        this.ecwRenderer.close(true);
    }

    public String getType() {
        return "ECW";
    }
}

