/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWImage;

public class ECWImageFactory
implements ReferencedImageFactory {
    public static final String TYPE_NAME = "ECW";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public ReferencedImage createImage(String location) throws JUMPException {
        return new ECWImage(location);
    }

    public String getDescription() {
        return "Enhanced Compressed Wavelet";
    }

    public String[] getExtensions() {
        return new String[]{"ecw"};
    }

    public boolean isEditableImage(String location) {
        return false;
    }

    public boolean isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass("com.ermapper.ecw.JNCSRenderer");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return c != null;
    }
}

