/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoTIFFRaster;
import com.vividsolutions.jump.workbench.imagery.geotiff.RasterPainter;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Graphics2D;

public class GeoTIFFImage
implements ReferencedImage {
    private GeoTIFFRaster gtr;
    private RasterPainter rasterPainter;

    public GeoTIFFImage(String location) throws JUMPException {
        this.init(location);
    }

    public Envelope getEnvelope() {
        return this.gtr.getEnvelope();
    }

    private void init(String location) throws JUMPException {
        try {
            this.gtr = new GeoTIFFRaster(location);
            this.rasterPainter = new RasterPainter(this.gtr);
        }
        catch (Exception ex) {
            this.gtr = null;
            throw new JUMPException(ex.getMessage());
        }
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws JUMPException {
        try {
            this.rasterPainter.paint(g, viewport);
        }
        catch (Exception ex) {
            throw new JUMPException(ex.getMessage());
        }
    }

    public String getType() {
        return "GeoTiff";
    }
}

