/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoReferencedRaster;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class RasterPainter {
    GeoReferencedRaster geoRaster;
    Envelope envModel_viewportCached;
    double scaleCached;
    RenderedOp imgScaled;
    RenderedOp imgWindow;
    RenderedOp imgRescaled;
    static final double DEFAULT_RESCALINGCONSTANT = 1.0;
    static final double DEFAULT_RESCALINGOFFSET = 0.0;
    double rescalingConstant = 1.0;
    double rescalingOffset = 0.0;
    boolean enabled = true;

    public RasterPainter(GeoReferencedRaster geoRaster) {
        this.geoRaster = geoRaster;
    }

    public void setRescalingConstant(double x) {
        this.rescalingConstant = x;
    }

    public void setRescalingOffset(double x) {
        this.rescalingOffset = x;
    }

    private RenderedOp rescale(RenderedOp image, double constant, double offset) {
        if (constant == 1.0 && offset == 0.0) {
            return image;
        }
        int bands = this.imgWindow.getNumBands();
        double[] constants = new double[bands];
        double[] offsets = new double[bands];
        for (int i = 0; i < bands; ++i) {
            constants[i] = constant;
            offsets[i] = offset;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(constants);
        pb.add(offsets);
        return JAI.create((String)"rescale", (ParameterBlock)pb, null);
    }

    private RenderedOp rescale(RenderedOp image) {
        return this.rescale(image, this.rescalingConstant, this.rescalingOffset);
    }

    private RenderedOp getWindow(Viewport viewport) throws Exception {
        Envelope envModel_viewport = viewport.getEnvelopeInModelCoordinates();
        if (this.envModel_viewportCached == null || !this.envModel_viewportCached.equals((Object)envModel_viewport)) {
            this.imgWindow = this.calculateWindow2(viewport, envModel_viewport);
        }
        return this.imgWindow;
    }

    private void scaleImage(double scale) throws Exception {
        double scaleX = scale * this.geoRaster.getDblModelUnitsPerRasterUnit_X();
        double scaleY = scale * this.geoRaster.getDblModelUnitsPerRasterUnit_Y();
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.geoRaster.getImage());
        pb.add((float)scaleX);
        pb.add((float)scaleY);
        pb.add(0.0f);
        pb.add(0.0f);
        this.imgScaled = JAI.create((String)"scale", (ParameterBlock)pb, null);
    }

    private RenderedOp calculateWindow2(Viewport viewport, Envelope envModel_viewport) throws Exception {
        double scale = viewport.getScale();
        if (scale != this.scaleCached) {
            this.scaleImage(scale);
            this.scaleCached = scale;
        }
        double ratio_cropX = (envModel_viewport.getMinX() - this.geoRaster.getEnvelope().getMinX()) / this.geoRaster.getEnvelope().getWidth();
        double ratio_cropY = (this.geoRaster.getEnvelope().getMaxY() - envModel_viewport.getMaxY()) / this.geoRaster.getEnvelope().getHeight();
        double ratio_cropW = envModel_viewport.getWidth() / this.geoRaster.getEnvelope().getWidth();
        double ratio_cropH = envModel_viewport.getHeight() / this.geoRaster.getEnvelope().getHeight();
        float raster_cropX = (int)(ratio_cropX * (double)this.imgScaled.getWidth());
        float raster_cropY = (int)(ratio_cropY * (double)this.imgScaled.getHeight());
        float raster_cropW = (int)(ratio_cropW * (double)this.imgScaled.getWidth());
        float raster_cropH = (int)(ratio_cropH * (double)this.imgScaled.getHeight());
        float raster_offsetX = 0.0f;
        float raster_offsetY = 0.0f;
        if (raster_cropX < 0.0f) {
            raster_offsetX = -raster_cropX;
            raster_cropX = 0.0f;
        }
        if (raster_cropY < 0.0f) {
            raster_offsetY = -raster_cropY;
            raster_cropY = 0.0f;
        }
        raster_cropW = Math.min(raster_cropW, (float)(this.imgScaled.getWidth() - (int)raster_cropX));
        raster_cropH = Math.min(raster_cropH, (float)(this.imgScaled.getHeight() - (int)raster_cropY));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this.imgScaled);
        pb.add(raster_cropX);
        pb.add(raster_cropY);
        pb.add(raster_cropW);
        pb.add(raster_cropH);
        this.imgWindow = JAI.create((String)"crop", (ParameterBlock)pb, null);
        pb = new ParameterBlock();
        pb.addSource(this.imgWindow);
        pb.add(raster_offsetX - (float)this.imgWindow.getMinX());
        pb.add(raster_offsetY - (float)this.imgWindow.getMinY());
        this.imgWindow = JAI.create((String)"translate", (ParameterBlock)pb, null);
        return this.imgWindow;
    }

    public void paint(Graphics2D g, Viewport viewport) throws Exception {
        RenderedOp imgWindowed = this.getWindow(viewport);
        if (imgWindowed == null) {
            return;
        }
        RenderedOp imgRescaled = this.rescale(imgWindowed);
        if (imgRescaled == null) {
            return;
        }
        g.setComposite(AlphaComposite.SrcOver);
        g.drawRenderedImage((RenderedImage)imgRescaled, new AffineTransform());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getRescalingConstant() {
        return this.rescalingConstant;
    }

    public double getRescalingOffset() {
        return this.rescalingOffset;
    }
}

