/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.graphic.GraphicImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class GraphicImageFactory
implements ReferencedImageFactory {
    public String getTypeName() {
        return "Picture";
    }

    public ReferencedImage createImage(String location) {
        WorldFile wf = this.findWF(location);
        return new GraphicImage(new File(location), wf);
    }

    private WorldFile findWF(String location) {
        int i;
        String name;
        String nm;
        File parent;
        File[] children;
        File f = new File(location);
        if (f != null && f.exists() && (children = (parent = f.getParentFile()).listFiles(new FilenameFilter(nm = (name = (i = (name = f.getName()).indexOf(".")) == -1 ? name : name.substring(0, i)), location){
            final /* synthetic */ String val$nm;
            final /* synthetic */ String val$location;
            {
                this.val$nm = string;
                this.val$location = string2;
            }

            public boolean accept(File dir, String name) {
                String suffix = name.substring(name.indexOf(".") + 1);
                if (suffix != null && (suffix.equalsIgnoreCase("jgw") || suffix.equalsIgnoreCase("tfw") || suffix.equalsIgnoreCase("gfw") || suffix.equalsIgnoreCase("bpw"))) {
                    return name.startsWith(this.val$nm);
                }
                return name != null && name.equalsIgnoreCase(this.val$location + "w");
            }
        })) != null) {
            for (int c = 0; c < children.length; ++c) {
                if (!children[c].exists() || children[c].isDirectory()) continue;
                try {
                    WorldFile wf = WorldFile.read(children[c]);
                    if (wf != null) {
                        return wf;
                    }
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String getDescription() {
        return this.getTypeName();
    }

    public String[] getExtensions() {
        return new String[]{"gif", "png", "jpg", "jpeg"};
    }

    public boolean isEditableImage(String location) {
        return true;
    }

    public boolean isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass("javax.media.jai.JAI");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return c != null;
    }
}

