/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.mrsid;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.mrsid.MrSIDImageFactory;
import com.vividsolutions.jump.workbench.imagery.mrsid.SIDInfo;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FileLoadDescriptor;

public class MrSIDReferencedImage
implements ReferencedImage {
    private SIDInfo sidInfo;
    private String sidFilename;

    public MrSIDReferencedImage(SIDInfo info, String sidFilename) {
        this.sidInfo = info;
        this.sidFilename = sidFilename;
    }

    public Envelope getEnvelope() {
        double xm = this.sidInfo.getUpperLeftX();
        double xM = this.sidInfo.getUpperLeftX() + (double)this.sidInfo.getPixelWidth() * this.sidInfo.getXRes();
        double yM = this.sidInfo.getUpperLeftY() + (double)this.sidInfo.getPixelHeight() * this.sidInfo.getYRes();
        double ym = this.sidInfo.getUpperLeftY();
        return new Envelope(xm, xM, ym, yM);
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws JUMPException {
        if (this.sidInfo == null) {
            viewport.getPanel().getContext().setStatusMessage("Could not get SID info for " + this.sidFilename);
        } else {
            int sidDRmin = 0;
            int sidDRmax = 255;
            int sidPixelWidth = this.sidInfo.getPixelWidth();
            int sidPixelHeight = this.sidInfo.getPixelHeight();
            double sid_xres = this.sidInfo.getXRes();
            double sid_ulx = this.sidInfo.getUpperLeftX();
            double sid_uly = this.sidInfo.getUpperLeftY();
            int image_x = 0;
            int image_y = 0;
            int image_w = viewport.getPanel().getWidth();
            int image_h = viewport.getPanel().getHeight();
            Envelope vpEnvelope = viewport.getEnvelopeInModelCoordinates();
            double view_res = 1.0 / viewport.getScale();
            double rwViewLeft = vpEnvelope.getMinX();
            double rwViewRight = vpEnvelope.getMaxX();
            double rwViewTop = vpEnvelope.getMaxY();
            double rwViewBot = vpEnvelope.getMinY();
            double halfPixel = 0.5 * sid_xres;
            double rwSidFileLeftEdge = sid_ulx - halfPixel;
            double rwSidFileRightEdge = rwSidFileLeftEdge + (double)sidPixelWidth * sid_xres;
            double rwSidFileTopEdge = sid_uly + halfPixel;
            double rwSidFileBotEdge = rwSidFileTopEdge - (double)sidPixelHeight * sid_xres;
            double rwRasterLeft = Math.max(rwViewLeft, rwSidFileLeftEdge);
            double rwRasterRight = Math.min(rwViewRight, rwSidFileRightEdge);
            double rwRasterTop = Math.min(rwViewTop, rwSidFileTopEdge);
            double rwRasterBot = Math.max(rwViewBot, rwSidFileBotEdge);
            double rwViewWidth = rwViewRight - rwViewLeft;
            double widthInFilePixels = rwViewWidth / sid_xres;
            double widthInViewPixels = rwViewWidth / view_res;
            int sidLevel = (int)Math.round(Math.log(widthInFilePixels / widthInViewPixels) / Math.log(2.0));
            if (sidLevel < 0) {
                sidLevel = 0;
            }
            if (sidLevel > this.sidInfo.getNumLevels()) {
                sidLevel = this.sidInfo.getNumLevels();
            }
            double lvlres = sid_xres * Math.pow(2.0, sidLevel);
            viewport.getPanel().getContext().setStatusMessage("MrSID  " + sidLevel + " OF " + this.sidInfo.getNumLevels());
            int sidLvlPixelWidth = sidPixelWidth;
            int sidLvlPixelHeight = sidPixelHeight;
            for (int lvl = 0; lvl < sidLevel; ++lvl) {
                sidLvlPixelWidth = this.round(0.5 * (double)sidLvlPixelWidth);
                sidLvlPixelHeight = this.round(0.5 * (double)sidLvlPixelHeight);
            }
            halfPixel = 0.5 * lvlres;
            rwSidFileLeftEdge = sid_ulx - halfPixel;
            rwSidFileRightEdge = rwSidFileLeftEdge + (double)sidLvlPixelWidth * lvlres;
            rwSidFileTopEdge = sid_uly + halfPixel;
            rwSidFileBotEdge = rwSidFileTopEdge - (double)sidLvlPixelHeight * lvlres;
            if (!(rwSidFileRightEdge <= rwViewLeft || rwSidFileLeftEdge >= rwViewRight || rwSidFileTopEdge <= rwViewBot || rwSidFileBotEdge >= rwViewTop)) {
                int sid_h;
                int sidLeftPixel = (int)((rwRasterLeft - rwSidFileLeftEdge) / lvlres);
                int sidRightPixel = (int)((rwRasterRight - rwSidFileLeftEdge) / lvlres);
                if (sidRightPixel == sidLvlPixelWidth) {
                    sidRightPixel = sidLvlPixelWidth - 1;
                }
                int sidTopPixel = (int)((rwSidFileTopEdge - rwRasterTop) / lvlres);
                int sidBotPixel = (int)((rwSidFileTopEdge - rwRasterBot) / lvlres);
                if (sidBotPixel == sidLvlPixelHeight) {
                    sidBotPixel = sidLvlPixelHeight - 1;
                }
                double rwSidLeft = rwSidFileLeftEdge + (double)sidLeftPixel * lvlres;
                double rwSidRight = rwSidFileLeftEdge + (double)sidRightPixel * lvlres + lvlres;
                double rwSidTop = rwSidFileTopEdge - (double)sidTopPixel * lvlres;
                double rwSidBot = rwSidFileTopEdge - (double)sidBotPixel * lvlres - lvlres;
                int leftOffset = this.round((rwRasterLeft - rwSidLeft) / view_res);
                int rightOffset = this.round((rwSidRight - rwRasterRight) / view_res);
                int topOffset = this.round((rwSidTop - rwRasterTop) / view_res);
                int botOffset = this.round((rwRasterBot - rwSidBot) / view_res);
                int sid_x = sidLeftPixel;
                int sid_y = sidTopPixel;
                int sid_w = sidRightPixel - sidLeftPixel + 1;
                if (sid_w <= 0) {
                    sid_w = 1;
                }
                if ((sid_h = sidBotPixel - sidTopPixel + 1) <= 0) {
                    sid_h = 1;
                }
                image_x = this.round(rwRasterLeft / view_res) - this.round(rwViewLeft / view_res);
                image_w = this.round(rwRasterRight / view_res) - this.round(rwRasterLeft / view_res);
                if (image_w <= 0) {
                    image_w = 1;
                }
                image_y = this.round(rwViewTop / view_res) - this.round(rwRasterTop / view_res);
                image_h = this.round(rwRasterTop / view_res) - this.round(rwRasterBot / view_res);
                if (image_h <= 0) {
                    image_h = 1;
                }
                image_x -= leftOffset;
                image_y -= topOffset;
                image_w += leftOffset + rightOffset;
                image_h += topOffset + botOffset;
                try {
                    File jpgDir = new File(MrSIDImageFactory.TMP_PATH);
                    File jpgFile = File.createTempFile("Temp", ".jpg", jpgDir);
                    String jpgFilename = jpgFile.getCanonicalPath();
                    String[] runStr = new String[]{MrSIDImageFactory.MRSIDDECODE, "-i", this.sidFilename, "-s", "" + sidLevel, "-ulxy", "" + sid_x, "" + sid_y, "-wh", "" + sid_w, "" + sid_h, "-o", jpgFilename, "-jpg", "-quiet", "-coord", "image", "-drmin", "" + sidDRmin, "-drmax", "" + sidDRmax};
                    Process p = Runtime.getRuntime().exec(runStr);
                    p.waitFor();
                    p.destroy();
                    if (jpgFile.exists() && jpgFile.isFile() && jpgFile.canRead()) {
                        RenderedOp image = FileLoadDescriptor.create((String)jpgFile.getPath(), null, null, null);
                        int jpg_colorspace = image.getColorModel().getColorSpace().getType();
                        if (jpg_colorspace != 1) {
                            RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            g.setRenderingHints(rh);
                        }
                        Composite composite = g.getComposite();
                        g.setComposite(AlphaComposite.Src);
                        BufferedImage img = image.getAsBufferedImage();
                        g.drawImage(img, image_x, image_y, image_w, image_h, viewport.getPanel());
                        g.setComposite(composite);
                        boolean done = false;
                        done = jpgFile.delete();
                        if (!done) {
                            jpgFile.delete();
                        }
                        if (!done) {
                            jpgFile.deleteOnExit();
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new JUMPException(t.getMessage());
                }
            }
        }
    }

    private int round(double num) {
        return (int)Math.round(num);
    }

    public String getType() {
        return "MrSID";
    }
}

