/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.cache;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.Query;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.util.ListWrapper;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;

public class DynamicFeatureCollection
implements FeatureCollection {
    private Integer featureLimit = null;
    private FilterQuery spatialQuery;
    private ConnectionManager connectionManager;
    private ConnectionDescriptor connectionDescriptor;
    private volatile Object currentQueryContext;
    private FeatureSchema schema = AddNewLayerPlugIn.createBlankFeatureCollection().getFeatureSchema();

    public DynamicFeatureCollection(ConnectionDescriptor connectionDescriptor, ConnectionManager connectionManager, FilterQuery spatialQuery) {
        this.connectionManager = connectionManager;
        this.connectionDescriptor = connectionDescriptor;
        this.spatialQuery = spatialQuery;
    }

    public void setFeatureLimit(Integer featureLimit) {
        this.featureLimit = featureLimit;
    }

    public FeatureSchema getFeatureSchema() {
        return this.schema;
    }

    public List query(Envelope envelope) {
        FeatureInputStream myFeatureInputStream;
        Object myQueryContext;
        this.currentQueryContext = myQueryContext = new Object();
        Envelope layerExtents = this.getEnvelope();
        if (layerExtents == null || layerExtents.isNull() || layerExtents.contains(envelope)) {
            this.spatialQuery.setFilterGeometry(new GeometryFactory().toGeometry(envelope));
        } else {
            this.spatialQuery.setFilterGeometry(new GeometryFactory().toGeometry(layerExtents.intersection(envelope)));
        }
        try {
            myFeatureInputStream = this.connectionManager.getOpenConnection(this.connectionDescriptor).execute((Query)this.spatialQuery);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (myQueryContext != this.currentQueryContext) {
            return Collections.EMPTY_LIST;
        }
        this.schema = myFeatureInputStream.getFeatureSchema();
        return new ListWrapper(){

            public Collection getCollection() {
                throw new UnsupportedOperationException();
            }

            public Iterator iterator() {
                return new Iterator(){
                    private int featuresReturned = 0;
                    private boolean featureInputStreamOpen = true;

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean hasNext() {
                        try {
                            if (DynamicFeatureCollection.this.featureLimit != null && this.featuresReturned >= DynamicFeatureCollection.this.featureLimit) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            if (myQueryContext != DynamicFeatureCollection.this.currentQueryContext) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            if (!this.featureInputStreamOpen) {
                                return false;
                            }
                            if (!myFeatureInputStream.hasNext()) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }

                    private void closeFeatureInputStream() throws Exception {
                        myFeatureInputStream.close();
                        this.featureInputStreamOpen = false;
                    }

                    public Object next() {
                        DynamicFeatureCollection.this.assertNotInGUIThread();
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            ++this.featuresReturned;
                            return myFeatureInputStream.next();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    public void add(Feature feature) {
        throw new UnsupportedOperationException();
    }

    public void addAll(Collection features) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection features) {
        throw new UnsupportedOperationException();
    }

    public void remove(Feature feature) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Collection remove(Envelope env) {
        throw new UnsupportedOperationException();
    }

    public Envelope getEnvelope() {
        DataStoreMetadata dsm;
        DataStoreConnection dsc = null;
        try {
            dsc = this.connectionManager.getOpenConnection(this.connectionDescriptor);
        }
        catch (Exception e1) {
            return new Envelope();
        }
        Envelope e = null;
        if (dsc != null && (dsm = dsc.getMetadata()) != null && this.spatialQuery != null) {
            e = dsm.getExtents(this.spatialQuery.getDatasetName(), this.spatialQuery.getGeometryAttributeName());
        }
        return e;
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public List getFeatures() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    private void assertNotInGUIThread() {
        Assert.isTrue((!SwingUtilities.isEventDispatchThread() ? 1 : 0) != 0, (String)"This operation should be done outside of the GUI thread");
    }
}

