/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class ColumnBasedTableModel
implements TableModel {
    private ArrayList columns = new ArrayList();
    private ArrayList listeners = new ArrayList();
    private boolean firingEvents = true;

    protected Column getColumn(int column) {
        return (Column)this.columns.get(column);
    }

    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int columnIndex) {
        return this.getColumn(columnIndex).getName();
    }

    public int indexOfColumn(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = (Column)this.columns.get(i);
            if (!column.getName().equals(name)) continue;
            return i;
        }
        Assert.shouldNeverReachHere((String)name);
        return -1;
    }

    protected void setColumns(Collection columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public Class getColumnClass(int columnIndex) {
        return this.getColumn(columnIndex).getDataClass();
    }

    protected void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    protected boolean isFiringEvents() {
        return this.firingEvents;
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(e);
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getColumn(columnIndex).getValueAt(rowIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getColumn(columnIndex).setValueAt(aValue, rowIndex);
    }

    public abstract class Column {
        private String name;
        private Class dataClass;

        public Column(String name, Class dataClass) {
            this.name = name;
            this.dataClass = dataClass;
        }

        public String getName() {
            return this.name;
        }

        public Class getDataClass() {
            return this.dataClass;
        }

        public abstract Object getValueAt(int var1);

        public abstract void setValueAt(Object var1, int var2);
    }
}

