/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OptionsDialog
extends JDialog {
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static String sOptions = I18N.get((String)"com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn");

    private OptionsDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Assert.shouldNeverReachHere((String)ex.getMessage());
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                OptionsDialog.this.fireInit();
            }
        });
        this.okCancelPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.okCancelPanel.wasOKPressed()) {
                    String errorMessage = OptionsDialog.this.validateInput();
                    if (errorMessage != null) {
                        JOptionPane.showMessageDialog(OptionsDialog.this, errorMessage, "JUMP", 0);
                        return;
                    }
                    OptionsDialog.this.fireOKPressed();
                    OptionsDialog.this.setVisible(false);
                    return;
                }
                OptionsDialog.this.setVisible(false);
            }
        });
    }

    public static OptionsDialog instance(JUMPWorkbench workbench) {
        return OptionsDialog.instance(workbench.getBlackboard(), workbench.getFrame());
    }

    public static OptionsDialog instance(Blackboard blackboard, Frame frame) {
        if (blackboard.get(OptionsDialog.class + " - INSTANCE") == null) {
            return (OptionsDialog)blackboard.get(OptionsDialog.class + " - INSTANCE", (Object)new OptionsDialog(frame, sOptions, true));
        }
        return (OptionsDialog)blackboard.get(OptionsDialog.class + " - INSTANCE");
    }

    private void fireOKPressed() {
        for (OptionsPanel panel : this.optionsPanels()) {
            panel.okPressed();
        }
    }

    private void fireInit() {
        for (OptionsPanel panel : this.optionsPanels()) {
            panel.init();
        }
    }

    private Collection optionsPanels() {
        ArrayList<Component> optionsPanels = new ArrayList<Component>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            optionsPanels.add(this.tabbedPane.getComponentAt(i));
        }
        return optionsPanels;
    }

    private String validateInput() {
        for (OptionsPanel panel : this.optionsPanels()) {
            String errorMessage = panel.validateInput();
            if (errorMessage == null) continue;
            return errorMessage;
        }
        return null;
    }

    public void addTab(String title, OptionsPanel panel) {
        this.addTab(title, null, panel);
    }

    public void addTab(String title, Icon icon, OptionsPanel panel) {
        this.tabbedPane.addTab(title, icon, (Component)((Object)panel));
        this.pack();
    }

    private void jbInit() throws Exception {
        JPanel strut = new JPanel();
        strut.setPreferredSize(new Dimension(280, 0));
        this.getContentPane().add((Component)strut, "North");
        this.panel1.setLayout(this.borderLayout1);
        this.setModal(true);
        this.setTitle(sOptions);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.okCancelPanel, "South");
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }
}

