/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.FirableTreeModelWrapper;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerTreeCellEditor;
import com.vividsolutions.jump.workbench.ui.LayerTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.PopupNodeProxy;
import com.vividsolutions.jump.workbench.ui.TreeUtil;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeLayerNamePanel
extends JPanel
implements LayerListener,
LayerNamePanel,
LayerNamePanelProxy,
PopupNodeProxy {
    private Map nodeClassToPopupMenuMap = new HashMap();
    BorderLayout borderLayout1 = new BorderLayout();
    JTree tree = new JTree(){

        public boolean isPathEditable(TreePath path) {
            if (!this.isEditable()) {
                return false;
            }
            return path.getLastPathComponent() instanceof Layerable || path.getLastPathComponent() instanceof Category;
        }

        public boolean hasBeenExpanded(TreePath path) {
            return super.hasBeenExpanded(path) || !this.getModel().isLeaf(path.getLastPathComponent());
        }
    };
    private LayerTreeCellRenderer layerTreeCellRenderer;
    private TreeCellEditor cellEditor = new LayerTreeCellEditor(this.tree);
    private Object popupNode;
    private ArrayList listeners = new ArrayList();
    private LayerManagerProxy layerManagerProxy;
    JScrollPane scrollPane = new JScrollPane();
    private FirableTreeModelWrapper firableTreeModelWrapper;
    private TreePath movingTreePath = null;
    private boolean firstTimeDragging = true;

    public TreeLayerNamePanel(LayerManagerProxy layerManagerProxy, TreeModel treeModel, RenderingManager renderingManager, Map additionalNodeClassToTreeCellRendererMap) {
        layerManagerProxy.getLayerManager().addLayerListener(this);
        this.layerManagerProxy = layerManagerProxy;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.firableTreeModelWrapper = new FirableTreeModelWrapper(treeModel);
        this.tree.setModel(this.firableTreeModelWrapper);
        this.layerTreeCellRenderer = new LayerTreeCellRenderer(renderingManager);
        renderingManager.getPanel().getViewport().addListener(new ViewportListener(){

            public void zoomChanged(Envelope modelEnvelope) {
                TreeLayerNamePanel.this.repaint();
            }
        });
        this.setCellRenderer(additionalNodeClassToTreeCellRendererMap);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreeLayerNamePanel.this.handleCheckBoxClick(e);
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TreeLayerNamePanel.this.movingTreePath = TreeLayerNamePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (TreeLayerNamePanel.this.movingTreePath != null && !(TreeLayerNamePanel.this.movingTreePath.getLastPathComponent() instanceof Layerable)) {
                        TreeLayerNamePanel.this.movingTreePath = null;
                    }
                } else {
                    TreeLayerNamePanel.this.movingTreePath = null;
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1 || TreeLayerNamePanel.this.movingTreePath == null) {
                    return;
                }
                Object node = TreeLayerNamePanel.this.movingTreePath.getLastPathComponent();
                TreePath tpDestination = TreeLayerNamePanel.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                TreeLayerNamePanel.this.movingTreePath = null;
                TreeLayerNamePanel.this.firstTimeDragging = true;
                if (tpDestination == null) {
                    return;
                }
                TreeLayerNamePanel.this.tree.repaint();
                if (node instanceof Layerable) {
                    Layerable layerable = (Layerable)node;
                    int index = 0;
                    Category cat = null;
                    if (tpDestination.getLastPathComponent() instanceof Layerable) {
                        if (layerable == tpDestination.getLastPathComponent()) {
                            return;
                        }
                        cat = TreeLayerNamePanel.this.getLayerManager().getCategory((Layerable)tpDestination.getLastPathComponent());
                        index = TreeLayerNamePanel.this.tree.getModel().getIndexOfChild(tpDestination.getParentPath().getLastPathComponent(), tpDestination.getLastPathComponent());
                    } else if (tpDestination.getLastPathComponent() instanceof Category) {
                        cat = (Category)tpDestination.getLastPathComponent();
                        if (cat.contains(layerable)) {
                            return;
                        }
                    } else {
                        return;
                    }
                    TreeLayerNamePanel.this.getLayerManager().remove(layerable);
                    cat.add(index, layerable);
                    TreeLayerNamePanel.this.getLayerManager().fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
                }
            }
        });
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){
            int rowNew;
            int rowOld = -1;
            Rectangle dragBar;

            public void mouseDragged(MouseEvent e) {
                if (TreeLayerNamePanel.this.movingTreePath == null) {
                    TreeLayerNamePanel.this.firstTimeDragging = true;
                    return;
                }
                this.rowNew = TreeLayerNamePanel.this.tree.getClosestRowForLocation(e.getX(), e.getY());
                this.rowOld = TreeLayerNamePanel.this.tree.getRowForPath(TreeLayerNamePanel.this.movingTreePath);
                if (this.rowNew == this.rowOld) {
                    return;
                }
                if (!(TreeLayerNamePanel.this.tree.getPathForRow(this.rowNew).getLastPathComponent() instanceof Layer)) {
                    TreeLayerNamePanel.this.tree.expandRow(this.rowNew);
                }
                Graphics2D g2 = (Graphics2D)TreeLayerNamePanel.this.tree.getGraphics();
                g2.setColor(Color.RED);
                g2.setXORMode(Color.WHITE);
                if (TreeLayerNamePanel.this.firstTimeDragging) {
                    this.rowOld = this.rowNew;
                    this.dragBar = new Rectangle(0, 0, TreeLayerNamePanel.this.tree.getWidth(), 3);
                    g2.fill(this.dragBar);
                    TreeLayerNamePanel.this.firstTimeDragging = false;
                }
                g2.fill(this.dragBar);
                this.dragBar.setLocation(0, TreeLayerNamePanel.this.tree.getRowBounds((int)this.rowNew).y);
                g2.fill(this.dragBar);
                this.rowOld = this.rowNew;
            }
        });
        this.tree.setCellEditor(this.cellEditor);
        this.tree.setInvokesStopCellEditing(true);
        this.tree.setBackground(this.getBackground());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeLayerNamePanel.this.fireLayerSelectionChanged();
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
                for (int i = 0; i < e.getChildren().length; ++i) {
                    TreeUtil.visit(TreeLayerNamePanel.this.tree.getModel(), e.getTreePath().pathByAddingChild(e.getChildren()[i]), new TreeUtil.Visitor(){

                        public void visit(Stack path) {
                            if (path.peek() instanceof LayerTreeModel.ColorThemingValue) {
                                return;
                            }
                            TreeLayerNamePanel.this.tree.makeVisible(new TreePath(path.toArray()));
                        }
                    });
                }
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        TreeUtil.expandAll(this.tree, new TreePath(this.tree.getModel().getRoot()));
    }

    public void addPopupMenu(Class nodeClass, JPopupMenu popupMenu) {
        this.nodeClassToPopupMenuMap.put(nodeClass, popupMenu);
    }

    private void setCellRenderer(Map additionalNodeClassToTreeCellRendererMap) {
        final Map map = this.createNodeClassToTreeCellRendererMap();
        map.putAll(additionalNodeClassToTreeCellRendererMap);
        this.tree.setCellRenderer(new TreeCellRenderer(){
            private DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer(){
                {
                    this.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
                }
            };

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return ((TreeCellRenderer)LangUtil.ifNull((Object)CollectionUtil.get(value.getClass(), (Map)map), (Object)this.defaultRenderer)).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        });
    }

    private Map createNodeClassToTreeCellRendererMap() {
        HashMap<Class, TreeCellRenderer> map = new HashMap<Class, TreeCellRenderer>();
        map.put(Layer.class, this.layerTreeCellRenderer);
        map.put(WMSLayer.class, this.layerTreeCellRenderer);
        map.put(Category.class, this.layerTreeCellRenderer);
        map.put(LayerTreeModel.ColorThemingValue.class, this.createColorThemingValueRenderer());
        return map;
    }

    private TreeCellRenderer createColorThemingValueRenderer() {
        return new TreeCellRenderer(){
            private JPanel panel = new JPanel(new GridBagLayout());
            private ColorPanel colorPanel = new ColorPanel();
            private JLabel label = new JLabel();
            {
                this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.label.setText(((LayerTreeModel.ColorThemingValue)value).toString());
                BasicStyle style = ((LayerTreeModel.ColorThemingValue)value).getStyle();
                this.colorPanel.setLineColor(style.isRenderingLine() ? GUIUtil.alphaColor(style.getLineColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                this.colorPanel.setFillColor(style.isRenderingFill() ? GUIUtil.alphaColor(style.getFillColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                return this.panel;
            }
        };
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                TreeLayerNamePanel.this.tree_mouseReleased(e);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setEditable(true);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(-1);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tree.setShowsRootHandles(true);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.getViewport().add(this.tree);
        this.add((Component)this.scrollPane, "Center");
    }

    void tree_mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        TreePath popupPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (popupPath == null) {
            return;
        }
        this.popupNode = popupPath.getLastPathComponent();
        if (!(e.isControlDown() || e.isShiftDown() || this.selectedNodes(Object.class).contains(this.popupNode))) {
            this.tree.getSelectionModel().clearSelection();
        }
        this.tree.getSelectionModel().addSelectionPath(popupPath);
        if (this.getPopupMenu(this.popupNode.getClass()) != null) {
            this.getPopupMenu(this.popupNode.getClass()).show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu getPopupMenu(Class nodeClass) {
        return (JPopupMenu)CollectionUtil.get((Class)nodeClass, (Map)this.nodeClassToPopupMenuMap);
    }

    private void handleCheckBoxClick(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (!(node instanceof Layerable)) {
            return;
        }
        Layerable layerable = (Layerable)node;
        Point layerNodeLocation = this.tree.getUI().getPathBounds(this.tree, path).getLocation();
        this.layerTreeCellRenderer.getLayerNameRenderer().getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), false, false, false, 0, false);
        Rectangle checkBoxBounds = this.layerTreeCellRenderer.getLayerNameRenderer().getCheckBoxBounds();
        checkBoxBounds.translate((int)layerNodeLocation.getX(), (int)layerNodeLocation.getY());
        if (checkBoxBounds.contains(e.getPoint())) {
            layerable.setVisible(!layerable.isVisible());
        }
    }

    public Layer[] getSelectedLayers() {
        return TreeLayerNamePanel.selectedLayers(this);
    }

    public static Layer[] selectedLayers(LayerNamePanel layerNamePanel) {
        return layerNamePanel.selectedNodes(Layer.class).toArray(new Layer[0]);
    }

    public Collection getSelectedCategories() {
        return this.selectedNodes(Category.class);
    }

    public Collection selectedNodes(Class c) {
        return TreeLayerNamePanel.selectedNodes(c, this.tree);
    }

    public static Collection selectedNodes(Class c, JTree tree) {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return new ArrayList();
        }
        for (int i = 0; i < selectionPaths.length; ++i) {
            Object node = selectionPaths[i].getLastPathComponent();
            if (!c.isInstance(node)) continue;
            selectedNodes.add(node);
        }
        return selectedNodes;
    }

    public void setSelectedLayers(Layer[] layers) {
        this.tree.getSelectionModel().clearSelection();
        for (int i = 0; i < layers.length; ++i) {
            this.addSelectedLayer(layers[i]);
        }
    }

    protected void addSelectedLayer(Layer layer) {
        this.tree.addSelectionPath(TreeUtil.findTreePath(layer, this.tree.getModel()));
    }

    public void layerChanged(final LayerEvent e) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree.getModel().getRoot(), e.getCategory()}, new int[]{e.getLayerableIndex()}, new Object[]{e.getLayerable()});
        if (e.getType() == LayerEventType.ADDED) {
            this.firableTreeModelWrapper.fireTreeNodesInserted(treeModelEvent);
            if (e.getType() == LayerEventType.ADDED && this.selectedNodes(Layerable.class).size() == 0 && e.getLayerable() instanceof Layer) {
                this.addSelectedLayer((Layer)e.getLayerable());
            }
            return;
        }
        if (e.getType() == LayerEventType.REMOVED) {
            this.firableTreeModelWrapper.fireTreeNodesRemoved(treeModelEvent);
            return;
        }
        if (e.getType() == LayerEventType.APPEARANCE_CHANGED) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeLayerNamePanel.this.firableTreeModelWrapper.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{TreeLayerNamePanel.this.tree.getModel().getRoot(), e.getCategory(), e.getLayerable()}));
                }
            });
            return;
        }
        if (e.getType() == LayerEventType.METADATA_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        Assert.shouldNeverReachHere();
    }

    public void categoryChanged(CategoryEvent e) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree.getModel().getRoot()}, new int[]{e.getCategoryIndex() + this.indexOfFirstCategoryInTree()}, new Object[]{e.getCategory()});
        if (e.getType() == CategoryEventType.ADDED) {
            this.firableTreeModelWrapper.fireTreeNodesInserted(treeModelEvent);
            return;
        }
        if (e.getType() == CategoryEventType.REMOVED) {
            this.firableTreeModelWrapper.fireTreeNodesRemoved(treeModelEvent);
            return;
        }
        if (e.getType() == CategoryEventType.METADATA_CHANGED) {
            this.firableTreeModelWrapper.fireTreeNodesChanged(treeModelEvent);
            return;
        }
        Assert.shouldNeverReachHere();
    }

    private int indexOfFirstCategoryInTree() {
        for (int i = 0; i < this.tree.getModel().getChildCount(this.tree.getModel().getRoot()); ++i) {
            if (!(this.tree.getModel().getChild(this.tree.getModel().getRoot(), i) instanceof Category)) continue;
            return i;
        }
        Assert.shouldNeverReachHere();
        return -1;
    }

    public void featuresChanged(FeatureEvent e) {
    }

    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void addListener(LayerNamePanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LayerNamePanelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLayerSelectionChanged() {
        for (LayerNamePanelListener l : this.listeners) {
            l.layerSelectionChanged();
        }
    }

    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    public static Layer chooseEditableLayer(LayerNamePanel panel) {
        for (Layer layer : Arrays.asList(panel.getSelectedLayers())) {
            if (!layer.isEditable()) continue;
            return layer;
        }
        if (panel.getLayerManager().getEditableLayers().isEmpty()) {
            return null;
        }
        return (Layer)panel.getLayerManager().getEditableLayers().iterator().next();
    }

    public Layer chooseEditableLayer() {
        return TreeLayerNamePanel.chooseEditableLayer(this);
    }

    public LayerNamePanel getLayerNamePanel() {
        return this;
    }

    protected FirableTreeModelWrapper getFirableTreeModelWrapper() {
        return this.firableTreeModelWrapper;
    }

    public Object getPopupNode() {
        return this.popupNode;
    }

    protected LayerTreeCellRenderer getLayerTreeCellRenderer() {
        return this.layerTreeCellRenderer;
    }
}

